// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartWorkflowExecutionOperationDeserializer: HttpDeserialize<StartWorkflowExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): StartWorkflowExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwStartWorkflowExecutionError(context, call)
        }
        val builder = StartWorkflowExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartWorkflowExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwStartWorkflowExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DefaultUndefinedFault" -> DefaultUndefinedFaultDeserializer().deserialize(context, wrappedCall)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall)
        "TypeDeprecatedFault" -> TypeDeprecatedFaultDeserializer().deserialize(context, wrappedCall)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall)
        "WorkflowExecutionAlreadyStartedFault" -> WorkflowExecutionAlreadyStartedFaultDeserializer().deserialize(context, wrappedCall)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartWorkflowExecutionOperationBody(builder: StartWorkflowExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RUNID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("runId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RUNID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RUNID_DESCRIPTOR.index -> builder.runId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
