// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.HistoryEvent
import aws.sdk.kotlin.services.swf.model.PollForDecisionTaskResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.WorkflowExecution
import aws.sdk.kotlin.services.swf.model.WorkflowType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class PollForDecisionTaskOperationDeserializer: HttpDeserialize<PollForDecisionTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PollForDecisionTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPollForDecisionTaskError(context, call)
        }
        val builder = PollForDecisionTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePollForDecisionTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPollForDecisionTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePollForDecisionTaskOperationBody(builder: PollForDecisionTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("events"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextPageToken"))
    val PREVIOUSSTARTEDEVENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("previousStartedEventId"))
    val STARTEDEVENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("startedEventId"))
    val TASKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskToken"))
    val WORKFLOWEXECUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("workflowExecution"))
    val WORKFLOWTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("workflowType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTS_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
        field(PREVIOUSSTARTEDEVENTID_DESCRIPTOR)
        field(STARTEDEVENTID_DESCRIPTOR)
        field(TASKTOKEN_DESCRIPTOR)
        field(WORKFLOWEXECUTION_DESCRIPTOR)
        field(WORKFLOWTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTS_DESCRIPTOR.index -> builder.events =
                    deserializer.deserializeList(EVENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<HistoryEvent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeHistoryEventDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                PREVIOUSSTARTEDEVENTID_DESCRIPTOR.index -> builder.previousStartedEventId = deserializeLong()
                STARTEDEVENTID_DESCRIPTOR.index -> builder.startedEventId = deserializeLong()
                TASKTOKEN_DESCRIPTOR.index -> builder.taskToken = deserializeString()
                WORKFLOWEXECUTION_DESCRIPTOR.index -> builder.workflowExecution = deserializeWorkflowExecutionDocument(deserializer)
                WORKFLOWTYPE_DESCRIPTOR.index -> builder.workflowType = deserializeWorkflowTypeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
