// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.ActivityType
import aws.sdk.kotlin.services.swf.model.PollForActivityTaskResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.WorkflowExecution
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PollForActivityTaskOperationDeserializer: HttpDeserialize<PollForActivityTaskResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): PollForActivityTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPollForActivityTaskError(context, call)
        }
        val builder = PollForActivityTaskResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePollForActivityTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwPollForActivityTaskError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePollForActivityTaskOperationBody(builder: PollForActivityTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("activityId"))
    val ACTIVITYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("activityType"))
    val INPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("input"))
    val STARTEDEVENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("startedEventId"))
    val TASKTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("taskToken"))
    val WORKFLOWEXECUTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("workflowExecution"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVITYID_DESCRIPTOR)
        field(ACTIVITYTYPE_DESCRIPTOR)
        field(INPUT_DESCRIPTOR)
        field(STARTEDEVENTID_DESCRIPTOR)
        field(TASKTOKEN_DESCRIPTOR)
        field(WORKFLOWEXECUTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVITYID_DESCRIPTOR.index -> builder.activityId = deserializeString()
                ACTIVITYTYPE_DESCRIPTOR.index -> builder.activityType = deserializeActivityTypeDocument(deserializer)
                INPUT_DESCRIPTOR.index -> builder.input = deserializeString()
                STARTEDEVENTID_DESCRIPTOR.index -> builder.startedEventId = deserializeLong()
                TASKTOKEN_DESCRIPTOR.index -> builder.taskToken = deserializeString()
                WORKFLOWEXECUTION_DESCRIPTOR.index -> builder.workflowExecution = deserializeWorkflowExecutionDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
