// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListClosedWorkflowExecutionsOperationDeserializer: HttpDeserialize<ListClosedWorkflowExecutionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListClosedWorkflowExecutionsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListClosedWorkflowExecutionsError(context, call)
        }
        val builder = ListClosedWorkflowExecutionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListClosedWorkflowExecutionsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListClosedWorkflowExecutionsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListClosedWorkflowExecutionsOperationBody(builder: ListClosedWorkflowExecutionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXECUTIONINFOS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("executionInfos"))
    val NEXTPAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextPageToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXECUTIONINFOS_DESCRIPTOR)
        field(NEXTPAGETOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXECUTIONINFOS_DESCRIPTOR.index -> builder.executionInfos =
                    deserializer.deserializeList(EXECUTIONINFOS_DESCRIPTOR) {
                        val col0 = mutableListOf<WorkflowExecutionInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWorkflowExecutionInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTPAGETOKEN_DESCRIPTOR.index -> builder.nextPageToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
