// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.DescribeWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.WorkflowExecutionConfiguration
import aws.sdk.kotlin.services.swf.model.WorkflowExecutionInfo
import aws.sdk.kotlin.services.swf.model.WorkflowExecutionOpenCounts
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeWorkflowExecutionOperationDeserializer: HttpDeserialize<DescribeWorkflowExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeWorkflowExecutionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeWorkflowExecutionError(context, call)
        }
        val builder = DescribeWorkflowExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeWorkflowExecutionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeWorkflowExecutionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeWorkflowExecutionOperationBody(builder: DescribeWorkflowExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXECUTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("executionConfiguration"))
    val EXECUTIONINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("executionInfo"))
    val LATESTACTIVITYTASKTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("latestActivityTaskTimestamp"))
    val LATESTEXECUTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("latestExecutionContext"))
    val OPENCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("openCounts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXECUTIONCONFIGURATION_DESCRIPTOR)
        field(EXECUTIONINFO_DESCRIPTOR)
        field(LATESTACTIVITYTASKTIMESTAMP_DESCRIPTOR)
        field(LATESTEXECUTIONCONTEXT_DESCRIPTOR)
        field(OPENCOUNTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXECUTIONCONFIGURATION_DESCRIPTOR.index -> builder.executionConfiguration = deserializeWorkflowExecutionConfigurationDocument(deserializer)
                EXECUTIONINFO_DESCRIPTOR.index -> builder.executionInfo = deserializeWorkflowExecutionInfoDocument(deserializer)
                LATESTACTIVITYTASKTIMESTAMP_DESCRIPTOR.index -> builder.latestActivityTaskTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                LATESTEXECUTIONCONTEXT_DESCRIPTOR.index -> builder.latestExecutionContext = deserializeString()
                OPENCOUNTS_DESCRIPTOR.index -> builder.openCounts = deserializeWorkflowExecutionOpenCountsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
