// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.serde

import aws.sdk.kotlin.services.swf.model.DeprecateDomainResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeprecateDomainOperationDeserializer: HttpDeserialize<DeprecateDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeprecateDomainResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeprecateDomainError(context, call)
        }
        val builder = DeprecateDomainResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeprecateDomainError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DomainDeprecatedFault" -> DomainDeprecatedFaultDeserializer().deserialize(context, wrappedCall)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedCall)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedCall)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
