// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `ScheduleLambdaFunctionFailed` event. It isn't set for other event types.
 */
public class ScheduleLambdaFunctionFailedEventAttributes private constructor(builder: Builder) {
    /**
     * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.
     *
     * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
     */
    public val cause: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedCause = requireNotNull(builder.cause) { "A non-null value must be provided for cause" }
    /**
     * The ID of the `LambdaFunctionCompleted` event corresponding to the decision that resulted in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.
     */
    public val decisionTaskCompletedEventId: kotlin.Long = builder.decisionTaskCompletedEventId
    /**
     * The ID provided in the `ScheduleLambdaFunction` decision that failed.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The name of the Lambda function.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleLambdaFunctionFailedEventAttributes(")
        append("cause=$cause,")
        append("decisionTaskCompletedEventId=$decisionTaskCompletedEventId,")
        append("id=$id,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cause.hashCode()
        result = 31 * result + (decisionTaskCompletedEventId.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleLambdaFunctionFailedEventAttributes

        if (cause != other.cause) return false
        if (decisionTaskCompletedEventId != other.decisionTaskCompletedEventId) return false
        if (id != other.id) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The cause of the failure. To help diagnose issues, use this information to trace back the chain of events leading up to this event.
         *
         * If `cause` is set to `OPERATION_NOT_PERMITTED`, the decision failed because it lacked sufficient permissions. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
         */
        public var cause: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedCause? = null
        /**
         * The ID of the `LambdaFunctionCompleted` event corresponding to the decision that resulted in scheduling this Lambda task. To help diagnose issues, use this information to trace back the chain of events leading up to this event.
         */
        public var decisionTaskCompletedEventId: kotlin.Long = 0L
        /**
         * The ID provided in the `ScheduleLambdaFunction` decision that failed.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the Lambda function.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes) : this() {
            this.cause = x.cause
            this.decisionTaskCompletedEventId = x.decisionTaskCompletedEventId
            this.id = x.id
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes = ScheduleLambdaFunctionFailedEventAttributes(this)

        internal fun correctErrors(): Builder {
            if (cause == null) cause = ScheduleLambdaFunctionFailedCause.SdkUnknown("no value provided")
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
