// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `ScheduleActivityTask` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `activityType.name` – String constraint. The key is `swf:activityType.name`.
 *    + `activityType.version` – String constraint. The key is `swf:activityType.version`.
 *    + `taskList` – String constraint. The key is `swf:taskList.name`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class ScheduleActivityTaskDecisionAttributes private constructor(builder: Builder) {
    /**
     * The `activityId` of the activity task.
     *
     * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
     */
    public val activityId: kotlin.String = requireNotNull(builder.activityId) { "A non-null value must be provided for activityId" }
    /**
     * The type of the activity task to schedule.
     */
    public val activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = builder.activityType
    /**
     * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.
     */
    public val control: kotlin.String? = builder.control
    /**
     * If set, specifies the maximum time before which a worker processing a task of this type must report progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This overrides the default heartbeat timeout specified when registering the activity type using RegisterActivityType.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val heartbeatTimeout: kotlin.String? = builder.heartbeatTimeout
    /**
     * The input provided to the activity task.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The maximum duration for this activity task.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     *
     * A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at registration time then a fault is returned.
     */
    public val scheduleToCloseTimeout: kotlin.String? = builder.scheduleToCloseTimeout
    /**
     * If set, specifies the maximum duration the activity task can wait to be assigned to a worker. This overrides the default schedule-to-start timeout specified when registering the activity type using RegisterActivityType.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     *
     * A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at registration time then a fault is returned.
     */
    public val scheduleToStartTimeout: kotlin.String? = builder.scheduleToStartTimeout
    /**
     * If set, specifies the maximum duration a worker may take to process this activity task. This overrides the default start-to-close timeout specified when registering the activity type using RegisterActivityType.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     *
     * A start-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default start-to-close timeout was specified at registration time then a fault is returned.
     */
    public val startToCloseTimeout: kotlin.String? = builder.startToCloseTimeout
    /**
     * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the `defaultTaskList` registered with the activity type is used.
     *
     * A task list for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default task list was specified at registration time then a fault is returned.
     *
     * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * If set, specifies the priority with which the activity task is to be assigned to a worker. This overrides the defaultTaskPriority specified when registering the activity type using RegisterActivityType. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    public val taskPriority: kotlin.String? = builder.taskPriority

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleActivityTaskDecisionAttributes(")
        append("activityId=$activityId,")
        append("activityType=$activityType,")
        append("control=$control,")
        append("heartbeatTimeout=$heartbeatTimeout,")
        append("input=$input,")
        append("scheduleToCloseTimeout=$scheduleToCloseTimeout,")
        append("scheduleToStartTimeout=$scheduleToStartTimeout,")
        append("startToCloseTimeout=$startToCloseTimeout,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId.hashCode()
        result = 31 * result + (activityType?.hashCode() ?: 0)
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (heartbeatTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (scheduleToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (scheduleToStartTimeout?.hashCode() ?: 0)
        result = 31 * result + (startToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleActivityTaskDecisionAttributes

        if (activityId != other.activityId) return false
        if (activityType != other.activityType) return false
        if (control != other.control) return false
        if (heartbeatTimeout != other.heartbeatTimeout) return false
        if (input != other.input) return false
        if (scheduleToCloseTimeout != other.scheduleToCloseTimeout) return false
        if (scheduleToStartTimeout != other.scheduleToStartTimeout) return false
        if (startToCloseTimeout != other.startToCloseTimeout) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `activityId` of the activity task.
         *
         * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
         */
        public var activityId: kotlin.String? = null
        /**
         * The type of the activity task to schedule.
         */
        public var activityType: aws.sdk.kotlin.services.swf.model.ActivityType? = null
        /**
         * Data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the activity.
         */
        public var control: kotlin.String? = null
        /**
         * If set, specifies the maximum time before which a worker processing a task of this type must report progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded, the activity task is automatically timed out. If the worker subsequently attempts to record a heartbeat or returns a result, it is ignored. This overrides the default heartbeat timeout specified when registering the activity type using RegisterActivityType.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var heartbeatTimeout: kotlin.String? = null
        /**
         * The input provided to the activity task.
         */
        public var input: kotlin.String? = null
        /**
         * The maximum duration for this activity task.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         *
         * A schedule-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-close timeout was specified at registration time then a fault is returned.
         */
        public var scheduleToCloseTimeout: kotlin.String? = null
        /**
         * If set, specifies the maximum duration the activity task can wait to be assigned to a worker. This overrides the default schedule-to-start timeout specified when registering the activity type using RegisterActivityType.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         *
         * A schedule-to-start timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default schedule-to-start timeout was specified at registration time then a fault is returned.
         */
        public var scheduleToStartTimeout: kotlin.String? = null
        /**
         * If set, specifies the maximum duration a worker may take to process this activity task. This overrides the default start-to-close timeout specified when registering the activity type using RegisterActivityType.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         *
         * A start-to-close timeout for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default start-to-close timeout was specified at registration time then a fault is returned.
         */
        public var startToCloseTimeout: kotlin.String? = null
        /**
         * If set, specifies the name of the task list in which to schedule the activity task. If not specified, the `defaultTaskList` registered with the activity type is used.
         *
         * A task list for this activity task must be specified either as a default for the activity type or through this field. If neither this field is set nor a default task list was specified at registration time then a fault is returned.
         *
         * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * If set, specifies the priority with which the activity task is to be assigned to a worker. This overrides the defaultTaskPriority specified when registering the activity type using RegisterActivityType. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        public var taskPriority: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes) : this() {
            this.activityId = x.activityId
            this.activityType = x.activityType
            this.control = x.control
            this.heartbeatTimeout = x.heartbeatTimeout
            this.input = x.input
            this.scheduleToCloseTimeout = x.scheduleToCloseTimeout
            this.scheduleToStartTimeout = x.scheduleToStartTimeout
            this.startToCloseTimeout = x.startToCloseTimeout
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskDecisionAttributes = ScheduleActivityTaskDecisionAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityType] inside the given [block]
         */
        public fun activityType(block: aws.sdk.kotlin.services.swf.model.ActivityType.Builder.() -> kotlin.Unit) {
            this.activityType = aws.sdk.kotlin.services.swf.model.ActivityType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (activityId == null) activityId = ""
            return this
        }
    }
}
