// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Input data for a TaskCompleted response to a decision task.
 */
public class RespondDecisionTaskCompletedRequest private constructor(builder: Builder) {
    /**
     * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for the Decision structure for details.
     */
    public val decisions: List<Decision>? = builder.decisions
    /**
     * User defined context to add to workflow execution.
     */
    public val executionContext: kotlin.String? = builder.executionContext
    /**
     * The task list to use for the future decision tasks of this workflow execution. This list overrides the original task list you specified while starting the workflow execution.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon SWF will revert the override and schedule a new decision task to the original task list.
     *
     * If a decision task scheduled on the override task list is started within the timeout, but not completed within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the original task list.
     */
    public val taskListScheduleToStartTimeout: kotlin.String? = builder.taskListScheduleToStartTimeout
    /**
     * The `taskToken` from the DecisionTask.
     *
     * `taskToken` is generated by the service and should be treated as an opaque value. If the task is passed to another process, its `taskToken` must also be passed. This enables it to provide its progress and respond with results.
     */
    public val taskToken: kotlin.String? = builder.taskToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RespondDecisionTaskCompletedRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RespondDecisionTaskCompletedRequest(")
        append("decisions=$decisions,")
        append("executionContext=$executionContext,")
        append("taskList=$taskList,")
        append("taskListScheduleToStartTimeout=$taskListScheduleToStartTimeout,")
        append("taskToken=$taskToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = decisions?.hashCode() ?: 0
        result = 31 * result + (executionContext?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskListScheduleToStartTimeout?.hashCode() ?: 0)
        result = 31 * result + (taskToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RespondDecisionTaskCompletedRequest

        if (decisions != other.decisions) return false
        if (executionContext != other.executionContext) return false
        if (taskList != other.taskList) return false
        if (taskListScheduleToStartTimeout != other.taskListScheduleToStartTimeout) return false
        if (taskToken != other.taskToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RespondDecisionTaskCompletedRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of decisions (possibly empty) made by the decider while processing this decision task. See the docs for the Decision structure for details.
         */
        public var decisions: List<Decision>? = null
        /**
         * User defined context to add to workflow execution.
         */
        public var executionContext: kotlin.String? = null
        /**
         * The task list to use for the future decision tasks of this workflow execution. This list overrides the original task list you specified while starting the workflow execution.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * Specifies a timeout (in seconds) for the task list override. When this parameter is missing, the task list override is permanent. This parameter makes it possible to temporarily override the task list. If a decision task scheduled on the override task list is not started within the timeout, the decision task will time out. Amazon SWF will revert the override and schedule a new decision task to the original task list.
         *
         * If a decision task scheduled on the override task list is started within the timeout, but not completed within the start-to-close timeout, Amazon SWF will also revert the override and schedule a new decision task to the original task list.
         */
        public var taskListScheduleToStartTimeout: kotlin.String? = null
        /**
         * The `taskToken` from the DecisionTask.
         *
         * `taskToken` is generated by the service and should be treated as an opaque value. If the task is passed to another process, its `taskToken` must also be passed. This enables it to provide its progress and respond with results.
         */
        public var taskToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RespondDecisionTaskCompletedRequest) : this() {
            this.decisions = x.decisions
            this.executionContext = x.executionContext
            this.taskList = x.taskList
            this.taskListScheduleToStartTimeout = x.taskListScheduleToStartTimeout
            this.taskToken = x.taskToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RespondDecisionTaskCompletedRequest = RespondDecisionTaskCompletedRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
