// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `RequestCancelActivityTask` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + You cannot use an IAM policy to constrain this action's parameters.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class RequestCancelActivityTaskDecisionAttributes private constructor(builder: Builder) {
    /**
     * The `activityId` of the activity task to be canceled.
     */
    public val activityId: kotlin.String = requireNotNull(builder.activityId) { "A non-null value must be provided for activityId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestCancelActivityTaskDecisionAttributes(")
        append("activityId=$activityId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityId.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestCancelActivityTaskDecisionAttributes

        if (activityId != other.activityId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `activityId` of the activity task to be canceled.
         */
        public var activityId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes) : this() {
            this.activityId = x.activityId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskDecisionAttributes = RequestCancelActivityTaskDecisionAttributes(this)

        internal fun correctErrors(): Builder {
            if (activityId == null) activityId = ""
            return this
        }
    }
}
