// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



public class RegisterWorkflowTypeRequest private constructor(builder: Builder) {
    /**
     * If set, specifies the default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     */
    public val defaultChildPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = builder.defaultChildPolicy
    /**
     * If set, specifies the default maximum duration for executions of this workflow type. You can override this default when starting an execution through the StartWorkflowExecution Action or `StartChildWorkflowExecution`Decision.
     *
     * The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for `defaultExecutionStartToCloseTimeout`; there is a one-year max limit on the time that a workflow execution can run. Exceeding this limit always causes the workflow execution to time out.
     */
    public val defaultExecutionStartToCloseTimeout: kotlin.String? = builder.defaultExecutionStartToCloseTimeout
    /**
     * The default IAM role attached to this workflow type.
     *
     * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when you start this workflow type, the default Lambda role is attached to the execution. For more information, see [https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html](https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html) in the *Amazon SWF Developer Guide*.
     */
    public val defaultLambdaRole: kotlin.String? = builder.defaultLambdaRole
    /**
     * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow type. This default is used only if a task list isn't provided when starting the execution through the StartWorkflowExecution Action or `StartChildWorkflowExecution`Decision.
     */
    public val defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.defaultTaskList
    /**
     * The default task priority to assign to the workflow type. If not assigned, then `0` is used. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    public val defaultTaskPriority: kotlin.String? = builder.defaultTaskPriority
    /**
     * If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     */
    public val defaultTaskStartToCloseTimeout: kotlin.String? = builder.defaultTaskStartToCloseTimeout
    /**
     * Textual description of the workflow type.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the domain in which to register the workflow type.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * The name of the workflow type.
     *
     * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The version of the workflow type.
     *
     * The workflow type consists of the name and version, the combination of which must be unique within the domain. To get a list of all currently registered workflow types, use the ListWorkflowTypes action.
     *
     * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.RegisterWorkflowTypeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterWorkflowTypeRequest(")
        append("defaultChildPolicy=$defaultChildPolicy,")
        append("defaultExecutionStartToCloseTimeout=$defaultExecutionStartToCloseTimeout,")
        append("defaultLambdaRole=$defaultLambdaRole,")
        append("defaultTaskList=$defaultTaskList,")
        append("defaultTaskPriority=$defaultTaskPriority,")
        append("defaultTaskStartToCloseTimeout=$defaultTaskStartToCloseTimeout,")
        append("description=$description,")
        append("domain=$domain,")
        append("name=$name,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultChildPolicy?.hashCode() ?: 0
        result = 31 * result + (defaultExecutionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (defaultLambdaRole?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskList?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskPriority?.hashCode() ?: 0)
        result = 31 * result + (defaultTaskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterWorkflowTypeRequest

        if (defaultChildPolicy != other.defaultChildPolicy) return false
        if (defaultExecutionStartToCloseTimeout != other.defaultExecutionStartToCloseTimeout) return false
        if (defaultLambdaRole != other.defaultLambdaRole) return false
        if (defaultTaskList != other.defaultTaskList) return false
        if (defaultTaskPriority != other.defaultTaskPriority) return false
        if (defaultTaskStartToCloseTimeout != other.defaultTaskStartToCloseTimeout) return false
        if (description != other.description) return false
        if (domain != other.domain) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.RegisterWorkflowTypeRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If set, specifies the default policy to use for the child workflow executions when a workflow execution of this type is terminated, by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         */
        public var defaultChildPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * If set, specifies the default maximum duration for executions of this workflow type. You can override this default when starting an execution through the StartWorkflowExecution Action or `StartChildWorkflowExecution`Decision.
         *
         * The duration is specified in seconds; an integer greater than or equal to 0. Unlike some of the other timeout parameters in Amazon SWF, you cannot specify a value of "NONE" for `defaultExecutionStartToCloseTimeout`; there is a one-year max limit on the time that a workflow execution can run. Exceeding this limit always causes the workflow execution to time out.
         */
        public var defaultExecutionStartToCloseTimeout: kotlin.String? = null
        /**
         * The default IAM role attached to this workflow type.
         *
         * Executions of this workflow type need IAM roles to invoke Lambda functions. If you don't specify an IAM role when you start this workflow type, the default Lambda role is attached to the execution. For more information, see [https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html](https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html) in the *Amazon SWF Developer Guide*.
         */
        public var defaultLambdaRole: kotlin.String? = null
        /**
         * If set, specifies the default task list to use for scheduling decision tasks for executions of this workflow type. This default is used only if a task list isn't provided when starting the execution through the StartWorkflowExecution Action or `StartChildWorkflowExecution`Decision.
         */
        public var defaultTaskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * The default task priority to assign to the workflow type. If not assigned, then `0` is used. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        public var defaultTaskPriority: kotlin.String? = null
        /**
         * If set, specifies the default maximum duration of decision tasks for this workflow type. This default can be overridden when starting a workflow execution using the StartWorkflowExecution action or the `StartChildWorkflowExecution`Decision.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         */
        public var defaultTaskStartToCloseTimeout: kotlin.String? = null
        /**
         * Textual description of the workflow type.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the domain in which to register the workflow type.
         */
        public var domain: kotlin.String? = null
        /**
         * The name of the workflow type.
         *
         * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
         */
        public var name: kotlin.String? = null
        /**
         * The version of the workflow type.
         *
         * The workflow type consists of the name and version, the combination of which must be unique within the domain. To get a list of all currently registered workflow types, use the ListWorkflowTypes action.
         *
         * The specified string must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must *not* be the literal string `arn`.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.RegisterWorkflowTypeRequest) : this() {
            this.defaultChildPolicy = x.defaultChildPolicy
            this.defaultExecutionStartToCloseTimeout = x.defaultExecutionStartToCloseTimeout
            this.defaultLambdaRole = x.defaultLambdaRole
            this.defaultTaskList = x.defaultTaskList
            this.defaultTaskPriority = x.defaultTaskPriority
            this.defaultTaskStartToCloseTimeout = x.defaultTaskStartToCloseTimeout
            this.description = x.description
            this.domain = x.domain
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.RegisterWorkflowTypeRequest = RegisterWorkflowTypeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun defaultTaskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.defaultTaskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
