// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.services.swf.model.SwfException
import aws.sdk.kotlin.services.swf.model.TerminateWorkflowExecutionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class TerminateWorkflowExecutionOperationDeserializer: HttpDeserialize<TerminateWorkflowExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TerminateWorkflowExecutionResponse {
        if (!response.status.isSuccess()) {
            throwTerminateWorkflowExecutionError(context, response)
        }
        val builder = TerminateWorkflowExecutionResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwTerminateWorkflowExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
