// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.services.swf.model.StartWorkflowExecutionResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartWorkflowExecutionOperationDeserializer: HttpDeserialize<StartWorkflowExecutionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartWorkflowExecutionResponse {
        if (!response.status.isSuccess()) {
            throwStartWorkflowExecutionError(context, response)
        }
        val builder = StartWorkflowExecutionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartWorkflowExecutionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartWorkflowExecutionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DefaultUndefinedFault" -> DefaultUndefinedFaultDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "TypeDeprecatedFault" -> TypeDeprecatedFaultDeserializer().deserialize(context, wrappedResponse)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedResponse)
        "WorkflowExecutionAlreadyStartedFault" -> WorkflowExecutionAlreadyStartedFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartWorkflowExecutionOperationBody(builder: StartWorkflowExecutionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RUNID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("runId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RUNID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RUNID_DESCRIPTOR.index -> builder.runId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
