// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.services.swf.model.RegisterDomainResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class RegisterDomainOperationDeserializer: HttpDeserialize<RegisterDomainResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterDomainResponse {
        if (!response.status.isSuccess()) {
            throwRegisterDomainError(context, response)
        }
        val builder = RegisterDomainResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwRegisterDomainError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DomainAlreadyExistsFault" -> DomainAlreadyExistsFaultDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededFault" -> LimitExceededFaultDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsFault" -> TooManyTagsFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
