// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.transform

import aws.sdk.kotlin.services.swf.model.DeprecateWorkflowTypeResponse
import aws.sdk.kotlin.services.swf.model.SwfException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeprecateWorkflowTypeOperationDeserializer: HttpDeserialize<DeprecateWorkflowTypeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeprecateWorkflowTypeResponse {
        if (!response.status.isSuccess()) {
            throwDeprecateWorkflowTypeError(context, response)
        }
        val builder = DeprecateWorkflowTypeResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeprecateWorkflowTypeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SwfException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "OperationNotPermittedFault" -> OperationNotPermittedFaultDeserializer().deserialize(context, wrappedResponse)
        "TypeDeprecatedFault" -> TypeDeprecatedFaultDeserializer().deserialize(context, wrappedResponse)
        "UnknownResourceFault" -> UnknownResourceFaultDeserializer().deserialize(context, wrappedResponse)
        else -> SwfException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
