// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



/**
 * Provides the details of the `StartChildWorkflowExecution` decision.
 *
 * **Access Control**
 *
 * You can use IAM policies to control this decision's access to Amazon SWF resources as follows:
 * + Use a `Resource` element with the domain name to limit the action to only specified domains.
 * + Use an `Action` element to allow or deny permission to call this action.
 * + Constrain the following parameters by using a `Condition` element with the appropriate keys.
 *    + `tagList.member.N` – The key is "swf:tagList.N" where N is the tag number from 0 to 4, inclusive.
 *    + `taskList` – String constraint. The key is `swf:taskList.name`.
 *    + `workflowType.name` – String constraint. The key is `swf:workflowType.name`.
 *    + `workflowType.version` – String constraint. The key is `swf:workflowType.version`.
 *
 * If the caller doesn't have sufficient permissions to invoke the action, or the parameter values fall outside the specified constraints, the action fails. The associated event attribute's `cause` parameter is set to `OPERATION_NOT_PERMITTED`. For details and example IAM policies, see [Using IAM to Manage Access to Amazon SWF Workflows](https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html) in the *Amazon SWF Developer Guide*.
 */
public class StartChildWorkflowExecutionDecisionAttributes private constructor(builder: Builder) {
    /**
     * If set, specifies the policy to use for the child workflow executions if the workflow execution being started is terminated by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using RegisterWorkflowType.
     *
     * The supported child policies are:
     * + `TERMINATE` – The child executions are terminated.
     * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
     * + `ABANDON` – No action is taken. The child executions continue to run.
     *
     * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
     */
    public val childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = builder.childPolicy
    /**
     * The data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the child workflow execution.
     */
    public val control: kotlin.String? = builder.control
    /**
     * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     *
     * An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.
     */
    public val executionStartToCloseTimeout: kotlin.String? = builder.executionStartToCloseTimeout
    /**
     * The input to be provided to the workflow execution.
     */
    public val input: kotlin.String? = builder.input
    /**
     * The IAM role attached to the child workflow execution.
     */
    public val lambdaRole: kotlin.String? = builder.lambdaRole
    /**
     * The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and specifying a TagFilter.
     */
    public val tagList: List<String>? = builder.tagList
    /**
     * The name of the task list to be used for decision tasks of the child workflow execution.
     *
     * A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not contain the literal string `arn`.
     */
    public val taskList: aws.sdk.kotlin.services.swf.model.TaskList? = builder.taskList
    /**
     * A task priority that, if set, specifies the priority for a decision task of this workflow execution. This overrides the defaultTaskPriority specified when registering the workflow type. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
     *
     * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
     */
    public val taskPriority: kotlin.String? = builder.taskPriority
    /**
     * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the `defaultTaskStartToCloseTimout` specified when registering the workflow type using RegisterWorkflowType.
     *
     * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
     *
     * A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.
     */
    public val taskStartToCloseTimeout: kotlin.String? = builder.taskStartToCloseTimeout
    /**
     * The `workflowId` of the workflow execution.
     *
     * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not contain the literal string `arn`.
     */
    public val workflowId: kotlin.String? = builder.workflowId
    /**
     * The type of the workflow execution to be started.
     */
    public val workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = builder.workflowType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartChildWorkflowExecutionDecisionAttributes(")
        append("childPolicy=$childPolicy,")
        append("control=$control,")
        append("executionStartToCloseTimeout=$executionStartToCloseTimeout,")
        append("input=$input,")
        append("lambdaRole=$lambdaRole,")
        append("tagList=$tagList,")
        append("taskList=$taskList,")
        append("taskPriority=$taskPriority,")
        append("taskStartToCloseTimeout=$taskStartToCloseTimeout,")
        append("workflowId=$workflowId,")
        append("workflowType=$workflowType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = childPolicy?.hashCode() ?: 0
        result = 31 * result + (control?.hashCode() ?: 0)
        result = 31 * result + (executionStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (lambdaRole?.hashCode() ?: 0)
        result = 31 * result + (tagList?.hashCode() ?: 0)
        result = 31 * result + (taskList?.hashCode() ?: 0)
        result = 31 * result + (taskPriority?.hashCode() ?: 0)
        result = 31 * result + (taskStartToCloseTimeout?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        result = 31 * result + (workflowType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartChildWorkflowExecutionDecisionAttributes

        if (childPolicy != other.childPolicy) return false
        if (control != other.control) return false
        if (executionStartToCloseTimeout != other.executionStartToCloseTimeout) return false
        if (input != other.input) return false
        if (lambdaRole != other.lambdaRole) return false
        if (tagList != other.tagList) return false
        if (taskList != other.taskList) return false
        if (taskPriority != other.taskPriority) return false
        if (taskStartToCloseTimeout != other.taskStartToCloseTimeout) return false
        if (workflowId != other.workflowId) return false
        if (workflowType != other.workflowType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If set, specifies the policy to use for the child workflow executions if the workflow execution being started is terminated by calling the TerminateWorkflowExecution action explicitly or due to an expired timeout. This policy overrides the default child policy specified when registering the workflow type using RegisterWorkflowType.
         *
         * The supported child policies are:
         * + `TERMINATE` – The child executions are terminated.
         * + `REQUEST_CANCEL` – A request to cancel is attempted for each child execution by recording a `WorkflowExecutionCancelRequested` event in its history. It is up to the decider to take appropriate actions when it receives an execution history with this event.
         * + `ABANDON` – No action is taken. The child executions continue to run.
         *
         * A child policy for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default child policy was specified at registration time then a fault is returned.
         */
        public var childPolicy: aws.sdk.kotlin.services.swf.model.ChildPolicy? = null
        /**
         * The data attached to the event that can be used by the decider in subsequent workflow tasks. This data isn't sent to the child workflow execution.
         */
        public var control: kotlin.String? = null
        /**
         * The total duration for this workflow execution. This overrides the defaultExecutionStartToCloseTimeout specified when registering the workflow type.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         *
         * An execution start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default execution start-to-close timeout was specified at registration time then a fault is returned.
         */
        public var executionStartToCloseTimeout: kotlin.String? = null
        /**
         * The input to be provided to the workflow execution.
         */
        public var input: kotlin.String? = null
        /**
         * The IAM role attached to the child workflow execution.
         */
        public var lambdaRole: kotlin.String? = null
        /**
         * The list of tags to associate with the child workflow execution. A maximum of 5 tags can be specified. You can list workflow executions with a specific tag by calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and specifying a TagFilter.
         */
        public var tagList: List<String>? = null
        /**
         * The name of the task list to be used for decision tasks of the child workflow execution.
         *
         * A task list for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task list was specified at registration time then a fault is returned.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not contain the literal string `arn`.
         */
        public var taskList: aws.sdk.kotlin.services.swf.model.TaskList? = null
        /**
         * A task priority that, if set, specifies the priority for a decision task of this workflow execution. This overrides the defaultTaskPriority specified when registering the workflow type. Valid values are integers that range from Java's `Integer.MIN_VALUE` (-2147483648) to `Integer.MAX_VALUE` (2147483647). Higher numbers indicate higher priority.
         *
         * For more information about setting task priority, see [Setting Task Priority](https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html) in the *Amazon SWF Developer Guide*.
         */
        public var taskPriority: kotlin.String? = null
        /**
         * Specifies the maximum duration of decision tasks for this workflow execution. This parameter overrides the `defaultTaskStartToCloseTimout` specified when registering the workflow type using RegisterWorkflowType.
         *
         * The duration is specified in seconds, an integer greater than or equal to `0`. You can use `NONE` to specify unlimited duration.
         *
         * A task start-to-close timeout for this workflow execution must be specified either as a default for the workflow type or through this parameter. If neither this parameter is set nor a default task start-to-close timeout was specified at registration time then a fault is returned.
         */
        public var taskStartToCloseTimeout: kotlin.String? = null
        /**
         * The `workflowId` of the workflow execution.
         *
         * The specified string must not start or end with whitespace. It must not contain a `:` (colon), `/` (slash), `|` (vertical bar), or any control characters (`\u0000-\u001f` | `\u007f-\u009f`). Also, it must not contain the literal string `arn`.
         */
        public var workflowId: kotlin.String? = null
        /**
         * The type of the workflow execution to be started.
         */
        public var workflowType: aws.sdk.kotlin.services.swf.model.WorkflowType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes) : this() {
            this.childPolicy = x.childPolicy
            this.control = x.control
            this.executionStartToCloseTimeout = x.executionStartToCloseTimeout
            this.input = x.input
            this.lambdaRole = x.lambdaRole
            this.tagList = x.tagList
            this.taskList = x.taskList
            this.taskPriority = x.taskPriority
            this.taskStartToCloseTimeout = x.taskStartToCloseTimeout
            this.workflowId = x.workflowId
            this.workflowType = x.workflowType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionDecisionAttributes = StartChildWorkflowExecutionDecisionAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TaskList] inside the given [block]
         */
        public fun taskList(block: aws.sdk.kotlin.services.swf.model.TaskList.Builder.() -> kotlin.Unit) {
            this.taskList = aws.sdk.kotlin.services.swf.model.TaskList.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowType] inside the given [block]
         */
        public fun workflowType(block: aws.sdk.kotlin.services.swf.model.WorkflowType.Builder.() -> kotlin.Unit) {
            this.workflowType = aws.sdk.kotlin.services.swf.model.WorkflowType.invoke(block)
        }
    }
}
