// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model



public class ListClosedWorkflowExecutionsRequest private constructor(builder: Builder) {
    /**
     * If specified, only workflow executions that match this *close status* are listed. For example, if TERMINATED is specified, then only TERMINATED workflow executions are listed.
     *
     * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
     */
    public val closeStatusFilter: aws.sdk.kotlin.services.swf.model.CloseStatusFilter? = builder.closeStatusFilter
    /**
     * If specified, the workflow executions are included in the returned results based on whether their close times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their close times.
     *
     * `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must specify one of these in a request but not both.
     */
    public val closeTimeFilter: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter? = builder.closeTimeFilter
    /**
     * The name of the domain that contains the workflow executions to list.
     */
    public val domain: kotlin.String? = builder.domain
    /**
     * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
     *
     * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
     */
    public val executionFilter: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter? = builder.executionFilter
    /**
     * The maximum number of results that are returned per call. Use `nextPageToken` to obtain further pages of results.
     */
    public val maximumPageSize: kotlin.Int = builder.maximumPageSize
    /**
     * If `NextPageToken` is returned there are more results available. The value of `NextPageToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a `400` error: "`Specified token has exceeded its maximum lifetime`".
     *
     * The configured `maximumPageSize` determines how many results can be returned in a single call.
     */
    public val nextPageToken: kotlin.String? = builder.nextPageToken
    /**
     * When set to `true`, returns the results in reverse order. By default the results are returned in descending order of the start or the close time of the executions.
     */
    public val reverseOrder: kotlin.Boolean = builder.reverseOrder
    /**
     * If specified, the workflow executions are included in the returned results based on whether their start times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their start times.
     *
     * `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must specify one of these in a request but not both.
     */
    public val startTimeFilter: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter? = builder.startTimeFilter
    /**
     * If specified, only executions that have the matching tag are listed.
     *
     * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
     */
    public val tagFilter: aws.sdk.kotlin.services.swf.model.TagFilter? = builder.tagFilter
    /**
     * If specified, only executions of the type specified in the filter are returned.
     *
     * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
     */
    public val typeFilter: aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter? = builder.typeFilter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListClosedWorkflowExecutionsRequest(")
        append("closeStatusFilter=$closeStatusFilter,")
        append("closeTimeFilter=$closeTimeFilter,")
        append("domain=$domain,")
        append("executionFilter=$executionFilter,")
        append("maximumPageSize=$maximumPageSize,")
        append("nextPageToken=$nextPageToken,")
        append("reverseOrder=$reverseOrder,")
        append("startTimeFilter=$startTimeFilter,")
        append("tagFilter=$tagFilter,")
        append("typeFilter=$typeFilter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = closeStatusFilter?.hashCode() ?: 0
        result = 31 * result + (closeTimeFilter?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (executionFilter?.hashCode() ?: 0)
        result = 31 * result + (maximumPageSize)
        result = 31 * result + (nextPageToken?.hashCode() ?: 0)
        result = 31 * result + (reverseOrder.hashCode())
        result = 31 * result + (startTimeFilter?.hashCode() ?: 0)
        result = 31 * result + (tagFilter?.hashCode() ?: 0)
        result = 31 * result + (typeFilter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListClosedWorkflowExecutionsRequest

        if (closeStatusFilter != other.closeStatusFilter) return false
        if (closeTimeFilter != other.closeTimeFilter) return false
        if (domain != other.domain) return false
        if (executionFilter != other.executionFilter) return false
        if (maximumPageSize != other.maximumPageSize) return false
        if (nextPageToken != other.nextPageToken) return false
        if (reverseOrder != other.reverseOrder) return false
        if (startTimeFilter != other.startTimeFilter) return false
        if (tagFilter != other.tagFilter) return false
        if (typeFilter != other.typeFilter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If specified, only workflow executions that match this *close status* are listed. For example, if TERMINATED is specified, then only TERMINATED workflow executions are listed.
         *
         * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
         */
        public var closeStatusFilter: aws.sdk.kotlin.services.swf.model.CloseStatusFilter? = null
        /**
         * If specified, the workflow executions are included in the returned results based on whether their close times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their close times.
         *
         * `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must specify one of these in a request but not both.
         */
        public var closeTimeFilter: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter? = null
        /**
         * The name of the domain that contains the workflow executions to list.
         */
        public var domain: kotlin.String? = null
        /**
         * If specified, only workflow executions matching the workflow ID specified in the filter are returned.
         *
         * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
         */
        public var executionFilter: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter? = null
        /**
         * The maximum number of results that are returned per call. Use `nextPageToken` to obtain further pages of results.
         */
        public var maximumPageSize: kotlin.Int = 0
        /**
         * If `NextPageToken` is returned there are more results available. The value of `NextPageToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 60 seconds. Using an expired pagination token will return a `400` error: "`Specified token has exceeded its maximum lifetime`".
         *
         * The configured `maximumPageSize` determines how many results can be returned in a single call.
         */
        public var nextPageToken: kotlin.String? = null
        /**
         * When set to `true`, returns the results in reverse order. By default the results are returned in descending order of the start or the close time of the executions.
         */
        public var reverseOrder: kotlin.Boolean = false
        /**
         * If specified, the workflow executions are included in the returned results based on whether their start times are within the range specified by this filter. Also, if this parameter is specified, the returned results are ordered by their start times.
         *
         * `startTimeFilter` and `closeTimeFilter` are mutually exclusive. You must specify one of these in a request but not both.
         */
        public var startTimeFilter: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter? = null
        /**
         * If specified, only executions that have the matching tag are listed.
         *
         * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
         */
        public var tagFilter: aws.sdk.kotlin.services.swf.model.TagFilter? = null
        /**
         * If specified, only executions of the type specified in the filter are returned.
         *
         * `closeStatusFilter`, `executionFilter`, `typeFilter` and `tagFilter` are mutually exclusive. You can specify at most one of these in a request.
         */
        public var typeFilter: aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsRequest) : this() {
            this.closeStatusFilter = x.closeStatusFilter
            this.closeTimeFilter = x.closeTimeFilter
            this.domain = x.domain
            this.executionFilter = x.executionFilter
            this.maximumPageSize = x.maximumPageSize
            this.nextPageToken = x.nextPageToken
            this.reverseOrder = x.reverseOrder
            this.startTimeFilter = x.startTimeFilter
            this.tagFilter = x.tagFilter
            this.typeFilter = x.typeFilter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.ListClosedWorkflowExecutionsRequest = ListClosedWorkflowExecutionsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CloseStatusFilter] inside the given [block]
         */
        public fun closeStatusFilter(block: aws.sdk.kotlin.services.swf.model.CloseStatusFilter.Builder.() -> kotlin.Unit) {
            this.closeStatusFilter = aws.sdk.kotlin.services.swf.model.CloseStatusFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter] inside the given [block]
         */
        public fun closeTimeFilter(block: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter.Builder.() -> kotlin.Unit) {
            this.closeTimeFilter = aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter] inside the given [block]
         */
        public fun executionFilter(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter.Builder.() -> kotlin.Unit) {
            this.executionFilter = aws.sdk.kotlin.services.swf.model.WorkflowExecutionFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter] inside the given [block]
         */
        public fun startTimeFilter(block: aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter.Builder.() -> kotlin.Unit) {
            this.startTimeFilter = aws.sdk.kotlin.services.swf.model.ExecutionTimeFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TagFilter] inside the given [block]
         */
        public fun tagFilter(block: aws.sdk.kotlin.services.swf.model.TagFilter.Builder.() -> kotlin.Unit) {
            this.tagFilter = aws.sdk.kotlin.services.swf.model.TagFilter.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter] inside the given [block]
         */
        public fun typeFilter(block: aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter.Builder.() -> kotlin.Unit) {
            this.typeFilter = aws.sdk.kotlin.services.swf.model.WorkflowTypeFilter.invoke(block)
        }
    }
}
