// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.swf.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Event within a workflow execution. A history event can be one of these types:
 * + `ActivityTaskCancelRequested` – A `RequestCancelActivityTask` decision was received by the system.
 * + `ActivityTaskCanceled` – The activity task was successfully canceled.
 * + `ActivityTaskCompleted` – An activity worker successfully completed an activity task by calling RespondActivityTaskCompleted.
 * + `ActivityTaskFailed` – An activity worker failed an activity task by calling RespondActivityTaskFailed.
 * + `ActivityTaskScheduled` – An activity task was scheduled for execution.
 * + `ActivityTaskStarted` – The scheduled activity task was dispatched to a worker.
 * + `ActivityTaskTimedOut` – The activity task timed out.
 * + `CancelTimerFailed` – Failed to process CancelTimer decision. This happens when the decision isn't configured properly, for example no timer exists with the specified timer Id.
 * + `CancelWorkflowExecutionFailed` – A request to cancel a workflow execution failed.
 * + `ChildWorkflowExecutionCanceled` – A child workflow execution, started by this workflow execution, was canceled and closed.
 * + `ChildWorkflowExecutionCompleted` – A child workflow execution, started by this workflow execution, completed successfully and was closed.
 * + `ChildWorkflowExecutionFailed` – A child workflow execution, started by this workflow execution, failed to complete successfully and was closed.
 * + `ChildWorkflowExecutionStarted` – A child workflow execution was successfully started.
 * + `ChildWorkflowExecutionTerminated` – A child workflow execution, started by this workflow execution, was terminated.
 * + `ChildWorkflowExecutionTimedOut` – A child workflow execution, started by this workflow execution, timed out and was closed.
 * + `CompleteWorkflowExecutionFailed` – The workflow execution failed to complete.
 * + `ContinueAsNewWorkflowExecutionFailed` – The workflow execution failed to complete after being continued as a new workflow execution.
 * + `DecisionTaskCompleted` – The decider successfully completed a decision task by calling RespondDecisionTaskCompleted.
 * + `DecisionTaskScheduled` – A decision task was scheduled for the workflow execution.
 * + `DecisionTaskStarted` – The decision task was dispatched to a decider.
 * + `DecisionTaskTimedOut` – The decision task timed out.
 * + `ExternalWorkflowExecutionCancelRequested` – Request to cancel an external workflow execution was successfully delivered to the target execution.
 * + `ExternalWorkflowExecutionSignaled` – A signal, requested by this workflow execution, was successfully delivered to the target external workflow execution.
 * + `FailWorkflowExecutionFailed` – A request to mark a workflow execution as failed, itself failed.
 * + `MarkerRecorded` – A marker was recorded in the workflow history as the result of a `RecordMarker` decision.
 * + `RecordMarkerFailed` – A `RecordMarker` decision was returned as failed.
 * + `RequestCancelActivityTaskFailed` – Failed to process RequestCancelActivityTask decision. This happens when the decision isn't configured properly.
 * + `RequestCancelExternalWorkflowExecutionFailed` – Request to cancel an external workflow execution failed.
 * + `RequestCancelExternalWorkflowExecutionInitiated` – A request was made to request the cancellation of an external workflow execution.
 * + `ScheduleActivityTaskFailed` – Failed to process ScheduleActivityTask decision. This happens when the decision isn't configured properly, for example the activity type specified isn't registered.
 * + `SignalExternalWorkflowExecutionFailed` – The request to signal an external workflow execution failed.
 * + `SignalExternalWorkflowExecutionInitiated` – A request to signal an external workflow was made.
 * + `StartActivityTaskFailed` – A scheduled activity task failed to start.
 * + `StartChildWorkflowExecutionFailed` – Failed to process StartChildWorkflowExecution decision. This happens when the decision isn't configured properly, for example the workflow type specified isn't registered.
 * + `StartChildWorkflowExecutionInitiated` – A request was made to start a child workflow execution.
 * + `StartTimerFailed` – Failed to process StartTimer decision. This happens when the decision isn't configured properly, for example a timer already exists with the specified timer Id.
 * + `TimerCanceled` – A timer, previously started for this workflow execution, was successfully canceled.
 * + `TimerFired` – A timer, previously started for this workflow execution, fired.
 * + `TimerStarted` – A timer was started for the workflow execution due to a `StartTimer` decision.
 * + `WorkflowExecutionCancelRequested` – A request to cancel this workflow execution was made.
 * + `WorkflowExecutionCanceled` – The workflow execution was successfully canceled and closed.
 * + `WorkflowExecutionCompleted` – The workflow execution was closed due to successful completion.
 * + `WorkflowExecutionContinuedAsNew` – The workflow execution was closed and a new execution of the same type was created with the same workflowId.
 * + `WorkflowExecutionFailed` – The workflow execution closed due to a failure.
 * + `WorkflowExecutionSignaled` – An external signal was received for the workflow execution.
 * + `WorkflowExecutionStarted` – The workflow execution was started.
 * + `WorkflowExecutionTerminated` – The workflow execution was terminated.
 * + `WorkflowExecutionTimedOut` – The workflow execution was closed because a time out was exceeded.
 */
public class HistoryEvent private constructor(builder: Builder) {
    /**
     * If the event is of type `ActivityTaskcancelRequested` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskCancelRequestedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskCancelRequestedEventAttributes? = builder.activityTaskCancelRequestedEventAttributes
    /**
     * If the event is of type `ActivityTaskCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskCanceledEventAttributes? = builder.activityTaskCanceledEventAttributes
    /**
     * If the event is of type `ActivityTaskCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskCompletedEventAttributes? = builder.activityTaskCompletedEventAttributes
    /**
     * If the event is of type `ActivityTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskFailedEventAttributes? = builder.activityTaskFailedEventAttributes
    /**
     * If the event is of type `ActivityTaskScheduled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskScheduledEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes? = builder.activityTaskScheduledEventAttributes
    /**
     * If the event is of type `ActivityTaskStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskStartedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskStartedEventAttributes? = builder.activityTaskStartedEventAttributes
    /**
     * If the event is of type `ActivityTaskTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val activityTaskTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskTimedOutEventAttributes? = builder.activityTaskTimedOutEventAttributes
    /**
     * If the event is of type `CancelTimerFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val cancelTimerFailedEventAttributes: aws.sdk.kotlin.services.swf.model.CancelTimerFailedEventAttributes? = builder.cancelTimerFailedEventAttributes
    /**
     * If the event is of type `CancelWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val cancelWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionFailedEventAttributes? = builder.cancelWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `ChildWorkflowExecutionCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val childWorkflowExecutionCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCanceledEventAttributes? = builder.childWorkflowExecutionCanceledEventAttributes
    /**
     * If the event is of type `ChildWorkflowExecutionCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val childWorkflowExecutionCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes? = builder.childWorkflowExecutionCompletedEventAttributes
    /**
     * If the event is of type `ChildWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val childWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionFailedEventAttributes? = builder.childWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `ChildWorkflowExecutionStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val childWorkflowExecutionStartedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionStartedEventAttributes? = builder.childWorkflowExecutionStartedEventAttributes
    /**
     * If the event is of type `ChildWorkflowExecutionTerminated` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val childWorkflowExecutionTerminatedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes? = builder.childWorkflowExecutionTerminatedEventAttributes
    /**
     * If the event is of type `ChildWorkflowExecutionTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val childWorkflowExecutionTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes? = builder.childWorkflowExecutionTimedOutEventAttributes
    /**
     * If the event is of type `CompleteWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val completeWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes? = builder.completeWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `ContinueAsNewWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val continueAsNewWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes? = builder.continueAsNewWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `DecisionTaskCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val decisionTaskCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskCompletedEventAttributes? = builder.decisionTaskCompletedEventAttributes
    /**
     * If the event is of type `DecisionTaskScheduled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val decisionTaskScheduledEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes? = builder.decisionTaskScheduledEventAttributes
    /**
     * If the event is of type `DecisionTaskStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val decisionTaskStartedEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskStartedEventAttributes? = builder.decisionTaskStartedEventAttributes
    /**
     * If the event is of type `DecisionTaskTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val decisionTaskTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes? = builder.decisionTaskTimedOutEventAttributes
    /**
     * The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution history.
     */
    public val eventId: kotlin.Long = builder.eventId
    /**
     * The date and time when the event occurred.
     */
    public val eventTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.eventTimestamp
    /**
     * The type of the history event.
     */
    public val eventType: aws.sdk.kotlin.services.swf.model.EventType? = builder.eventType
    /**
     * If the event is of type `ExternalWorkflowExecutionCancelRequested` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val externalWorkflowExecutionCancelRequestedEventAttributes: aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes? = builder.externalWorkflowExecutionCancelRequestedEventAttributes
    /**
     * If the event is of type `ExternalWorkflowExecutionSignaled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val externalWorkflowExecutionSignaledEventAttributes: aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionSignaledEventAttributes? = builder.externalWorkflowExecutionSignaledEventAttributes
    /**
     * If the event is of type `FailWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val failWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionFailedEventAttributes? = builder.failWorkflowExecutionFailedEventAttributes
    /**
     * Provides the details of the `LambdaFunctionCompleted` event. It isn't set for other event types.
     */
    public val lambdaFunctionCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionCompletedEventAttributes? = builder.lambdaFunctionCompletedEventAttributes
    /**
     * Provides the details of the `LambdaFunctionFailed` event. It isn't set for other event types.
     */
    public val lambdaFunctionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionFailedEventAttributes? = builder.lambdaFunctionFailedEventAttributes
    /**
     * Provides the details of the `LambdaFunctionScheduled` event. It isn't set for other event types.
     */
    public val lambdaFunctionScheduledEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionScheduledEventAttributes? = builder.lambdaFunctionScheduledEventAttributes
    /**
     * Provides the details of the `LambdaFunctionStarted` event. It isn't set for other event types.
     */
    public val lambdaFunctionStartedEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionStartedEventAttributes? = builder.lambdaFunctionStartedEventAttributes
    /**
     * Provides the details of the `LambdaFunctionTimedOut` event. It isn't set for other event types.
     */
    public val lambdaFunctionTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionTimedOutEventAttributes? = builder.lambdaFunctionTimedOutEventAttributes
    /**
     * If the event is of type `MarkerRecorded` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val markerRecordedEventAttributes: aws.sdk.kotlin.services.swf.model.MarkerRecordedEventAttributes? = builder.markerRecordedEventAttributes
    /**
     * If the event is of type `DecisionTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val recordMarkerFailedEventAttributes: aws.sdk.kotlin.services.swf.model.RecordMarkerFailedEventAttributes? = builder.recordMarkerFailedEventAttributes
    /**
     * If the event is of type `RequestCancelActivityTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val requestCancelActivityTaskFailedEventAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskFailedEventAttributes? = builder.requestCancelActivityTaskFailedEventAttributes
    /**
     * If the event is of type `RequestCancelExternalWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val requestCancelExternalWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes? = builder.requestCancelExternalWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `RequestCancelExternalWorkflowExecutionInitiated` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val requestCancelExternalWorkflowExecutionInitiatedEventAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes? = builder.requestCancelExternalWorkflowExecutionInitiatedEventAttributes
    /**
     * If the event is of type `ScheduleActivityTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val scheduleActivityTaskFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes? = builder.scheduleActivityTaskFailedEventAttributes
    /**
     * Provides the details of the `ScheduleLambdaFunctionFailed` event. It isn't set for other event types.
     */
    public val scheduleLambdaFunctionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes? = builder.scheduleLambdaFunctionFailedEventAttributes
    /**
     * If the event is of type `SignalExternalWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val signalExternalWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes? = builder.signalExternalWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `SignalExternalWorkflowExecutionInitiated` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val signalExternalWorkflowExecutionInitiatedEventAttributes: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes? = builder.signalExternalWorkflowExecutionInitiatedEventAttributes
    /**
     * If the event is of type `StartChildWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val startChildWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes? = builder.startChildWorkflowExecutionFailedEventAttributes
    /**
     * If the event is of type `StartChildWorkflowExecutionInitiated` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val startChildWorkflowExecutionInitiatedEventAttributes: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes? = builder.startChildWorkflowExecutionInitiatedEventAttributes
    /**
     * Provides the details of the `StartLambdaFunctionFailed` event. It isn't set for other event types.
     */
    public val startLambdaFunctionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.StartLambdaFunctionFailedEventAttributes? = builder.startLambdaFunctionFailedEventAttributes
    /**
     * If the event is of type `StartTimerFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val startTimerFailedEventAttributes: aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes? = builder.startTimerFailedEventAttributes
    /**
     * If the event is of type `TimerCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val timerCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes? = builder.timerCanceledEventAttributes
    /**
     * If the event is of type `TimerFired` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val timerFiredEventAttributes: aws.sdk.kotlin.services.swf.model.TimerFiredEventAttributes? = builder.timerFiredEventAttributes
    /**
     * If the event is of type `TimerStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val timerStartedEventAttributes: aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes? = builder.timerStartedEventAttributes
    /**
     * If the event is of type `WorkflowExecutionCancelRequested` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionCancelRequestedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes? = builder.workflowExecutionCancelRequestedEventAttributes
    /**
     * If the event is of type `WorkflowExecutionCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCanceledEventAttributes? = builder.workflowExecutionCanceledEventAttributes
    /**
     * If the event is of type `WorkflowExecutionCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCompletedEventAttributes? = builder.workflowExecutionCompletedEventAttributes
    /**
     * If the event is of type `WorkflowExecutionContinuedAsNew` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionContinuedAsNewEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes? = builder.workflowExecutionContinuedAsNewEventAttributes
    /**
     * If the event is of type `WorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFailedEventAttributes? = builder.workflowExecutionFailedEventAttributes
    /**
     * If the event is of type `WorkflowExecutionSignaled` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionSignaledEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionSignaledEventAttributes? = builder.workflowExecutionSignaledEventAttributes
    /**
     * If the event is of type `WorkflowExecutionStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionStartedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes? = builder.workflowExecutionStartedEventAttributes
    /**
     * If the event is of type `WorkflowExecutionTerminated` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionTerminatedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTerminatedEventAttributes? = builder.workflowExecutionTerminatedEventAttributes
    /**
     * If the event is of type `WorkflowExecutionTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
     */
    public val workflowExecutionTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimedOutEventAttributes? = builder.workflowExecutionTimedOutEventAttributes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.swf.model.HistoryEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HistoryEvent(")
        append("activityTaskCancelRequestedEventAttributes=$activityTaskCancelRequestedEventAttributes,")
        append("activityTaskCanceledEventAttributes=$activityTaskCanceledEventAttributes,")
        append("activityTaskCompletedEventAttributes=$activityTaskCompletedEventAttributes,")
        append("activityTaskFailedEventAttributes=$activityTaskFailedEventAttributes,")
        append("activityTaskScheduledEventAttributes=$activityTaskScheduledEventAttributes,")
        append("activityTaskStartedEventAttributes=$activityTaskStartedEventAttributes,")
        append("activityTaskTimedOutEventAttributes=$activityTaskTimedOutEventAttributes,")
        append("cancelTimerFailedEventAttributes=$cancelTimerFailedEventAttributes,")
        append("cancelWorkflowExecutionFailedEventAttributes=$cancelWorkflowExecutionFailedEventAttributes,")
        append("childWorkflowExecutionCanceledEventAttributes=$childWorkflowExecutionCanceledEventAttributes,")
        append("childWorkflowExecutionCompletedEventAttributes=$childWorkflowExecutionCompletedEventAttributes,")
        append("childWorkflowExecutionFailedEventAttributes=$childWorkflowExecutionFailedEventAttributes,")
        append("childWorkflowExecutionStartedEventAttributes=$childWorkflowExecutionStartedEventAttributes,")
        append("childWorkflowExecutionTerminatedEventAttributes=$childWorkflowExecutionTerminatedEventAttributes,")
        append("childWorkflowExecutionTimedOutEventAttributes=$childWorkflowExecutionTimedOutEventAttributes,")
        append("completeWorkflowExecutionFailedEventAttributes=$completeWorkflowExecutionFailedEventAttributes,")
        append("continueAsNewWorkflowExecutionFailedEventAttributes=$continueAsNewWorkflowExecutionFailedEventAttributes,")
        append("decisionTaskCompletedEventAttributes=$decisionTaskCompletedEventAttributes,")
        append("decisionTaskScheduledEventAttributes=$decisionTaskScheduledEventAttributes,")
        append("decisionTaskStartedEventAttributes=$decisionTaskStartedEventAttributes,")
        append("decisionTaskTimedOutEventAttributes=$decisionTaskTimedOutEventAttributes,")
        append("eventId=$eventId,")
        append("eventTimestamp=$eventTimestamp,")
        append("eventType=$eventType,")
        append("externalWorkflowExecutionCancelRequestedEventAttributes=$externalWorkflowExecutionCancelRequestedEventAttributes,")
        append("externalWorkflowExecutionSignaledEventAttributes=$externalWorkflowExecutionSignaledEventAttributes,")
        append("failWorkflowExecutionFailedEventAttributes=$failWorkflowExecutionFailedEventAttributes,")
        append("lambdaFunctionCompletedEventAttributes=$lambdaFunctionCompletedEventAttributes,")
        append("lambdaFunctionFailedEventAttributes=$lambdaFunctionFailedEventAttributes,")
        append("lambdaFunctionScheduledEventAttributes=$lambdaFunctionScheduledEventAttributes,")
        append("lambdaFunctionStartedEventAttributes=$lambdaFunctionStartedEventAttributes,")
        append("lambdaFunctionTimedOutEventAttributes=$lambdaFunctionTimedOutEventAttributes,")
        append("markerRecordedEventAttributes=$markerRecordedEventAttributes,")
        append("recordMarkerFailedEventAttributes=$recordMarkerFailedEventAttributes,")
        append("requestCancelActivityTaskFailedEventAttributes=$requestCancelActivityTaskFailedEventAttributes,")
        append("requestCancelExternalWorkflowExecutionFailedEventAttributes=$requestCancelExternalWorkflowExecutionFailedEventAttributes,")
        append("requestCancelExternalWorkflowExecutionInitiatedEventAttributes=$requestCancelExternalWorkflowExecutionInitiatedEventAttributes,")
        append("scheduleActivityTaskFailedEventAttributes=$scheduleActivityTaskFailedEventAttributes,")
        append("scheduleLambdaFunctionFailedEventAttributes=$scheduleLambdaFunctionFailedEventAttributes,")
        append("signalExternalWorkflowExecutionFailedEventAttributes=$signalExternalWorkflowExecutionFailedEventAttributes,")
        append("signalExternalWorkflowExecutionInitiatedEventAttributes=$signalExternalWorkflowExecutionInitiatedEventAttributes,")
        append("startChildWorkflowExecutionFailedEventAttributes=$startChildWorkflowExecutionFailedEventAttributes,")
        append("startChildWorkflowExecutionInitiatedEventAttributes=$startChildWorkflowExecutionInitiatedEventAttributes,")
        append("startLambdaFunctionFailedEventAttributes=$startLambdaFunctionFailedEventAttributes,")
        append("startTimerFailedEventAttributes=$startTimerFailedEventAttributes,")
        append("timerCanceledEventAttributes=$timerCanceledEventAttributes,")
        append("timerFiredEventAttributes=$timerFiredEventAttributes,")
        append("timerStartedEventAttributes=$timerStartedEventAttributes,")
        append("workflowExecutionCancelRequestedEventAttributes=$workflowExecutionCancelRequestedEventAttributes,")
        append("workflowExecutionCanceledEventAttributes=$workflowExecutionCanceledEventAttributes,")
        append("workflowExecutionCompletedEventAttributes=$workflowExecutionCompletedEventAttributes,")
        append("workflowExecutionContinuedAsNewEventAttributes=$workflowExecutionContinuedAsNewEventAttributes,")
        append("workflowExecutionFailedEventAttributes=$workflowExecutionFailedEventAttributes,")
        append("workflowExecutionSignaledEventAttributes=$workflowExecutionSignaledEventAttributes,")
        append("workflowExecutionStartedEventAttributes=$workflowExecutionStartedEventAttributes,")
        append("workflowExecutionTerminatedEventAttributes=$workflowExecutionTerminatedEventAttributes,")
        append("workflowExecutionTimedOutEventAttributes=$workflowExecutionTimedOutEventAttributes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activityTaskCancelRequestedEventAttributes?.hashCode() ?: 0
        result = 31 * result + (activityTaskCanceledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (activityTaskCompletedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (activityTaskFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (activityTaskScheduledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (activityTaskStartedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (activityTaskTimedOutEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (cancelTimerFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (cancelWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (childWorkflowExecutionCanceledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (childWorkflowExecutionCompletedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (childWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (childWorkflowExecutionStartedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (childWorkflowExecutionTerminatedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (childWorkflowExecutionTimedOutEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (completeWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (continueAsNewWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskCompletedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskScheduledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskStartedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (decisionTaskTimedOutEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (eventId.hashCode())
        result = 31 * result + (eventTimestamp?.hashCode() ?: 0)
        result = 31 * result + (eventType?.hashCode() ?: 0)
        result = 31 * result + (externalWorkflowExecutionCancelRequestedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (externalWorkflowExecutionSignaledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (failWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionCompletedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionScheduledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionStartedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionTimedOutEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (markerRecordedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (recordMarkerFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (requestCancelActivityTaskFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (requestCancelExternalWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (requestCancelExternalWorkflowExecutionInitiatedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (scheduleActivityTaskFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (scheduleLambdaFunctionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (signalExternalWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (signalExternalWorkflowExecutionInitiatedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (startChildWorkflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (startChildWorkflowExecutionInitiatedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (startLambdaFunctionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (startTimerFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (timerCanceledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (timerFiredEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (timerStartedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionCancelRequestedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionCanceledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionCompletedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionContinuedAsNewEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionFailedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionSignaledEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionStartedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionTerminatedEventAttributes?.hashCode() ?: 0)
        result = 31 * result + (workflowExecutionTimedOutEventAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HistoryEvent

        if (activityTaskCancelRequestedEventAttributes != other.activityTaskCancelRequestedEventAttributes) return false
        if (activityTaskCanceledEventAttributes != other.activityTaskCanceledEventAttributes) return false
        if (activityTaskCompletedEventAttributes != other.activityTaskCompletedEventAttributes) return false
        if (activityTaskFailedEventAttributes != other.activityTaskFailedEventAttributes) return false
        if (activityTaskScheduledEventAttributes != other.activityTaskScheduledEventAttributes) return false
        if (activityTaskStartedEventAttributes != other.activityTaskStartedEventAttributes) return false
        if (activityTaskTimedOutEventAttributes != other.activityTaskTimedOutEventAttributes) return false
        if (cancelTimerFailedEventAttributes != other.cancelTimerFailedEventAttributes) return false
        if (cancelWorkflowExecutionFailedEventAttributes != other.cancelWorkflowExecutionFailedEventAttributes) return false
        if (childWorkflowExecutionCanceledEventAttributes != other.childWorkflowExecutionCanceledEventAttributes) return false
        if (childWorkflowExecutionCompletedEventAttributes != other.childWorkflowExecutionCompletedEventAttributes) return false
        if (childWorkflowExecutionFailedEventAttributes != other.childWorkflowExecutionFailedEventAttributes) return false
        if (childWorkflowExecutionStartedEventAttributes != other.childWorkflowExecutionStartedEventAttributes) return false
        if (childWorkflowExecutionTerminatedEventAttributes != other.childWorkflowExecutionTerminatedEventAttributes) return false
        if (childWorkflowExecutionTimedOutEventAttributes != other.childWorkflowExecutionTimedOutEventAttributes) return false
        if (completeWorkflowExecutionFailedEventAttributes != other.completeWorkflowExecutionFailedEventAttributes) return false
        if (continueAsNewWorkflowExecutionFailedEventAttributes != other.continueAsNewWorkflowExecutionFailedEventAttributes) return false
        if (decisionTaskCompletedEventAttributes != other.decisionTaskCompletedEventAttributes) return false
        if (decisionTaskScheduledEventAttributes != other.decisionTaskScheduledEventAttributes) return false
        if (decisionTaskStartedEventAttributes != other.decisionTaskStartedEventAttributes) return false
        if (decisionTaskTimedOutEventAttributes != other.decisionTaskTimedOutEventAttributes) return false
        if (eventId != other.eventId) return false
        if (eventTimestamp != other.eventTimestamp) return false
        if (eventType != other.eventType) return false
        if (externalWorkflowExecutionCancelRequestedEventAttributes != other.externalWorkflowExecutionCancelRequestedEventAttributes) return false
        if (externalWorkflowExecutionSignaledEventAttributes != other.externalWorkflowExecutionSignaledEventAttributes) return false
        if (failWorkflowExecutionFailedEventAttributes != other.failWorkflowExecutionFailedEventAttributes) return false
        if (lambdaFunctionCompletedEventAttributes != other.lambdaFunctionCompletedEventAttributes) return false
        if (lambdaFunctionFailedEventAttributes != other.lambdaFunctionFailedEventAttributes) return false
        if (lambdaFunctionScheduledEventAttributes != other.lambdaFunctionScheduledEventAttributes) return false
        if (lambdaFunctionStartedEventAttributes != other.lambdaFunctionStartedEventAttributes) return false
        if (lambdaFunctionTimedOutEventAttributes != other.lambdaFunctionTimedOutEventAttributes) return false
        if (markerRecordedEventAttributes != other.markerRecordedEventAttributes) return false
        if (recordMarkerFailedEventAttributes != other.recordMarkerFailedEventAttributes) return false
        if (requestCancelActivityTaskFailedEventAttributes != other.requestCancelActivityTaskFailedEventAttributes) return false
        if (requestCancelExternalWorkflowExecutionFailedEventAttributes != other.requestCancelExternalWorkflowExecutionFailedEventAttributes) return false
        if (requestCancelExternalWorkflowExecutionInitiatedEventAttributes != other.requestCancelExternalWorkflowExecutionInitiatedEventAttributes) return false
        if (scheduleActivityTaskFailedEventAttributes != other.scheduleActivityTaskFailedEventAttributes) return false
        if (scheduleLambdaFunctionFailedEventAttributes != other.scheduleLambdaFunctionFailedEventAttributes) return false
        if (signalExternalWorkflowExecutionFailedEventAttributes != other.signalExternalWorkflowExecutionFailedEventAttributes) return false
        if (signalExternalWorkflowExecutionInitiatedEventAttributes != other.signalExternalWorkflowExecutionInitiatedEventAttributes) return false
        if (startChildWorkflowExecutionFailedEventAttributes != other.startChildWorkflowExecutionFailedEventAttributes) return false
        if (startChildWorkflowExecutionInitiatedEventAttributes != other.startChildWorkflowExecutionInitiatedEventAttributes) return false
        if (startLambdaFunctionFailedEventAttributes != other.startLambdaFunctionFailedEventAttributes) return false
        if (startTimerFailedEventAttributes != other.startTimerFailedEventAttributes) return false
        if (timerCanceledEventAttributes != other.timerCanceledEventAttributes) return false
        if (timerFiredEventAttributes != other.timerFiredEventAttributes) return false
        if (timerStartedEventAttributes != other.timerStartedEventAttributes) return false
        if (workflowExecutionCancelRequestedEventAttributes != other.workflowExecutionCancelRequestedEventAttributes) return false
        if (workflowExecutionCanceledEventAttributes != other.workflowExecutionCanceledEventAttributes) return false
        if (workflowExecutionCompletedEventAttributes != other.workflowExecutionCompletedEventAttributes) return false
        if (workflowExecutionContinuedAsNewEventAttributes != other.workflowExecutionContinuedAsNewEventAttributes) return false
        if (workflowExecutionFailedEventAttributes != other.workflowExecutionFailedEventAttributes) return false
        if (workflowExecutionSignaledEventAttributes != other.workflowExecutionSignaledEventAttributes) return false
        if (workflowExecutionStartedEventAttributes != other.workflowExecutionStartedEventAttributes) return false
        if (workflowExecutionTerminatedEventAttributes != other.workflowExecutionTerminatedEventAttributes) return false
        if (workflowExecutionTimedOutEventAttributes != other.workflowExecutionTimedOutEventAttributes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.swf.model.HistoryEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If the event is of type `ActivityTaskcancelRequested` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskCancelRequestedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskCancelRequestedEventAttributes? = null
        /**
         * If the event is of type `ActivityTaskCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskCanceledEventAttributes? = null
        /**
         * If the event is of type `ActivityTaskCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskCompletedEventAttributes? = null
        /**
         * If the event is of type `ActivityTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskFailedEventAttributes? = null
        /**
         * If the event is of type `ActivityTaskScheduled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskScheduledEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes? = null
        /**
         * If the event is of type `ActivityTaskStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskStartedEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskStartedEventAttributes? = null
        /**
         * If the event is of type `ActivityTaskTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var activityTaskTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.ActivityTaskTimedOutEventAttributes? = null
        /**
         * If the event is of type `CancelTimerFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var cancelTimerFailedEventAttributes: aws.sdk.kotlin.services.swf.model.CancelTimerFailedEventAttributes? = null
        /**
         * If the event is of type `CancelWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var cancelWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `ChildWorkflowExecutionCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var childWorkflowExecutionCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCanceledEventAttributes? = null
        /**
         * If the event is of type `ChildWorkflowExecutionCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var childWorkflowExecutionCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes? = null
        /**
         * If the event is of type `ChildWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var childWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `ChildWorkflowExecutionStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var childWorkflowExecutionStartedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionStartedEventAttributes? = null
        /**
         * If the event is of type `ChildWorkflowExecutionTerminated` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var childWorkflowExecutionTerminatedEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes? = null
        /**
         * If the event is of type `ChildWorkflowExecutionTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var childWorkflowExecutionTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes? = null
        /**
         * If the event is of type `CompleteWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var completeWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `ContinueAsNewWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var continueAsNewWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `DecisionTaskCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var decisionTaskCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskCompletedEventAttributes? = null
        /**
         * If the event is of type `DecisionTaskScheduled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var decisionTaskScheduledEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes? = null
        /**
         * If the event is of type `DecisionTaskStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var decisionTaskStartedEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskStartedEventAttributes? = null
        /**
         * If the event is of type `DecisionTaskTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var decisionTaskTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes? = null
        /**
         * The system generated ID of the event. This ID uniquely identifies the event with in the workflow execution history.
         */
        public var eventId: kotlin.Long = 0L
        /**
         * The date and time when the event occurred.
         */
        public var eventTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of the history event.
         */
        public var eventType: aws.sdk.kotlin.services.swf.model.EventType? = null
        /**
         * If the event is of type `ExternalWorkflowExecutionCancelRequested` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var externalWorkflowExecutionCancelRequestedEventAttributes: aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes? = null
        /**
         * If the event is of type `ExternalWorkflowExecutionSignaled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var externalWorkflowExecutionSignaledEventAttributes: aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionSignaledEventAttributes? = null
        /**
         * If the event is of type `FailWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var failWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionFailedEventAttributes? = null
        /**
         * Provides the details of the `LambdaFunctionCompleted` event. It isn't set for other event types.
         */
        public var lambdaFunctionCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionCompletedEventAttributes? = null
        /**
         * Provides the details of the `LambdaFunctionFailed` event. It isn't set for other event types.
         */
        public var lambdaFunctionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionFailedEventAttributes? = null
        /**
         * Provides the details of the `LambdaFunctionScheduled` event. It isn't set for other event types.
         */
        public var lambdaFunctionScheduledEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionScheduledEventAttributes? = null
        /**
         * Provides the details of the `LambdaFunctionStarted` event. It isn't set for other event types.
         */
        public var lambdaFunctionStartedEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionStartedEventAttributes? = null
        /**
         * Provides the details of the `LambdaFunctionTimedOut` event. It isn't set for other event types.
         */
        public var lambdaFunctionTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.LambdaFunctionTimedOutEventAttributes? = null
        /**
         * If the event is of type `MarkerRecorded` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var markerRecordedEventAttributes: aws.sdk.kotlin.services.swf.model.MarkerRecordedEventAttributes? = null
        /**
         * If the event is of type `DecisionTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var recordMarkerFailedEventAttributes: aws.sdk.kotlin.services.swf.model.RecordMarkerFailedEventAttributes? = null
        /**
         * If the event is of type `RequestCancelActivityTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var requestCancelActivityTaskFailedEventAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskFailedEventAttributes? = null
        /**
         * If the event is of type `RequestCancelExternalWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var requestCancelExternalWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `RequestCancelExternalWorkflowExecutionInitiated` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var requestCancelExternalWorkflowExecutionInitiatedEventAttributes: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes? = null
        /**
         * If the event is of type `ScheduleActivityTaskFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var scheduleActivityTaskFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes? = null
        /**
         * Provides the details of the `ScheduleLambdaFunctionFailed` event. It isn't set for other event types.
         */
        public var scheduleLambdaFunctionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes? = null
        /**
         * If the event is of type `SignalExternalWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var signalExternalWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `SignalExternalWorkflowExecutionInitiated` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var signalExternalWorkflowExecutionInitiatedEventAttributes: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes? = null
        /**
         * If the event is of type `StartChildWorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var startChildWorkflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `StartChildWorkflowExecutionInitiated` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var startChildWorkflowExecutionInitiatedEventAttributes: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes? = null
        /**
         * Provides the details of the `StartLambdaFunctionFailed` event. It isn't set for other event types.
         */
        public var startLambdaFunctionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.StartLambdaFunctionFailedEventAttributes? = null
        /**
         * If the event is of type `StartTimerFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var startTimerFailedEventAttributes: aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes? = null
        /**
         * If the event is of type `TimerCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var timerCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes? = null
        /**
         * If the event is of type `TimerFired` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var timerFiredEventAttributes: aws.sdk.kotlin.services.swf.model.TimerFiredEventAttributes? = null
        /**
         * If the event is of type `TimerStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var timerStartedEventAttributes: aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionCancelRequested` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionCancelRequestedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionCanceled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionCanceledEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCanceledEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionCompleted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionCompletedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCompletedEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionContinuedAsNew` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionContinuedAsNewEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionFailed` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionFailedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFailedEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionSignaled` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionSignaledEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionSignaledEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionStarted` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionStartedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionTerminated` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionTerminatedEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTerminatedEventAttributes? = null
        /**
         * If the event is of type `WorkflowExecutionTimedOut` then this member is set and provides detailed information about the event. It isn't set for other event types.
         */
        public var workflowExecutionTimedOutEventAttributes: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimedOutEventAttributes? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.swf.model.HistoryEvent) : this() {
            this.activityTaskCancelRequestedEventAttributes = x.activityTaskCancelRequestedEventAttributes
            this.activityTaskCanceledEventAttributes = x.activityTaskCanceledEventAttributes
            this.activityTaskCompletedEventAttributes = x.activityTaskCompletedEventAttributes
            this.activityTaskFailedEventAttributes = x.activityTaskFailedEventAttributes
            this.activityTaskScheduledEventAttributes = x.activityTaskScheduledEventAttributes
            this.activityTaskStartedEventAttributes = x.activityTaskStartedEventAttributes
            this.activityTaskTimedOutEventAttributes = x.activityTaskTimedOutEventAttributes
            this.cancelTimerFailedEventAttributes = x.cancelTimerFailedEventAttributes
            this.cancelWorkflowExecutionFailedEventAttributes = x.cancelWorkflowExecutionFailedEventAttributes
            this.childWorkflowExecutionCanceledEventAttributes = x.childWorkflowExecutionCanceledEventAttributes
            this.childWorkflowExecutionCompletedEventAttributes = x.childWorkflowExecutionCompletedEventAttributes
            this.childWorkflowExecutionFailedEventAttributes = x.childWorkflowExecutionFailedEventAttributes
            this.childWorkflowExecutionStartedEventAttributes = x.childWorkflowExecutionStartedEventAttributes
            this.childWorkflowExecutionTerminatedEventAttributes = x.childWorkflowExecutionTerminatedEventAttributes
            this.childWorkflowExecutionTimedOutEventAttributes = x.childWorkflowExecutionTimedOutEventAttributes
            this.completeWorkflowExecutionFailedEventAttributes = x.completeWorkflowExecutionFailedEventAttributes
            this.continueAsNewWorkflowExecutionFailedEventAttributes = x.continueAsNewWorkflowExecutionFailedEventAttributes
            this.decisionTaskCompletedEventAttributes = x.decisionTaskCompletedEventAttributes
            this.decisionTaskScheduledEventAttributes = x.decisionTaskScheduledEventAttributes
            this.decisionTaskStartedEventAttributes = x.decisionTaskStartedEventAttributes
            this.decisionTaskTimedOutEventAttributes = x.decisionTaskTimedOutEventAttributes
            this.eventId = x.eventId
            this.eventTimestamp = x.eventTimestamp
            this.eventType = x.eventType
            this.externalWorkflowExecutionCancelRequestedEventAttributes = x.externalWorkflowExecutionCancelRequestedEventAttributes
            this.externalWorkflowExecutionSignaledEventAttributes = x.externalWorkflowExecutionSignaledEventAttributes
            this.failWorkflowExecutionFailedEventAttributes = x.failWorkflowExecutionFailedEventAttributes
            this.lambdaFunctionCompletedEventAttributes = x.lambdaFunctionCompletedEventAttributes
            this.lambdaFunctionFailedEventAttributes = x.lambdaFunctionFailedEventAttributes
            this.lambdaFunctionScheduledEventAttributes = x.lambdaFunctionScheduledEventAttributes
            this.lambdaFunctionStartedEventAttributes = x.lambdaFunctionStartedEventAttributes
            this.lambdaFunctionTimedOutEventAttributes = x.lambdaFunctionTimedOutEventAttributes
            this.markerRecordedEventAttributes = x.markerRecordedEventAttributes
            this.recordMarkerFailedEventAttributes = x.recordMarkerFailedEventAttributes
            this.requestCancelActivityTaskFailedEventAttributes = x.requestCancelActivityTaskFailedEventAttributes
            this.requestCancelExternalWorkflowExecutionFailedEventAttributes = x.requestCancelExternalWorkflowExecutionFailedEventAttributes
            this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = x.requestCancelExternalWorkflowExecutionInitiatedEventAttributes
            this.scheduleActivityTaskFailedEventAttributes = x.scheduleActivityTaskFailedEventAttributes
            this.scheduleLambdaFunctionFailedEventAttributes = x.scheduleLambdaFunctionFailedEventAttributes
            this.signalExternalWorkflowExecutionFailedEventAttributes = x.signalExternalWorkflowExecutionFailedEventAttributes
            this.signalExternalWorkflowExecutionInitiatedEventAttributes = x.signalExternalWorkflowExecutionInitiatedEventAttributes
            this.startChildWorkflowExecutionFailedEventAttributes = x.startChildWorkflowExecutionFailedEventAttributes
            this.startChildWorkflowExecutionInitiatedEventAttributes = x.startChildWorkflowExecutionInitiatedEventAttributes
            this.startLambdaFunctionFailedEventAttributes = x.startLambdaFunctionFailedEventAttributes
            this.startTimerFailedEventAttributes = x.startTimerFailedEventAttributes
            this.timerCanceledEventAttributes = x.timerCanceledEventAttributes
            this.timerFiredEventAttributes = x.timerFiredEventAttributes
            this.timerStartedEventAttributes = x.timerStartedEventAttributes
            this.workflowExecutionCancelRequestedEventAttributes = x.workflowExecutionCancelRequestedEventAttributes
            this.workflowExecutionCanceledEventAttributes = x.workflowExecutionCanceledEventAttributes
            this.workflowExecutionCompletedEventAttributes = x.workflowExecutionCompletedEventAttributes
            this.workflowExecutionContinuedAsNewEventAttributes = x.workflowExecutionContinuedAsNewEventAttributes
            this.workflowExecutionFailedEventAttributes = x.workflowExecutionFailedEventAttributes
            this.workflowExecutionSignaledEventAttributes = x.workflowExecutionSignaledEventAttributes
            this.workflowExecutionStartedEventAttributes = x.workflowExecutionStartedEventAttributes
            this.workflowExecutionTerminatedEventAttributes = x.workflowExecutionTerminatedEventAttributes
            this.workflowExecutionTimedOutEventAttributes = x.workflowExecutionTimedOutEventAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.swf.model.HistoryEvent = HistoryEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskCancelRequestedEventAttributes] inside the given [block]
         */
        public fun activityTaskCancelRequestedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskCancelRequestedEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskCancelRequestedEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskCancelRequestedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskCanceledEventAttributes] inside the given [block]
         */
        public fun activityTaskCanceledEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskCanceledEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskCanceledEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskCanceledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskCompletedEventAttributes] inside the given [block]
         */
        public fun activityTaskCompletedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskCompletedEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskCompletedEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskCompletedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskFailedEventAttributes] inside the given [block]
         */
        public fun activityTaskFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskFailedEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes] inside the given [block]
         */
        public fun activityTaskScheduledEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskScheduledEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskScheduledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskStartedEventAttributes] inside the given [block]
         */
        public fun activityTaskStartedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskStartedEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskStartedEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskStartedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ActivityTaskTimedOutEventAttributes] inside the given [block]
         */
        public fun activityTaskTimedOutEventAttributes(block: aws.sdk.kotlin.services.swf.model.ActivityTaskTimedOutEventAttributes.Builder.() -> kotlin.Unit) {
            this.activityTaskTimedOutEventAttributes = aws.sdk.kotlin.services.swf.model.ActivityTaskTimedOutEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CancelTimerFailedEventAttributes] inside the given [block]
         */
        public fun cancelTimerFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.CancelTimerFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.cancelTimerFailedEventAttributes = aws.sdk.kotlin.services.swf.model.CancelTimerFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun cancelWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.cancelWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.CancelWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCanceledEventAttributes] inside the given [block]
         */
        public fun childWorkflowExecutionCanceledEventAttributes(block: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCanceledEventAttributes.Builder.() -> kotlin.Unit) {
            this.childWorkflowExecutionCanceledEventAttributes = aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCanceledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes] inside the given [block]
         */
        public fun childWorkflowExecutionCompletedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes.Builder.() -> kotlin.Unit) {
            this.childWorkflowExecutionCompletedEventAttributes = aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionCompletedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun childWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.childWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionStartedEventAttributes] inside the given [block]
         */
        public fun childWorkflowExecutionStartedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionStartedEventAttributes.Builder.() -> kotlin.Unit) {
            this.childWorkflowExecutionStartedEventAttributes = aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionStartedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes] inside the given [block]
         */
        public fun childWorkflowExecutionTerminatedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.Builder.() -> kotlin.Unit) {
            this.childWorkflowExecutionTerminatedEventAttributes = aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTerminatedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes] inside the given [block]
         */
        public fun childWorkflowExecutionTimedOutEventAttributes(block: aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.Builder.() -> kotlin.Unit) {
            this.childWorkflowExecutionTimedOutEventAttributes = aws.sdk.kotlin.services.swf.model.ChildWorkflowExecutionTimedOutEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun completeWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.completeWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.CompleteWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun continueAsNewWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.continueAsNewWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.ContinueAsNewWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.DecisionTaskCompletedEventAttributes] inside the given [block]
         */
        public fun decisionTaskCompletedEventAttributes(block: aws.sdk.kotlin.services.swf.model.DecisionTaskCompletedEventAttributes.Builder.() -> kotlin.Unit) {
            this.decisionTaskCompletedEventAttributes = aws.sdk.kotlin.services.swf.model.DecisionTaskCompletedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes] inside the given [block]
         */
        public fun decisionTaskScheduledEventAttributes(block: aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes.Builder.() -> kotlin.Unit) {
            this.decisionTaskScheduledEventAttributes = aws.sdk.kotlin.services.swf.model.DecisionTaskScheduledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.DecisionTaskStartedEventAttributes] inside the given [block]
         */
        public fun decisionTaskStartedEventAttributes(block: aws.sdk.kotlin.services.swf.model.DecisionTaskStartedEventAttributes.Builder.() -> kotlin.Unit) {
            this.decisionTaskStartedEventAttributes = aws.sdk.kotlin.services.swf.model.DecisionTaskStartedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes] inside the given [block]
         */
        public fun decisionTaskTimedOutEventAttributes(block: aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes.Builder.() -> kotlin.Unit) {
            this.decisionTaskTimedOutEventAttributes = aws.sdk.kotlin.services.swf.model.DecisionTaskTimedOutEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes] inside the given [block]
         */
        public fun externalWorkflowExecutionCancelRequestedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.Builder.() -> kotlin.Unit) {
            this.externalWorkflowExecutionCancelRequestedEventAttributes = aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionCancelRequestedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionSignaledEventAttributes] inside the given [block]
         */
        public fun externalWorkflowExecutionSignaledEventAttributes(block: aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.Builder.() -> kotlin.Unit) {
            this.externalWorkflowExecutionSignaledEventAttributes = aws.sdk.kotlin.services.swf.model.ExternalWorkflowExecutionSignaledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun failWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.failWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.FailWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.LambdaFunctionCompletedEventAttributes] inside the given [block]
         */
        public fun lambdaFunctionCompletedEventAttributes(block: aws.sdk.kotlin.services.swf.model.LambdaFunctionCompletedEventAttributes.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionCompletedEventAttributes = aws.sdk.kotlin.services.swf.model.LambdaFunctionCompletedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.LambdaFunctionFailedEventAttributes] inside the given [block]
         */
        public fun lambdaFunctionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.LambdaFunctionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.LambdaFunctionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.LambdaFunctionScheduledEventAttributes] inside the given [block]
         */
        public fun lambdaFunctionScheduledEventAttributes(block: aws.sdk.kotlin.services.swf.model.LambdaFunctionScheduledEventAttributes.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionScheduledEventAttributes = aws.sdk.kotlin.services.swf.model.LambdaFunctionScheduledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.LambdaFunctionStartedEventAttributes] inside the given [block]
         */
        public fun lambdaFunctionStartedEventAttributes(block: aws.sdk.kotlin.services.swf.model.LambdaFunctionStartedEventAttributes.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionStartedEventAttributes = aws.sdk.kotlin.services.swf.model.LambdaFunctionStartedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.LambdaFunctionTimedOutEventAttributes] inside the given [block]
         */
        public fun lambdaFunctionTimedOutEventAttributes(block: aws.sdk.kotlin.services.swf.model.LambdaFunctionTimedOutEventAttributes.Builder.() -> kotlin.Unit) {
            this.lambdaFunctionTimedOutEventAttributes = aws.sdk.kotlin.services.swf.model.LambdaFunctionTimedOutEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.MarkerRecordedEventAttributes] inside the given [block]
         */
        public fun markerRecordedEventAttributes(block: aws.sdk.kotlin.services.swf.model.MarkerRecordedEventAttributes.Builder.() -> kotlin.Unit) {
            this.markerRecordedEventAttributes = aws.sdk.kotlin.services.swf.model.MarkerRecordedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RecordMarkerFailedEventAttributes] inside the given [block]
         */
        public fun recordMarkerFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.RecordMarkerFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.recordMarkerFailedEventAttributes = aws.sdk.kotlin.services.swf.model.RecordMarkerFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskFailedEventAttributes] inside the given [block]
         */
        public fun requestCancelActivityTaskFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.requestCancelActivityTaskFailedEventAttributes = aws.sdk.kotlin.services.swf.model.RequestCancelActivityTaskFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun requestCancelExternalWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.requestCancelExternalWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes] inside the given [block]
         */
        public fun requestCancelExternalWorkflowExecutionInitiatedEventAttributes(block: aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.Builder.() -> kotlin.Unit) {
            this.requestCancelExternalWorkflowExecutionInitiatedEventAttributes = aws.sdk.kotlin.services.swf.model.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes] inside the given [block]
         */
        public fun scheduleActivityTaskFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.scheduleActivityTaskFailedEventAttributes = aws.sdk.kotlin.services.swf.model.ScheduleActivityTaskFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes] inside the given [block]
         */
        public fun scheduleLambdaFunctionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.scheduleLambdaFunctionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.ScheduleLambdaFunctionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun signalExternalWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.signalExternalWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes] inside the given [block]
         */
        public fun signalExternalWorkflowExecutionInitiatedEventAttributes(block: aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.Builder.() -> kotlin.Unit) {
            this.signalExternalWorkflowExecutionInitiatedEventAttributes = aws.sdk.kotlin.services.swf.model.SignalExternalWorkflowExecutionInitiatedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun startChildWorkflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.startChildWorkflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes] inside the given [block]
         */
        public fun startChildWorkflowExecutionInitiatedEventAttributes(block: aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.Builder.() -> kotlin.Unit) {
            this.startChildWorkflowExecutionInitiatedEventAttributes = aws.sdk.kotlin.services.swf.model.StartChildWorkflowExecutionInitiatedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.StartLambdaFunctionFailedEventAttributes] inside the given [block]
         */
        public fun startLambdaFunctionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.StartLambdaFunctionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.startLambdaFunctionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.StartLambdaFunctionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes] inside the given [block]
         */
        public fun startTimerFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.startTimerFailedEventAttributes = aws.sdk.kotlin.services.swf.model.StartTimerFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes] inside the given [block]
         */
        public fun timerCanceledEventAttributes(block: aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes.Builder.() -> kotlin.Unit) {
            this.timerCanceledEventAttributes = aws.sdk.kotlin.services.swf.model.TimerCanceledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TimerFiredEventAttributes] inside the given [block]
         */
        public fun timerFiredEventAttributes(block: aws.sdk.kotlin.services.swf.model.TimerFiredEventAttributes.Builder.() -> kotlin.Unit) {
            this.timerFiredEventAttributes = aws.sdk.kotlin.services.swf.model.TimerFiredEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes] inside the given [block]
         */
        public fun timerStartedEventAttributes(block: aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes.Builder.() -> kotlin.Unit) {
            this.timerStartedEventAttributes = aws.sdk.kotlin.services.swf.model.TimerStartedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes] inside the given [block]
         */
        public fun workflowExecutionCancelRequestedEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionCancelRequestedEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionCancelRequestedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionCanceledEventAttributes] inside the given [block]
         */
        public fun workflowExecutionCanceledEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCanceledEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionCanceledEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionCanceledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionCompletedEventAttributes] inside the given [block]
         */
        public fun workflowExecutionCompletedEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionCompletedEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionCompletedEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionCompletedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes] inside the given [block]
         */
        public fun workflowExecutionContinuedAsNewEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionContinuedAsNewEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionContinuedAsNewEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionFailedEventAttributes] inside the given [block]
         */
        public fun workflowExecutionFailedEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionFailedEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionFailedEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionFailedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionSignaledEventAttributes] inside the given [block]
         */
        public fun workflowExecutionSignaledEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionSignaledEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionSignaledEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionSignaledEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes] inside the given [block]
         */
        public fun workflowExecutionStartedEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionStartedEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionStartedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionTerminatedEventAttributes] inside the given [block]
         */
        public fun workflowExecutionTerminatedEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTerminatedEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionTerminatedEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionTerminatedEventAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimedOutEventAttributes] inside the given [block]
         */
        public fun workflowExecutionTimedOutEventAttributes(block: aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimedOutEventAttributes.Builder.() -> kotlin.Unit) {
            this.workflowExecutionTimedOutEventAttributes = aws.sdk.kotlin.services.swf.model.WorkflowExecutionTimedOutEventAttributes.invoke(block)
        }
    }
}
