// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp.transform

import aws.sdk.kotlin.services.supportapp.model.NotificationSeverityLevel
import aws.sdk.kotlin.services.supportapp.model.SupportAppException
import aws.sdk.kotlin.services.supportapp.model.UpdateSlackChannelConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSlackChannelConfigurationOperationDeserializer: HttpDeserialize<UpdateSlackChannelConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSlackChannelConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSlackChannelConfigurationError(context, response)
        }
        val builder = UpdateSlackChannelConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateSlackChannelConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateSlackChannelConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SupportAppException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SupportAppException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSlackChannelConfigurationOperationBody(builder: UpdateSlackChannelConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelId"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelName"))
    val CHANNELROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelRoleArn"))
    val NOTIFYONADDCORRESPONDENCETOCASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("notifyOnAddCorrespondenceToCase"))
    val NOTIFYONCASESEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notifyOnCaseSeverity"))
    val NOTIFYONCREATEORREOPENCASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("notifyOnCreateOrReopenCase"))
    val NOTIFYONRESOLVECASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("notifyOnResolveCase"))
    val TEAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("teamId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELID_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CHANNELROLEARN_DESCRIPTOR)
        field(NOTIFYONADDCORRESPONDENCETOCASE_DESCRIPTOR)
        field(NOTIFYONCASESEVERITY_DESCRIPTOR)
        field(NOTIFYONCREATEORREOPENCASE_DESCRIPTOR)
        field(NOTIFYONRESOLVECASE_DESCRIPTOR)
        field(TEAMID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELID_DESCRIPTOR.index -> builder.channelId = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CHANNELROLEARN_DESCRIPTOR.index -> builder.channelRoleArn = deserializeString()
                NOTIFYONADDCORRESPONDENCETOCASE_DESCRIPTOR.index -> builder.notifyOnAddCorrespondenceToCase = deserializeBoolean()
                NOTIFYONCASESEVERITY_DESCRIPTOR.index -> builder.notifyOnCaseSeverity = deserializeString().let { NotificationSeverityLevel.fromValue(it) }
                NOTIFYONCREATEORREOPENCASE_DESCRIPTOR.index -> builder.notifyOnCreateOrReopenCase = deserializeBoolean()
                NOTIFYONRESOLVECASE_DESCRIPTOR.index -> builder.notifyOnResolveCase = deserializeBoolean()
                TEAMID_DESCRIPTOR.index -> builder.teamId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
