// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp.paginators

import aws.sdk.kotlin.services.supportapp.SupportAppClient
import aws.sdk.kotlin.services.supportapp.model.ListSlackChannelConfigurationsRequest
import aws.sdk.kotlin.services.supportapp.model.ListSlackChannelConfigurationsResponse
import aws.sdk.kotlin.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
import aws.sdk.kotlin.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListSlackChannelConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSlackChannelConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSlackChannelConfigurationsResponse]
 */
public fun SupportAppClient.listSlackChannelConfigurationsPaginated(initialRequest: ListSlackChannelConfigurationsRequest): Flow<ListSlackChannelConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSlackChannelConfigurationsPaginated.listSlackChannelConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSlackChannelConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSlackChannelConfigurationsResponse]
 */
public fun SupportAppClient.listSlackChannelConfigurationsPaginated(block: ListSlackChannelConfigurationsRequest.Builder.() -> Unit): Flow<ListSlackChannelConfigurationsResponse> =
    listSlackChannelConfigurationsPaginated(ListSlackChannelConfigurationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListSlackWorkspaceConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSlackWorkspaceConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSlackWorkspaceConfigurationsResponse]
 */
public fun SupportAppClient.listSlackWorkspaceConfigurationsPaginated(initialRequest: ListSlackWorkspaceConfigurationsRequest): Flow<ListSlackWorkspaceConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSlackWorkspaceConfigurationsPaginated.listSlackWorkspaceConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSlackWorkspaceConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSlackWorkspaceConfigurationsResponse]
 */
public fun SupportAppClient.listSlackWorkspaceConfigurationsPaginated(block: ListSlackWorkspaceConfigurationsRequest.Builder.() -> Unit): Flow<ListSlackWorkspaceConfigurationsResponse> =
    listSlackWorkspaceConfigurationsPaginated(ListSlackWorkspaceConfigurationsRequest.Builder().apply(block).build())
