// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.supportapp.auth.DefaultSupportAppAuthSchemeProvider
import aws.sdk.kotlin.services.supportapp.auth.SupportAppAuthSchemeProvider
import aws.sdk.kotlin.services.supportapp.endpoints.DefaultSupportAppEndpointProvider
import aws.sdk.kotlin.services.supportapp.endpoints.SupportAppEndpointParameters
import aws.sdk.kotlin.services.supportapp.endpoints.SupportAppEndpointProvider
import aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationResponse
import aws.sdk.kotlin.services.supportapp.model.DeleteAccountAliasRequest
import aws.sdk.kotlin.services.supportapp.model.DeleteAccountAliasResponse
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackChannelConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackChannelConfigurationResponse
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackWorkspaceConfigurationResponse
import aws.sdk.kotlin.services.supportapp.model.GetAccountAliasRequest
import aws.sdk.kotlin.services.supportapp.model.GetAccountAliasResponse
import aws.sdk.kotlin.services.supportapp.model.ListSlackChannelConfigurationsRequest
import aws.sdk.kotlin.services.supportapp.model.ListSlackChannelConfigurationsResponse
import aws.sdk.kotlin.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
import aws.sdk.kotlin.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
import aws.sdk.kotlin.services.supportapp.model.PutAccountAliasRequest
import aws.sdk.kotlin.services.supportapp.model.PutAccountAliasResponse
import aws.sdk.kotlin.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
import aws.sdk.kotlin.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
import aws.sdk.kotlin.services.supportapp.model.UpdateSlackChannelConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.UpdateSlackChannelConfigurationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Support App"
public const val SdkVersion: String = "0.31.0-beta"

/**
 * # Amazon Web Services Support App in Slack
 * You can use the Amazon Web Services Support App in Slack API to manage your support cases in Slack for your Amazon Web Services account. After you configure your Slack workspace and channel with the Amazon Web Services Support App, you can perform the following tasks directly in your Slack channel:
 * + Create, search, update, and resolve your support cases
 * + Request service quota increases for your account
 * + Invite Amazon Web Services Support agents to your channel so that you can chat directly about your support cases
 *
 * For more information about how to perform these actions in Slack, see the following documentation in the *Amazon Web Services Support User Guide*:
 * + [Amazon Web Services Support App in Slack](https://docs.aws.amazon.com/awssupport/latest/user/aws-support-app-for-slack.html)
 * + [Joining a live chat session with Amazon Web Services Support](https://docs.aws.amazon.com/awssupport/latest/user/joining-a-live-chat-session.html)
 * + [Requesting service quota increases](https://docs.aws.amazon.com/awssupport/latest/user/service-quota-increase.html)
 * + [Amazon Web Services Support App commands in Slack](https://docs.aws.amazon.com/awssupport/latest/user/support-app-commands.html)
 *
 * You can also use the Amazon Web Services Management Console instead of the Amazon Web Services Support App API to manage your Slack configurations. For more information, see [Authorize a Slack workspace to enable the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html).
 *
 * + You must have a Business or Enterprise Support plan to use the Amazon Web Services Support App API.
 * + For more information about the Amazon Web Services Support App endpoints, see the [Amazon Web Services Support App in Slack endpoints](https://docs.aws.amazon.com/general/latest/gr/awssupport.html#awssupport_app_region) in the *Amazon Web Services General Reference*.
 */
public interface SupportAppClient : SdkClient {
    /**
     * SupportAppClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SupportAppClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SupportAppClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SupportAppClient = DefaultSupportAppClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: SupportAppAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSupportAppAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SupportAppEndpointProvider = builder.endpointProvider ?: DefaultSupportAppEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Support App"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SupportAppAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SupportAppEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Slack channel configuration for your Amazon Web Services account.
     *
     * + You can add up to 5 Slack workspaces for your account.
     * + You can add up to 20 Slack channels for your account.
     * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you need to manage support cases for your organization. This can reduce the notifications about case updates that you receive in the Slack channel.
     *
     * We recommend that you choose a private Slack channel so that only members in that channel have read and write access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your account. Users require an invitation to join private channels.
     */
    public suspend fun createSlackChannelConfiguration(input: CreateSlackChannelConfigurationRequest): CreateSlackChannelConfigurationResponse

    /**
     * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    public suspend fun deleteAccountAlias(input: DeleteAccountAliasRequest = DeleteAccountAliasRequest {}): DeleteAccountAliasResponse

    /**
     * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your Slack channel.
     */
    public suspend fun deleteSlackChannelConfiguration(input: DeleteSlackChannelConfigurationRequest): DeleteSlackChannelConfigurationResponse

    /**
     * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your Slack workspace.
     */
    public suspend fun deleteSlackWorkspaceConfiguration(input: DeleteSlackWorkspaceConfigurationRequest): DeleteSlackWorkspaceConfigurationResponse

    /**
     * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    public suspend fun getAccountAlias(input: GetAccountAliasRequest = GetAccountAliasRequest {}): GetAccountAliasResponse

    /**
     * Lists the Slack channel configurations for an Amazon Web Services account.
     */
    public suspend fun listSlackChannelConfigurations(input: ListSlackChannelConfigurationsRequest = ListSlackChannelConfigurationsRequest {}): ListSlackChannelConfigurationsResponse

    /**
     * Lists the Slack workspace configurations for an Amazon Web Services account.
     */
    public suspend fun listSlackWorkspaceConfigurations(input: ListSlackWorkspaceConfigurationsRequest = ListSlackWorkspaceConfigurationsRequest {}): ListSlackWorkspaceConfigurationsResponse

    /**
     * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    public suspend fun putAccountAlias(input: PutAccountAliasRequest): PutAccountAliasResponse

    /**
     * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of an organization in Organizations.
     *
     * If you're the *management account* and you want to register Slack workspaces for your organization, you must complete the following tasks:
     * + Sign in to the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app) and authorize the Slack workspaces where you want your organization to have access to. See [Authorize a Slack workspace](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html) in the *Amazon Web Services Support User Guide*.
     * + Call the `RegisterSlackWorkspaceForOrganization` API to authorize each Slack workspace for the organization.
     *
     * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace manually through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app).
     *
     * To use the Amazon Web Services Support App, each account must then complete the following tasks:
     * + Create an Identity and Access Management (IAM) role with the required permission. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html).
     * + Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more information, see [Configuring a Slack channel](https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html).
     */
    public suspend fun registerSlackWorkspaceForOrganization(input: RegisterSlackWorkspaceForOrganizationRequest): RegisterSlackWorkspaceForOrganizationResponse

    /**
     * Updates the configuration for a Slack channel, such as case update notifications.
     */
    public suspend fun updateSlackChannelConfiguration(input: UpdateSlackChannelConfigurationRequest): UpdateSlackChannelConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SupportAppClient.withConfig(block: SupportAppClient.Config.Builder.() -> Unit): SupportAppClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSupportAppClient(newConfig)
}

/**
 * Creates a Slack channel configuration for your Amazon Web Services account.
 *
 * + You can add up to 5 Slack workspaces for your account.
 * + You can add up to 20 Slack channels for your account.
 * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you need to manage support cases for your organization. This can reduce the notifications about case updates that you receive in the Slack channel.
 *
 * We recommend that you choose a private Slack channel so that only members in that channel have read and write access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your account. Users require an invitation to join private channels.
 */
public suspend inline fun SupportAppClient.createSlackChannelConfiguration(crossinline block: CreateSlackChannelConfigurationRequest.Builder.() -> Unit): CreateSlackChannelConfigurationResponse = createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
 */
public suspend inline fun SupportAppClient.deleteAccountAlias(crossinline block: DeleteAccountAliasRequest.Builder.() -> Unit): DeleteAccountAliasResponse = deleteAccountAlias(DeleteAccountAliasRequest.Builder().apply(block).build())

/**
 * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your Slack channel.
 */
public suspend inline fun SupportAppClient.deleteSlackChannelConfiguration(crossinline block: DeleteSlackChannelConfigurationRequest.Builder.() -> Unit): DeleteSlackChannelConfigurationResponse = deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your Slack workspace.
 */
public suspend inline fun SupportAppClient.deleteSlackWorkspaceConfiguration(crossinline block: DeleteSlackWorkspaceConfigurationRequest.Builder.() -> Unit): DeleteSlackWorkspaceConfigurationResponse = deleteSlackWorkspaceConfiguration(DeleteSlackWorkspaceConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
 */
public suspend inline fun SupportAppClient.getAccountAlias(crossinline block: GetAccountAliasRequest.Builder.() -> Unit): GetAccountAliasResponse = getAccountAlias(GetAccountAliasRequest.Builder().apply(block).build())

/**
 * Lists the Slack channel configurations for an Amazon Web Services account.
 */
public suspend inline fun SupportAppClient.listSlackChannelConfigurations(crossinline block: ListSlackChannelConfigurationsRequest.Builder.() -> Unit): ListSlackChannelConfigurationsResponse = listSlackChannelConfigurations(ListSlackChannelConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the Slack workspace configurations for an Amazon Web Services account.
 */
public suspend inline fun SupportAppClient.listSlackWorkspaceConfigurations(crossinline block: ListSlackWorkspaceConfigurationsRequest.Builder.() -> Unit): ListSlackWorkspaceConfigurationsResponse = listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsRequest.Builder().apply(block).build())

/**
 * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
 */
public suspend inline fun SupportAppClient.putAccountAlias(crossinline block: PutAccountAliasRequest.Builder.() -> Unit): PutAccountAliasResponse = putAccountAlias(PutAccountAliasRequest.Builder().apply(block).build())

/**
 * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of an organization in Organizations.
 *
 * If you're the *management account* and you want to register Slack workspaces for your organization, you must complete the following tasks:
 * + Sign in to the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app) and authorize the Slack workspaces where you want your organization to have access to. See [Authorize a Slack workspace](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html) in the *Amazon Web Services Support User Guide*.
 * + Call the `RegisterSlackWorkspaceForOrganization` API to authorize each Slack workspace for the organization.
 *
 * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace manually through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app).
 *
 * To use the Amazon Web Services Support App, each account must then complete the following tasks:
 * + Create an Identity and Access Management (IAM) role with the required permission. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html).
 * + Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more information, see [Configuring a Slack channel](https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html).
 */
public suspend inline fun SupportAppClient.registerSlackWorkspaceForOrganization(crossinline block: RegisterSlackWorkspaceForOrganizationRequest.Builder.() -> Unit): RegisterSlackWorkspaceForOrganizationResponse = registerSlackWorkspaceForOrganization(RegisterSlackWorkspaceForOrganizationRequest.Builder().apply(block).build())

/**
 * Updates the configuration for a Slack channel, such as case update notifications.
 */
public suspend inline fun SupportAppClient.updateSlackChannelConfiguration(crossinline block: UpdateSlackChannelConfigurationRequest.Builder.() -> Unit): UpdateSlackChannelConfigurationResponse = updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest.Builder().apply(block).build())
