// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.supportapp.model.AccountType
import aws.sdk.kotlin.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
import aws.sdk.kotlin.services.supportapp.model.SupportAppException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RegisterSlackWorkspaceForOrganizationOperationDeserializer: HttpDeserialize<RegisterSlackWorkspaceForOrganizationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterSlackWorkspaceForOrganizationResponse {
        if (!response.status.isSuccess()) {
            throwRegisterSlackWorkspaceForOrganizationError(context, response)
        }
        val builder = RegisterSlackWorkspaceForOrganizationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterSlackWorkspaceForOrganizationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterSlackWorkspaceForOrganizationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SupportAppException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SupportAppException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterSlackWorkspaceForOrganizationOperationBody(builder: RegisterSlackWorkspaceForOrganizationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accountType"))
    val TEAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("teamId"))
    val TEAMNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("teamName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTTYPE_DESCRIPTOR)
        field(TEAMID_DESCRIPTOR)
        field(TEAMNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTTYPE_DESCRIPTOR.index -> builder.accountType = deserializeString().let { AccountType.fromValue(it) }
                TEAMID_DESCRIPTOR.index -> builder.teamId = deserializeString()
                TEAMNAME_DESCRIPTOR.index -> builder.teamName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
