// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.supportapp.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.supportapp.endpoints.EndpointProvider
import aws.sdk.kotlin.services.supportapp.model.*
import aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationResponse
import aws.sdk.kotlin.services.supportapp.model.DeleteAccountAliasRequest
import aws.sdk.kotlin.services.supportapp.model.DeleteAccountAliasResponse
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackChannelConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackChannelConfigurationResponse
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackWorkspaceConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.DeleteSlackWorkspaceConfigurationResponse
import aws.sdk.kotlin.services.supportapp.model.GetAccountAliasRequest
import aws.sdk.kotlin.services.supportapp.model.GetAccountAliasResponse
import aws.sdk.kotlin.services.supportapp.model.ListSlackChannelConfigurationsRequest
import aws.sdk.kotlin.services.supportapp.model.ListSlackChannelConfigurationsResponse
import aws.sdk.kotlin.services.supportapp.model.ListSlackWorkspaceConfigurationsRequest
import aws.sdk.kotlin.services.supportapp.model.ListSlackWorkspaceConfigurationsResponse
import aws.sdk.kotlin.services.supportapp.model.PutAccountAliasRequest
import aws.sdk.kotlin.services.supportapp.model.PutAccountAliasResponse
import aws.sdk.kotlin.services.supportapp.model.RegisterSlackWorkspaceForOrganizationRequest
import aws.sdk.kotlin.services.supportapp.model.RegisterSlackWorkspaceForOrganizationResponse
import aws.sdk.kotlin.services.supportapp.model.UpdateSlackChannelConfigurationRequest
import aws.sdk.kotlin.services.supportapp.model.UpdateSlackChannelConfigurationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # Amazon Web Services Support App in Slack
 * You can use the Amazon Web Services Support App in Slack API to manage your support cases in Slack for your Amazon Web Services account. After you configure your Slack workspace and channel with the Amazon Web Services Support App, you can perform the following tasks directly in your Slack channel:
 * + Create, search, update, and resolve your support cases
 * + Request service quota increases for your account
 * + Invite Amazon Web Services Support agents to your channel so that you can chat directly about your support cases
 *
 * For more information about how to perform these actions in Slack, see the following documentation in the *Amazon Web Services Support User Guide*:
 * + [Amazon Web Services Support App in Slack](https://docs.aws.amazon.com/awssupport/latest/user/aws-support-app-for-slack.html)
 * + [Joining a live chat session with Amazon Web Services Support](https://docs.aws.amazon.com/awssupport/latest/user/joining-a-live-chat-session.html)
 * + [Requesting service quota increases](https://docs.aws.amazon.com/awssupport/latest/user/service-quota-increase.html)
 * + [Amazon Web Services Support App commands in Slack](https://docs.aws.amazon.com/awssupport/latest/user/support-app-commands.html)
 *
 * You can also use the Amazon Web Services Management Console instead of the Amazon Web Services Support App API to manage your Slack configurations. For more information, see [Authorize a Slack workspace to enable the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html).
 *
 * + You must have a Business or Enterprise Support plan to use the Amazon Web Services Support App API.
 * + For more information about the Amazon Web Services Support App endpoints, see the [Amazon Web Services Support App in Slack endpoints](https://docs.aws.amazon.com/general/latest/gr/awssupport.html#awssupport_app_region) in the *Amazon Web Services General Reference*.
 */
public interface SupportAppClient : SdkClient {

    override val serviceName: String
        get() = "Support App"
    /**
     * SupportAppClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): SupportAppClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSupportAppClient(config)
        }

        public operator fun invoke(config: Config): SupportAppClient = DefaultSupportAppClient(config)

        /**
         * Construct a [SupportAppClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SupportAppClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultSupportAppClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Support App")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Slack channel configuration for your Amazon Web Services account.
     *
     * + You can add up to 5 Slack workspaces for your account.
     * + You can add up to 20 Slack channels for your account.
     * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you need to manage support cases for your organization. This can reduce the notifications about case updates that you receive in the Slack channel.
     *
     * We recommend that you choose a private Slack channel so that only members in that channel have read and write access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your account. Users require an invitation to join private channels.
     */
    public suspend fun createSlackChannelConfiguration(input: CreateSlackChannelConfigurationRequest): CreateSlackChannelConfigurationResponse

    /**
     * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    public suspend fun deleteAccountAlias(input: DeleteAccountAliasRequest = DeleteAccountAliasRequest {}): DeleteAccountAliasResponse

    /**
     * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your Slack channel.
     */
    public suspend fun deleteSlackChannelConfiguration(input: DeleteSlackChannelConfigurationRequest): DeleteSlackChannelConfigurationResponse

    /**
     * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your Slack workspace.
     */
    public suspend fun deleteSlackWorkspaceConfiguration(input: DeleteSlackWorkspaceConfigurationRequest): DeleteSlackWorkspaceConfigurationResponse

    /**
     * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    public suspend fun getAccountAlias(input: GetAccountAliasRequest = GetAccountAliasRequest {}): GetAccountAliasResponse

    /**
     * Lists the Slack channel configurations for an Amazon Web Services account.
     */
    public suspend fun listSlackChannelConfigurations(input: ListSlackChannelConfigurationsRequest = ListSlackChannelConfigurationsRequest {}): ListSlackChannelConfigurationsResponse

    /**
     * Lists the Slack workspace configurations for an Amazon Web Services account.
     */
    public suspend fun listSlackWorkspaceConfigurations(input: ListSlackWorkspaceConfigurationsRequest = ListSlackWorkspaceConfigurationsRequest {}): ListSlackWorkspaceConfigurationsResponse

    /**
     * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    public suspend fun putAccountAlias(input: PutAccountAliasRequest): PutAccountAliasResponse

    /**
     * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of an organization in Organizations.
     *
     * If you're the *management account* and you want to register Slack workspaces for your organization, you must complete the following tasks:
     * + Sign in to the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app) and authorize the Slack workspaces where you want your organization to have access to. See [Authorize a Slack workspace](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html) in the *Amazon Web Services Support User Guide*.
     * + Call the `RegisterSlackWorkspaceForOrganization` API to authorize each Slack workspace for the organization.
     *
     * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace manually through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app).
     *
     * To use the Amazon Web Services Support App, each account must then complete the following tasks:
     * + Create an Identity and Access Management (IAM) role with the required permission. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html).
     * + Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more information, see [Configuring a Slack channel](https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html).
     */
    public suspend fun registerSlackWorkspaceForOrganization(input: RegisterSlackWorkspaceForOrganizationRequest): RegisterSlackWorkspaceForOrganizationResponse

    /**
     * Updates the configuration for a Slack channel, such as case update notifications.
     */
    public suspend fun updateSlackChannelConfiguration(input: UpdateSlackChannelConfigurationRequest): UpdateSlackChannelConfigurationResponse
}

/**
 * Creates a Slack channel configuration for your Amazon Web Services account.
 *
 * + You can add up to 5 Slack workspaces for your account.
 * + You can add up to 20 Slack channels for your account.
 * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you need to manage support cases for your organization. This can reduce the notifications about case updates that you receive in the Slack channel.
 *
 * We recommend that you choose a private Slack channel so that only members in that channel have read and write access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your account. Users require an invitation to join private channels.
 */
public suspend inline fun SupportAppClient.createSlackChannelConfiguration(crossinline block: CreateSlackChannelConfigurationRequest.Builder.() -> Unit): CreateSlackChannelConfigurationResponse = createSlackChannelConfiguration(CreateSlackChannelConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
 */
public suspend inline fun SupportAppClient.deleteAccountAlias(crossinline block: DeleteAccountAliasRequest.Builder.() -> Unit): DeleteAccountAliasResponse = deleteAccountAlias(DeleteAccountAliasRequest.Builder().apply(block).build())

/**
 * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your Slack channel.
 */
public suspend inline fun SupportAppClient.deleteSlackChannelConfiguration(crossinline block: DeleteSlackChannelConfigurationRequest.Builder.() -> Unit): DeleteSlackChannelConfigurationResponse = deleteSlackChannelConfiguration(DeleteSlackChannelConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your Slack workspace.
 */
public suspend inline fun SupportAppClient.deleteSlackWorkspaceConfiguration(crossinline block: DeleteSlackWorkspaceConfigurationRequest.Builder.() -> Unit): DeleteSlackWorkspaceConfigurationResponse = deleteSlackWorkspaceConfiguration(DeleteSlackWorkspaceConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
 */
public suspend inline fun SupportAppClient.getAccountAlias(crossinline block: GetAccountAliasRequest.Builder.() -> Unit): GetAccountAliasResponse = getAccountAlias(GetAccountAliasRequest.Builder().apply(block).build())

/**
 * Lists the Slack channel configurations for an Amazon Web Services account.
 */
public suspend inline fun SupportAppClient.listSlackChannelConfigurations(crossinline block: ListSlackChannelConfigurationsRequest.Builder.() -> Unit): ListSlackChannelConfigurationsResponse = listSlackChannelConfigurations(ListSlackChannelConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists the Slack workspace configurations for an Amazon Web Services account.
 */
public suspend inline fun SupportAppClient.listSlackWorkspaceConfigurations(crossinline block: ListSlackWorkspaceConfigurationsRequest.Builder.() -> Unit): ListSlackWorkspaceConfigurationsResponse = listSlackWorkspaceConfigurations(ListSlackWorkspaceConfigurationsRequest.Builder().apply(block).build())

/**
 * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
 */
public suspend inline fun SupportAppClient.putAccountAlias(crossinline block: PutAccountAliasRequest.Builder.() -> Unit): PutAccountAliasResponse = putAccountAlias(PutAccountAliasRequest.Builder().apply(block).build())

/**
 * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of an organization in Organizations.
 *
 * If you're the *management account* and you want to register Slack workspaces for your organization, you must complete the following tasks:
 * + Sign in to the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app) and authorize the Slack workspaces where you want your organization to have access to. See [Authorize a Slack workspace](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html) in the *Amazon Web Services Support User Guide*.
 * + Call the `RegisterSlackWorkspaceForOrganization` API to authorize each Slack workspace for the organization.
 *
 * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace manually through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app).
 *
 * To use the Amazon Web Services Support App, each account must then complete the following tasks:
 * + Create an Identity and Access Management (IAM) role with the required permission. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html).
 * + Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more information, see [Configuring a Slack channel](https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html).
 */
public suspend inline fun SupportAppClient.registerSlackWorkspaceForOrganization(crossinline block: RegisterSlackWorkspaceForOrganizationRequest.Builder.() -> Unit): RegisterSlackWorkspaceForOrganizationResponse = registerSlackWorkspaceForOrganization(RegisterSlackWorkspaceForOrganizationRequest.Builder().apply(block).build())

/**
 * Updates the configuration for a Slack channel, such as case update notifications.
 */
public suspend inline fun SupportAppClient.updateSlackChannelConfiguration(crossinline block: UpdateSlackChannelConfigurationRequest.Builder.() -> Unit): UpdateSlackChannelConfigurationResponse = updateSlackChannelConfiguration(UpdateSlackChannelConfigurationRequest.Builder().apply(block).build())
