// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.supportapp.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.supportapp.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.supportapp.model.*
import aws.sdk.kotlin.services.supportapp.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Support App"
public const val ServiceApiVersion: String = "2021-08-20"
public const val SdkVersion: String = "0.19.0-beta"

internal class DefaultSupportAppClient(override val config: SupportAppClient.Config) : SupportAppClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a Slack channel configuration for your Amazon Web Services account.
     *
     * + You can add up to 5 Slack workspaces for your account.
     * + You can add up to 20 Slack channels for your account.
     * A Slack channel can have up to 100 Amazon Web Services accounts. This means that only 100 accounts can add the same Slack channel to the Amazon Web Services Support App. We recommend that you only add the accounts that you need to manage support cases for your organization. This can reduce the notifications about case updates that you receive in the Slack channel.
     *
     * We recommend that you choose a private Slack channel so that only members in that channel have read and write access to your support cases. Anyone in your Slack channel can create, update, or resolve support cases for your account. Users require an invitation to join private channels.
     */
    override suspend fun createSlackChannelConfiguration(input: CreateSlackChannelConfigurationRequest): CreateSlackChannelConfigurationResponse {
        val op = SdkHttpOperation.build<CreateSlackChannelConfigurationRequest, CreateSlackChannelConfigurationResponse> {
            serializer = CreateSlackChannelConfigurationOperationSerializer()
            deserializer = CreateSlackChannelConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSlackChannelConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateSlackChannelConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an alias for an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    override suspend fun deleteAccountAlias(input: DeleteAccountAliasRequest): DeleteAccountAliasResponse {
        val op = SdkHttpOperation.build<DeleteAccountAliasRequest, DeleteAccountAliasResponse> {
            serializer = DeleteAccountAliasOperationSerializer()
            deserializer = DeleteAccountAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccountAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteAccountAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Slack channel configuration from your Amazon Web Services account. This operation doesn't delete your Slack channel.
     */
    override suspend fun deleteSlackChannelConfiguration(input: DeleteSlackChannelConfigurationRequest): DeleteSlackChannelConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteSlackChannelConfigurationRequest, DeleteSlackChannelConfigurationResponse> {
            serializer = DeleteSlackChannelConfigurationOperationSerializer()
            deserializer = DeleteSlackChannelConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSlackChannelConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteSlackChannelConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a Slack workspace configuration from your Amazon Web Services account. This operation doesn't delete your Slack workspace.
     */
    override suspend fun deleteSlackWorkspaceConfiguration(input: DeleteSlackWorkspaceConfigurationRequest): DeleteSlackWorkspaceConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteSlackWorkspaceConfigurationRequest, DeleteSlackWorkspaceConfigurationResponse> {
            serializer = DeleteSlackWorkspaceConfigurationOperationSerializer()
            deserializer = DeleteSlackWorkspaceConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSlackWorkspaceConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteSlackWorkspaceConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the alias from an Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    override suspend fun getAccountAlias(input: GetAccountAliasRequest): GetAccountAliasResponse {
        val op = SdkHttpOperation.build<GetAccountAliasRequest, GetAccountAliasResponse> {
            serializer = GetAccountAliasOperationSerializer()
            deserializer = GetAccountAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAccountAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetAccountAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the Slack channel configurations for an Amazon Web Services account.
     */
    override suspend fun listSlackChannelConfigurations(input: ListSlackChannelConfigurationsRequest): ListSlackChannelConfigurationsResponse {
        val op = SdkHttpOperation.build<ListSlackChannelConfigurationsRequest, ListSlackChannelConfigurationsResponse> {
            serializer = ListSlackChannelConfigurationsOperationSerializer()
            deserializer = ListSlackChannelConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSlackChannelConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListSlackChannelConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the Slack workspace configurations for an Amazon Web Services account.
     */
    override suspend fun listSlackWorkspaceConfigurations(input: ListSlackWorkspaceConfigurationsRequest): ListSlackWorkspaceConfigurationsResponse {
        val op = SdkHttpOperation.build<ListSlackWorkspaceConfigurationsRequest, ListSlackWorkspaceConfigurationsResponse> {
            serializer = ListSlackWorkspaceConfigurationsOperationSerializer()
            deserializer = ListSlackWorkspaceConfigurationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSlackWorkspaceConfigurations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListSlackWorkspaceConfigurations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates or updates an individual alias for each Amazon Web Services account ID. The alias appears in the Amazon Web Services Support App page of the Amazon Web Services Support Center. The alias also appears in Slack messages from the Amazon Web Services Support App.
     */
    override suspend fun putAccountAlias(input: PutAccountAliasRequest): PutAccountAliasResponse {
        val op = SdkHttpOperation.build<PutAccountAliasRequest, PutAccountAliasResponse> {
            serializer = PutAccountAliasOperationSerializer()
            deserializer = PutAccountAliasOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAccountAlias"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutAccountAlias-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Registers a Slack workspace for your Amazon Web Services account. To call this API, your account must be part of an organization in Organizations.
     *
     * If you're the *management account* and you want to register Slack workspaces for your organization, you must complete the following tasks:
     * + Sign in to the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app) and authorize the Slack workspaces where you want your organization to have access to. See [Authorize a Slack workspace](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html) in the *Amazon Web Services Support User Guide*.
     * + Call the `RegisterSlackWorkspaceForOrganization` API to authorize each Slack workspace for the organization.
     *
     * After the management account authorizes the Slack workspace, member accounts can call this API to authorize the same Slack workspace for their individual accounts. Member accounts don't need to authorize the Slack workspace manually through the [Amazon Web Services Support Center](https://console.aws.amazon.com/support/app).
     *
     * To use the Amazon Web Services Support App, each account must then complete the following tasks:
     * + Create an Identity and Access Management (IAM) role with the required permission. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html).
     * + Configure a Slack channel to use the Amazon Web Services Support App for support cases for that account. For more information, see [Configuring a Slack channel](https://docs.aws.amazon.com/awssupport/latest/user/add-your-slack-channel.html).
     */
    override suspend fun registerSlackWorkspaceForOrganization(input: RegisterSlackWorkspaceForOrganizationRequest): RegisterSlackWorkspaceForOrganizationResponse {
        val op = SdkHttpOperation.build<RegisterSlackWorkspaceForOrganizationRequest, RegisterSlackWorkspaceForOrganizationResponse> {
            serializer = RegisterSlackWorkspaceForOrganizationOperationSerializer()
            deserializer = RegisterSlackWorkspaceForOrganizationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterSlackWorkspaceForOrganization"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RegisterSlackWorkspaceForOrganization-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration for a Slack channel, such as case update notifications.
     */
    override suspend fun updateSlackChannelConfiguration(input: UpdateSlackChannelConfigurationRequest): UpdateSlackChannelConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateSlackChannelConfigurationRequest, UpdateSlackChannelConfigurationResponse> {
            serializer = UpdateSlackChannelConfigurationOperationSerializer()
            deserializer = UpdateSlackChannelConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSlackChannelConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "supportapp"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateSlackChannelConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "supportapp")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
