// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp.serde

import aws.sdk.kotlin.services.supportapp.model.NotificationSeverityLevel
import aws.sdk.kotlin.services.supportapp.model.SupportAppException
import aws.sdk.kotlin.services.supportapp.model.UpdateSlackChannelConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSlackChannelConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<UpdateSlackChannelConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateSlackChannelConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSlackChannelConfigurationError(context, call, payload)
        }
        val builder = UpdateSlackChannelConfigurationResponse.Builder()

        if (payload != null) {
            deserializeUpdateSlackChannelConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateSlackChannelConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SupportAppException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SupportAppException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSlackChannelConfigurationOperationBody(builder: UpdateSlackChannelConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelId"))
    val CHANNELNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelName"))
    val CHANNELROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelRoleArn"))
    val NOTIFYONADDCORRESPONDENCETOCASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("notifyOnAddCorrespondenceToCase"))
    val NOTIFYONCASESEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("notifyOnCaseSeverity"))
    val NOTIFYONCREATEORREOPENCASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("notifyOnCreateOrReopenCase"))
    val NOTIFYONRESOLVECASE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("notifyOnResolveCase"))
    val TEAMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("teamId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELID_DESCRIPTOR)
        field(CHANNELNAME_DESCRIPTOR)
        field(CHANNELROLEARN_DESCRIPTOR)
        field(NOTIFYONADDCORRESPONDENCETOCASE_DESCRIPTOR)
        field(NOTIFYONCASESEVERITY_DESCRIPTOR)
        field(NOTIFYONCREATEORREOPENCASE_DESCRIPTOR)
        field(NOTIFYONRESOLVECASE_DESCRIPTOR)
        field(TEAMID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANNELID_DESCRIPTOR.index -> builder.channelId = deserializeString()
                CHANNELNAME_DESCRIPTOR.index -> builder.channelName = deserializeString()
                CHANNELROLEARN_DESCRIPTOR.index -> builder.channelRoleArn = deserializeString()
                NOTIFYONADDCORRESPONDENCETOCASE_DESCRIPTOR.index -> builder.notifyOnAddCorrespondenceToCase = deserializeBoolean()
                NOTIFYONCASESEVERITY_DESCRIPTOR.index -> builder.notifyOnCaseSeverity = deserializeString().let { NotificationSeverityLevel.fromValue(it) }
                NOTIFYONCREATEORREOPENCASE_DESCRIPTOR.index -> builder.notifyOnCreateOrReopenCase = deserializeBoolean()
                NOTIFYONRESOLVECASE_DESCRIPTOR.index -> builder.notifyOnResolveCase = deserializeBoolean()
                TEAMID_DESCRIPTOR.index -> builder.teamId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
