// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.supportapp.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateSlackChannelConfigurationRequest private constructor(builder: Builder) {
    /**
     * The channel ID in Slack. This ID identifies a channel within a Slack workspace.
     */
    public val channelId: kotlin.String = requireNotNull(builder.channelId) { "A non-null value must be provided for channelId" }
    /**
     * The name of the Slack channel that you configure for the Amazon Web Services Support App.
     */
    public val channelName: kotlin.String? = builder.channelName
    /**
     * The Amazon Resource Name (ARN) of an IAM role that you want to use to perform operations on Amazon Web Services. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html) in the *Amazon Web Services Support User Guide*.
     */
    public val channelRoleArn: kotlin.String = requireNotNull(builder.channelRoleArn) { "A non-null value must be provided for channelRoleArn" }
    /**
     * Whether you want to get notified when a support case has a new correspondence.
     */
    public val notifyOnAddCorrespondenceToCase: kotlin.Boolean? = builder.notifyOnAddCorrespondenceToCase
    /**
     * The case severity for a support case that you want to receive notifications.
     *
     * If you specify `high` or `all`, you must specify `true` for at least one of the following parameters:
     * + `notifyOnAddCorrespondenceToCase`
     * + `notifyOnCreateOrReopenCase`
     * + `notifyOnResolveCase`
     *
     * If you specify `none`, the following parameters must be null or `false`:
     * + `notifyOnAddCorrespondenceToCase`
     * + `notifyOnCreateOrReopenCase`
     * + `notifyOnResolveCase`
     *
     * If you don't specify these parameters in your request, they default to `false`.
     */
    public val notifyOnCaseSeverity: aws.sdk.kotlin.services.supportapp.model.NotificationSeverityLevel = requireNotNull(builder.notifyOnCaseSeverity) { "A non-null value must be provided for notifyOnCaseSeverity" }
    /**
     * Whether you want to get notified when a support case is created or reopened.
     */
    public val notifyOnCreateOrReopenCase: kotlin.Boolean? = builder.notifyOnCreateOrReopenCase
    /**
     * Whether you want to get notified when a support case is resolved.
     */
    public val notifyOnResolveCase: kotlin.Boolean? = builder.notifyOnResolveCase
    /**
     * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as `T012ABCDEFG`.
     */
    public val teamId: kotlin.String = requireNotNull(builder.teamId) { "A non-null value must be provided for teamId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateSlackChannelConfigurationRequest(")
        append("channelId=$channelId,")
        append("channelName=$channelName,")
        append("channelRoleArn=$channelRoleArn,")
        append("notifyOnAddCorrespondenceToCase=$notifyOnAddCorrespondenceToCase,")
        append("notifyOnCaseSeverity=$notifyOnCaseSeverity,")
        append("notifyOnCreateOrReopenCase=$notifyOnCreateOrReopenCase,")
        append("notifyOnResolveCase=$notifyOnResolveCase,")
        append("teamId=$teamId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = channelId.hashCode()
        result = 31 * result + (channelName?.hashCode() ?: 0)
        result = 31 * result + (channelRoleArn.hashCode())
        result = 31 * result + (notifyOnAddCorrespondenceToCase?.hashCode() ?: 0)
        result = 31 * result + (notifyOnCaseSeverity.hashCode())
        result = 31 * result + (notifyOnCreateOrReopenCase?.hashCode() ?: 0)
        result = 31 * result + (notifyOnResolveCase?.hashCode() ?: 0)
        result = 31 * result + (teamId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateSlackChannelConfigurationRequest

        if (channelId != other.channelId) return false
        if (channelName != other.channelName) return false
        if (channelRoleArn != other.channelRoleArn) return false
        if (notifyOnAddCorrespondenceToCase != other.notifyOnAddCorrespondenceToCase) return false
        if (notifyOnCaseSeverity != other.notifyOnCaseSeverity) return false
        if (notifyOnCreateOrReopenCase != other.notifyOnCreateOrReopenCase) return false
        if (notifyOnResolveCase != other.notifyOnResolveCase) return false
        if (teamId != other.teamId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The channel ID in Slack. This ID identifies a channel within a Slack workspace.
         */
        public var channelId: kotlin.String? = null
        /**
         * The name of the Slack channel that you configure for the Amazon Web Services Support App.
         */
        public var channelName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that you want to use to perform operations on Amazon Web Services. For more information, see [Managing access to the Amazon Web Services Support App](https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html) in the *Amazon Web Services Support User Guide*.
         */
        public var channelRoleArn: kotlin.String? = null
        /**
         * Whether you want to get notified when a support case has a new correspondence.
         */
        public var notifyOnAddCorrespondenceToCase: kotlin.Boolean? = null
        /**
         * The case severity for a support case that you want to receive notifications.
         *
         * If you specify `high` or `all`, you must specify `true` for at least one of the following parameters:
         * + `notifyOnAddCorrespondenceToCase`
         * + `notifyOnCreateOrReopenCase`
         * + `notifyOnResolveCase`
         *
         * If you specify `none`, the following parameters must be null or `false`:
         * + `notifyOnAddCorrespondenceToCase`
         * + `notifyOnCreateOrReopenCase`
         * + `notifyOnResolveCase`
         *
         * If you don't specify these parameters in your request, they default to `false`.
         */
        public var notifyOnCaseSeverity: aws.sdk.kotlin.services.supportapp.model.NotificationSeverityLevel? = null
        /**
         * Whether you want to get notified when a support case is created or reopened.
         */
        public var notifyOnCreateOrReopenCase: kotlin.Boolean? = null
        /**
         * Whether you want to get notified when a support case is resolved.
         */
        public var notifyOnResolveCase: kotlin.Boolean? = null
        /**
         * The team ID in Slack. This ID uniquely identifies a Slack workspace, such as `T012ABCDEFG`.
         */
        public var teamId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationRequest) : this() {
            this.channelId = x.channelId
            this.channelName = x.channelName
            this.channelRoleArn = x.channelRoleArn
            this.notifyOnAddCorrespondenceToCase = x.notifyOnAddCorrespondenceToCase
            this.notifyOnCaseSeverity = x.notifyOnCaseSeverity
            this.notifyOnCreateOrReopenCase = x.notifyOnCreateOrReopenCase
            this.notifyOnResolveCase = x.notifyOnResolveCase
            this.teamId = x.teamId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.supportapp.model.CreateSlackChannelConfigurationRequest = CreateSlackChannelConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            if (channelId == null) channelId = ""
            if (channelRoleArn == null) channelRoleArn = ""
            if (notifyOnCaseSeverity == null) notifyOnCaseSeverity = NotificationSeverityLevel.SdkUnknown("no value provided")
            if (teamId == null) teamId = ""
            return this
        }
    }
}
