// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The description and metadata for a Trusted Advisor check.
 */
public class TrustedAdvisorCheckDescription private constructor(builder: Builder) {
    /**
     * The category of the Trusted Advisor check.
     */
    public val category: kotlin.String = requireNotNull(builder.category) { "A non-null value must be provided for category" }
    /**
     * The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The unique identifier for the Trusted Advisor check.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the **Metadata** element of the TrustedAdvisorResourceDetail for the check. **Metadata** contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.
     */
    public val metadata: List<String?> = requireNotNull(builder.metadata) { "A non-null value must be provided for metadata" }
    /**
     * The display name for the Trusted Advisor check.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustedAdvisorCheckDescription(")
        append("category=$category,")
        append("description=$description,")
        append("id=$id,")
        append("metadata=$metadata,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = category.hashCode()
        result = 31 * result + (description.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (metadata.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustedAdvisorCheckDescription

        if (category != other.category) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (metadata != other.metadata) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The category of the Trusted Advisor check.
         */
        public var category: kotlin.String? = null
        /**
         * The description of the Trusted Advisor check, which includes the alert criteria and recommended operations (contains HTML markup).
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the Trusted Advisor check.
         */
        public var id: kotlin.String? = null
        /**
         * The column headings for the data returned by the Trusted Advisor check. The order of the headings corresponds to the order of the data in the **Metadata** element of the TrustedAdvisorResourceDetail for the check. **Metadata** contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.
         */
        public var metadata: List<String?>? = null
        /**
         * The display name for the Trusted Advisor check.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckDescription) : this() {
            this.category = x.category
            this.description = x.description
            this.id = x.id
            this.metadata = x.metadata
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckDescription = TrustedAdvisorCheckDescription(this)

        internal fun correctErrors(): Builder {
            if (category == null) category = ""
            if (description == null) description = ""
            if (id == null) id = ""
            if (metadata == null) metadata = emptyList()
            if (name == null) name = ""
            return this
        }
    }
}
