// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A JSON-formatted object that contains the CommunicationTypeOptions for creating a case for a certain communication channel. It is contained in the response from a DescribeCreateCaseOptions request. **CommunicationTypeOptions** contains the following fields:
 * + **datesWithoutSupport** - A JSON-formatted list containing date and time ranges for periods without support in UTC time. Date and time format is RFC 3339 : 'yyyy-MM-dd'T'HH:mm:ss.SSSZZ'.
 * + **supportedHours** - A JSON-formatted list containing time ranges when support are available. Time format is RFC 3339 : 'HH:mm:ss.SSS'.
 * + **type** - A string value indicating the communication type that the aforementioned rules apply to. At the moment the type value can assume one of 3 values at the moment `chat`, `web` and `call`.
 */
public class CommunicationTypeOptions private constructor(builder: Builder) {
    /**
     * A JSON-formatted list containing date and time ranges for periods without support
     */
    public val datesWithoutSupport: List<DateInterval>? = builder.datesWithoutSupport
    /**
     * A JSON-formatted list containing time ranges when support is available.
     */
    public val supportedHours: List<SupportedHour>? = builder.supportedHours
    /**
     * A string value indicating the communication type. At the moment the type value can assume one of 3 values at the moment chat, web and call.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.CommunicationTypeOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommunicationTypeOptions(")
        append("datesWithoutSupport=$datesWithoutSupport,")
        append("supportedHours=$supportedHours,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = datesWithoutSupport?.hashCode() ?: 0
        result = 31 * result + (supportedHours?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommunicationTypeOptions

        if (datesWithoutSupport != other.datesWithoutSupport) return false
        if (supportedHours != other.supportedHours) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.CommunicationTypeOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A JSON-formatted list containing date and time ranges for periods without support
         */
        public var datesWithoutSupport: List<DateInterval>? = null
        /**
         * A JSON-formatted list containing time ranges when support is available.
         */
        public var supportedHours: List<SupportedHour>? = null
        /**
         * A string value indicating the communication type. At the moment the type value can assume one of 3 values at the moment chat, web and call.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.CommunicationTypeOptions) : this() {
            this.datesWithoutSupport = x.datesWithoutSupport
            this.supportedHours = x.supportedHours
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.CommunicationTypeOptions = CommunicationTypeOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
