// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.paginators

import aws.sdk.kotlin.services.support.SupportClient
import aws.sdk.kotlin.services.support.model.CaseDetails
import aws.sdk.kotlin.services.support.model.Communication
import aws.sdk.kotlin.services.support.model.DescribeCasesRequest
import aws.sdk.kotlin.services.support.model.DescribeCasesResponse
import aws.sdk.kotlin.services.support.model.DescribeCommunicationsRequest
import aws.sdk.kotlin.services.support.model.DescribeCommunicationsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCasesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCasesResponse]
 */
public fun SupportClient.describeCasesPaginated(initialRequest: DescribeCasesRequest = DescribeCasesRequest { }): Flow<DescribeCasesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeCasesPaginated.describeCases(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCasesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCasesResponse]
 */
public fun SupportClient.describeCasesPaginated(block: DescribeCasesRequest.Builder.() -> Unit): Flow<DescribeCasesResponse> =
    describeCasesPaginated(DescribeCasesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCasesPaginated]
 * to access the nested member [CaseDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CaseDetails]
 */
@JvmName("describeCasesResponseCaseDetails")
public fun Flow<DescribeCasesResponse>.cases(): Flow<CaseDetails> =
    transform() { response ->
        response.cases?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeCommunicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeCommunicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCommunicationsResponse]
 */
public fun SupportClient.describeCommunicationsPaginated(initialRequest: DescribeCommunicationsRequest): Flow<DescribeCommunicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeCommunicationsPaginated.describeCommunications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeCommunicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeCommunicationsResponse]
 */
public fun SupportClient.describeCommunicationsPaginated(block: DescribeCommunicationsRequest.Builder.() -> Unit): Flow<DescribeCommunicationsResponse> =
    describeCommunicationsPaginated(DescribeCommunicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeCommunicationsPaginated]
 * to access the nested member [Communication]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Communication]
 */
@JvmName("describeCommunicationsResponseCommunication")
public fun Flow<DescribeCommunicationsResponse>.communications(): Flow<Communication> =
    transform() { response ->
        response.communications?.forEach {
            emit(it)
        }
    }
