// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * The results of a Trusted Advisor check returned by DescribeTrustedAdvisorCheckResult.
 */
public class TrustedAdvisorCheckResult private constructor(builder: Builder) {
    /**
     * Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.
     */
    public val categorySpecificSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary? = builder.categorySpecificSummary
    /**
     * The unique identifier for the Trusted Advisor check.
     */
    public val checkId: kotlin.String = requireNotNull(builder.checkId) { "A non-null value must be provided for checkId" }
    /**
     * The details about each resource listed in the check result.
     */
    public val flaggedResources: List<TrustedAdvisorResourceDetail> = requireNotNull(builder.flaggedResources) { "A non-null value must be provided for flaggedResources" }
    /**
     * Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
     */
    public val resourcesSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary? = builder.resourcesSummary
    /**
     * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
     */
    public val status: kotlin.String = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The time of the last refresh of the check.
     */
    public val timestamp: kotlin.String = requireNotNull(builder.timestamp) { "A non-null value must be provided for timestamp" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustedAdvisorCheckResult(")
        append("categorySpecificSummary=$categorySpecificSummary,")
        append("checkId=$checkId,")
        append("flaggedResources=$flaggedResources,")
        append("resourcesSummary=$resourcesSummary,")
        append("status=$status,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = categorySpecificSummary?.hashCode() ?: 0
        result = 31 * result + (checkId.hashCode())
        result = 31 * result + (flaggedResources.hashCode())
        result = 31 * result + (resourcesSummary?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (timestamp.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustedAdvisorCheckResult

        if (categorySpecificSummary != other.categorySpecificSummary) return false
        if (checkId != other.checkId) return false
        if (flaggedResources != other.flaggedResources) return false
        if (resourcesSummary != other.resourcesSummary) return false
        if (status != other.status) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Summary information that relates to the category of the check. Cost Optimizing is the only category that is currently supported.
         */
        public var categorySpecificSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary? = null
        /**
         * The unique identifier for the Trusted Advisor check.
         */
        public var checkId: kotlin.String? = null
        /**
         * The details about each resource listed in the check result.
         */
        public var flaggedResources: List<TrustedAdvisorResourceDetail>? = null
        /**
         * Details about Amazon Web Services resources that were analyzed in a call to Trusted Advisor DescribeTrustedAdvisorCheckSummaries.
         */
        public var resourcesSummary: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary? = null
        /**
         * The alert status of the check: "ok" (green), "warning" (yellow), "error" (red), or "not_available".
         */
        public var status: kotlin.String? = null
        /**
         * The time of the last refresh of the check.
         */
        public var timestamp: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckResult) : this() {
            this.categorySpecificSummary = x.categorySpecificSummary
            this.checkId = x.checkId
            this.flaggedResources = x.flaggedResources
            this.resourcesSummary = x.resourcesSummary
            this.status = x.status
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckResult = TrustedAdvisorCheckResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary] inside the given [block]
         */
        public fun categorySpecificSummary(block: aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary.Builder.() -> kotlin.Unit) {
            this.categorySpecificSummary = aws.sdk.kotlin.services.support.model.TrustedAdvisorCategorySpecificSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary] inside the given [block]
         */
        public fun resourcesSummary(block: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary.Builder.() -> kotlin.Unit) {
            this.resourcesSummary = aws.sdk.kotlin.services.support.model.TrustedAdvisorResourcesSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (checkId == null) checkId = ""
            if (flaggedResources == null) flaggedResources = emptyList()
            if (status == null) status = ""
            if (timestamp == null) timestamp = ""
            return this
        }
    }
}
