// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * A JSON-formatted object that contains the metadata for a support case. It is contained in the response from a DescribeCases request. **CaseDetails** contains the following fields:
 * + **caseId** - The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-*12345678910-2013-c4c1d2bf33c5cf47*.
 * + **categoryCode** - The category of problem for the support case. Corresponds to the `CategoryCode` values returned by a call to DescribeServices.
 * + **displayId** - The identifier for the case on pages in the Amazon Web Services Support Center.
 * + **language** - The language in which Amazon Web Services Support handles the case. Amazon Web Services Support currently supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO 639-1 code for the `language` parameter if you want support in that language.
 * + **nextToken** - A resumption point for pagination.
 * + **recentCommunications** - One or more Communication objects. Fields of these objects are `attachments`, `body`, `caseId`, `submittedBy`, and `timeCreated`.
 * + **serviceCode** - The identifier for the Amazon Web Services service that corresponds to the service code defined in the call to DescribeServices.
 * + **severityCode** - The severity code assigned to the case. Contains one of the values returned by the call to DescribeSeverityLevels. The possible values are: `low`, `normal`, `high`, `urgent`, and `critical`.
 * + **status** - The status of the case in the Amazon Web Services Support Center. Valid values:
 *    + `opened`
 *    + `pending-customer-action`
 *    + `reopened`
 *    + `resolved`
 *    + `unassigned`
 *    + `work-in-progress`
 * + **subject** - The subject line of the case.
 * + **submittedBy** - The email address of the account that submitted the case.
 * + **timeCreated** - The time the case was created, in ISO-8601 format.
 */
public class CaseDetails private constructor(builder: Builder) {
    /**
     * The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-*12345678910-2013-c4c1d2bf33c5cf47*
     */
    public val caseId: kotlin.String? = builder.caseId
    /**
     * The category of problem for the support case.
     */
    public val categoryCode: kotlin.String? = builder.categoryCode
    /**
     * The email addresses that receive copies of communication about the case.
     */
    public val ccEmailAddresses: List<String>? = builder.ccEmailAddresses
    /**
     * The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.
     */
    public val displayId: kotlin.String? = builder.displayId
    /**
     * The language in which Amazon Web Services Support handles the case. Amazon Web Services Support currently supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO 639-1 code for the `language` parameter if you want support in that language.
     */
    public val language: kotlin.String? = builder.language
    /**
     * The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a `nextToken` that you can use to retrieve earlier communications.
     */
    public val recentCommunications: aws.sdk.kotlin.services.support.model.RecentCaseCommunications? = builder.recentCommunications
    /**
     * The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling DescribeServices.
     */
    public val serviceCode: kotlin.String? = builder.serviceCode
    /**
     * The code for the severity level returned by the call to DescribeSeverityLevels.
     */
    public val severityCode: kotlin.String? = builder.severityCode
    /**
     * The status of the case.
     *
     * Valid values:
     * + `opened`
     * + `pending-customer-action`
     * + `reopened`
     * + `resolved`
     * + `unassigned`
     * + `work-in-progress`
     */
    public val status: kotlin.String? = builder.status
    /**
     * The subject line for the case in the Amazon Web Services Support Center.
     */
    public val subject: kotlin.String? = builder.subject
    /**
     * The email address of the account that submitted the case.
     */
    public val submittedBy: kotlin.String? = builder.submittedBy
    /**
     * The time that the case was created in the Amazon Web Services Support Center.
     */
    public val timeCreated: kotlin.String? = builder.timeCreated

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.CaseDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CaseDetails(")
        append("caseId=$caseId,")
        append("categoryCode=$categoryCode,")
        append("ccEmailAddresses=$ccEmailAddresses,")
        append("displayId=$displayId,")
        append("language=$language,")
        append("recentCommunications=$recentCommunications,")
        append("serviceCode=$serviceCode,")
        append("severityCode=$severityCode,")
        append("status=$status,")
        append("subject=$subject,")
        append("submittedBy=$submittedBy,")
        append("timeCreated=$timeCreated")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = caseId?.hashCode() ?: 0
        result = 31 * result + (categoryCode?.hashCode() ?: 0)
        result = 31 * result + (ccEmailAddresses?.hashCode() ?: 0)
        result = 31 * result + (displayId?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (recentCommunications?.hashCode() ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        result = 31 * result + (severityCode?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (submittedBy?.hashCode() ?: 0)
        result = 31 * result + (timeCreated?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CaseDetails

        if (caseId != other.caseId) return false
        if (categoryCode != other.categoryCode) return false
        if (ccEmailAddresses != other.ccEmailAddresses) return false
        if (displayId != other.displayId) return false
        if (language != other.language) return false
        if (recentCommunications != other.recentCommunications) return false
        if (serviceCode != other.serviceCode) return false
        if (severityCode != other.severityCode) return false
        if (status != other.status) return false
        if (subject != other.subject) return false
        if (submittedBy != other.submittedBy) return false
        if (timeCreated != other.timeCreated) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.CaseDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-*12345678910-2013-c4c1d2bf33c5cf47*
         */
        public var caseId: kotlin.String? = null
        /**
         * The category of problem for the support case.
         */
        public var categoryCode: kotlin.String? = null
        /**
         * The email addresses that receive copies of communication about the case.
         */
        public var ccEmailAddresses: List<String>? = null
        /**
         * The ID displayed for the case in the Amazon Web Services Support Center. This is a numeric string.
         */
        public var displayId: kotlin.String? = null
        /**
         * The language in which Amazon Web Services Support handles the case. Amazon Web Services Support currently supports Chinese (“zh”), English ("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO 639-1 code for the `language` parameter if you want support in that language.
         */
        public var language: kotlin.String? = null
        /**
         * The five most recent communications between you and Amazon Web Services Support Center, including the IDs of any attachments to the communications. Also includes a `nextToken` that you can use to retrieve earlier communications.
         */
        public var recentCommunications: aws.sdk.kotlin.services.support.model.RecentCaseCommunications? = null
        /**
         * The code for the Amazon Web Services service. You can get a list of codes and the corresponding service names by calling DescribeServices.
         */
        public var serviceCode: kotlin.String? = null
        /**
         * The code for the severity level returned by the call to DescribeSeverityLevels.
         */
        public var severityCode: kotlin.String? = null
        /**
         * The status of the case.
         *
         * Valid values:
         * + `opened`
         * + `pending-customer-action`
         * + `reopened`
         * + `resolved`
         * + `unassigned`
         * + `work-in-progress`
         */
        public var status: kotlin.String? = null
        /**
         * The subject line for the case in the Amazon Web Services Support Center.
         */
        public var subject: kotlin.String? = null
        /**
         * The email address of the account that submitted the case.
         */
        public var submittedBy: kotlin.String? = null
        /**
         * The time that the case was created in the Amazon Web Services Support Center.
         */
        public var timeCreated: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.CaseDetails) : this() {
            this.caseId = x.caseId
            this.categoryCode = x.categoryCode
            this.ccEmailAddresses = x.ccEmailAddresses
            this.displayId = x.displayId
            this.language = x.language
            this.recentCommunications = x.recentCommunications
            this.serviceCode = x.serviceCode
            this.severityCode = x.severityCode
            this.status = x.status
            this.subject = x.subject
            this.submittedBy = x.submittedBy
            this.timeCreated = x.timeCreated
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.CaseDetails = CaseDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.support.model.RecentCaseCommunications] inside the given [block]
         */
        public fun recentCommunications(block: aws.sdk.kotlin.services.support.model.RecentCaseCommunications.Builder.() -> kotlin.Unit) {
            this.recentCommunications = aws.sdk.kotlin.services.support.model.RecentCaseCommunications.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
