// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.support.auth.DefaultSupportAuthSchemeProvider
import aws.sdk.kotlin.services.support.auth.SupportAuthSchemeProvider
import aws.sdk.kotlin.services.support.endpoints.DefaultSupportEndpointProvider
import aws.sdk.kotlin.services.support.endpoints.SupportEndpointParameters
import aws.sdk.kotlin.services.support.endpoints.SupportEndpointProvider
import aws.sdk.kotlin.services.support.model.AddAttachmentsToSetRequest
import aws.sdk.kotlin.services.support.model.AddAttachmentsToSetResponse
import aws.sdk.kotlin.services.support.model.AddCommunicationToCaseRequest
import aws.sdk.kotlin.services.support.model.AddCommunicationToCaseResponse
import aws.sdk.kotlin.services.support.model.CreateCaseRequest
import aws.sdk.kotlin.services.support.model.CreateCaseResponse
import aws.sdk.kotlin.services.support.model.DescribeAttachmentRequest
import aws.sdk.kotlin.services.support.model.DescribeAttachmentResponse
import aws.sdk.kotlin.services.support.model.DescribeCasesRequest
import aws.sdk.kotlin.services.support.model.DescribeCasesResponse
import aws.sdk.kotlin.services.support.model.DescribeCommunicationsRequest
import aws.sdk.kotlin.services.support.model.DescribeCommunicationsResponse
import aws.sdk.kotlin.services.support.model.DescribeCreateCaseOptionsRequest
import aws.sdk.kotlin.services.support.model.DescribeCreateCaseOptionsResponse
import aws.sdk.kotlin.services.support.model.DescribeServicesRequest
import aws.sdk.kotlin.services.support.model.DescribeServicesResponse
import aws.sdk.kotlin.services.support.model.DescribeSeverityLevelsRequest
import aws.sdk.kotlin.services.support.model.DescribeSeverityLevelsResponse
import aws.sdk.kotlin.services.support.model.DescribeSupportedLanguagesRequest
import aws.sdk.kotlin.services.support.model.DescribeSupportedLanguagesResponse
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesRequest
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorCheckRefreshStatusesResponse
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorCheckResultRequest
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorCheckResultResponse
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorCheckSummariesRequest
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorCheckSummariesResponse
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorChecksRequest
import aws.sdk.kotlin.services.support.model.DescribeTrustedAdvisorChecksResponse
import aws.sdk.kotlin.services.support.model.RefreshTrustedAdvisorCheckRequest
import aws.sdk.kotlin.services.support.model.RefreshTrustedAdvisorCheckResponse
import aws.sdk.kotlin.services.support.model.ResolveCaseRequest
import aws.sdk.kotlin.services.support.model.ResolveCaseResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Support"
public const val SdkVersion: String = "1.1.16"
public const val ServiceApiVersion: String = "2013-04-15"

/**
 * # Amazon Web Services Support
 * The *Amazon Web Services Support API Reference* is intended for programmers who need detailed information about the Amazon Web Services Support operations and data types. You can use the API to manage your support cases programmatically. The Amazon Web Services Support API uses HTTP methods that return results in JSON format.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 * You can also use the Amazon Web Services Support API to access features for [Trusted Advisor](http://aws.amazon.com/premiumsupport/trustedadvisor/). You can return a list of checks and their descriptions, get check results, specify checks to refresh, and get the refresh status of checks.
 *
 * You can manage your support cases with the following Amazon Web Services Support API operations:
 * + The CreateCase, DescribeCases, DescribeAttachment, and ResolveCase operations create Amazon Web Services Support cases, retrieve information about cases, and resolve cases.
 * + The DescribeCommunications, AddCommunicationToCase, and AddAttachmentsToSet operations retrieve and add communications and attachments to Amazon Web Services Support cases.
 * + The DescribeServices and DescribeSeverityLevels operations return Amazon Web Service names, service codes, service categories, and problem severity levels. You use these values when you call the CreateCase operation.
 *
 * You can also use the Amazon Web Services Support API to call the Trusted Advisor operations. For more information, see [Trusted Advisor](https://docs.aws.amazon.com/) in the *Amazon Web Services Support User Guide*.
 *
 * For authentication of requests, Amazon Web Services Support uses [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
 *
 * For more information about this service and the endpoints to use, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html) in the *Amazon Web Services Support User Guide*.
 */
public interface SupportClient : SdkClient {
    /**
     * SupportClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SupportClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Support",
                "SUPPORT",
                "support",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SupportClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SupportClient = DefaultSupportClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SupportEndpointProvider = builder.endpointProvider ?: DefaultSupportEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SupportAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSupportAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Support"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SupportEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SupportAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Adds one or more attachments to an attachment set.
     *
     * An attachment set is a temporary container for attachments that you add to a case or case communication. The set is available for 1 hour after it's created. The `expiryTime` returned in the response is when the set expires.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun addAttachmentsToSet(input: AddAttachmentsToSetRequest): AddAttachmentsToSetResponse

    /**
     * Adds additional customer communication to an Amazon Web Services Support case. Use the `caseId` parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the `ccEmailAddresses` parameter. The `communicationBody` value contains the text of the communication.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun addCommunicationToCase(input: AddCommunicationToCaseRequest): AddCommunicationToCaseResponse

    /**
     * Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
     *
     * The Amazon Web Services Support API doesn't support requesting service limit increases. You can submit a service limit increase in the following ways:
     * + Submit a request from the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
     * + Use the Service Quotas [RequestServiceQuotaIncrease](https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html) operation.
     *
     * A successful `CreateCase` request returns an Amazon Web Services Support case number. You can use the DescribeCases operation and specify the case number to get existing Amazon Web Services Support cases. After you create a case, use the AddCommunicationToCase operation to add additional communication or attachments to an existing case.
     *
     * The `caseId` is separate from the `displayId` that appears in the [Amazon Web Services Support Center](https://console.aws.amazon.com/support). Use the DescribeCases operation to get the `displayId`.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun createCase(input: CreateCaseRequest): CreateCaseResponse

    /**
     * Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the AttachmentDetails objects that are returned by the DescribeCommunications operation.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeAttachment(input: DescribeAttachmentRequest): DescribeAttachmentResponse

    /**
     * Returns a list of cases that you specify by passing one or more case IDs. You can use the `afterTime` and `beforeTime` parameters to filter the cases by date. You can set values for the `includeResolvedCases` and `includeCommunications` parameters to specify how much information to return.
     *
     * The response returns the following in JSON format:
     * + One or more [CaseDetails](https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html) data types.
     * + One or more `nextToken` values, which specify where to paginate the returned records represented by the `CaseDetails` objects.
     *
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request might return an error.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeCases(input: DescribeCasesRequest = DescribeCasesRequest { }): DescribeCasesResponse

    /**
     * Returns communications and attachments for one or more support cases. Use the `afterTime` and `beforeTime` parameters to filter by date. You can use the `caseId` parameter to restrict the results to a specific case.
     *
     * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error.
     *
     * You can use the `maxResults` and `nextToken` parameters to control the pagination of the results. Set `maxResults` to the number of cases that you want to display on each page, and use `nextToken` to specify the resumption of pagination.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeCommunications(input: DescribeCommunicationsRequest): DescribeCommunicationsResponse

    /**
     * Returns a list of CreateCaseOption types along with the corresponding supported hours and language availability. You can specify the `language``categoryCode`, `issueType` and `serviceCode` used to retrieve the CreateCaseOptions.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeCreateCaseOptions(input: DescribeCreateCaseOptionsRequest): DescribeCreateCaseOptionsResponse

    /**
     * Returns the current list of Amazon Web Services services and a list of service categories for each service. You then use service names and categories in your CreateCase requests. Each Amazon Web Services service has its own set of categories.
     *
     * The service codes and category codes correspond to the values that appear in the **Service** and **Category** lists on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page. The values in those fields don't necessarily match the service codes and categories returned by the `DescribeServices` operation. Always use the service codes and categories that the `DescribeServices` operation returns, so that you have the most recent set of service and category codes.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeServices(input: DescribeServicesRequest = DescribeServicesRequest { }): DescribeServicesResponse

    /**
     * Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the CaseDetails data type that you include for a CreateCase request.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeSeverityLevels(input: DescribeSeverityLevelsRequest = DescribeSeverityLevelsRequest { }): DescribeSeverityLevelsResponse

    /**
     * Returns a list of supported languages for a specified `categoryCode`, `issueType` and `serviceCode`. The returned supported languages will include a ISO 639-1 code for the `language`, and the language display name.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun describeSupportedLanguages(input: DescribeSupportedLanguagesRequest): DescribeSupportedLanguagesResponse

    /**
     * Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * Some checks are refreshed automatically, and you can't return their refresh statuses by using the `DescribeTrustedAdvisorCheckRefreshStatuses` operation. If you call this operation for these checks, you might see an `InvalidParameterValue` error.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
     */
    public suspend fun describeTrustedAdvisorCheckRefreshStatuses(input: DescribeTrustedAdvisorCheckRefreshStatusesRequest): DescribeTrustedAdvisorCheckRefreshStatusesResponse

    /**
     * Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * The response contains a TrustedAdvisorCheckResult object, which contains these three objects:
     * + TrustedAdvisorCategorySpecificSummary
     * + TrustedAdvisorResourceDetail
     * + TrustedAdvisorResourcesSummary
     *
     * In addition, the response contains these fields:
     * + **status** - The alert status of the check can be `ok` (green), `warning` (yellow), `error` (red), or `not_available`.
     * + **timestamp** - The time of the last refresh of the check.
     * + **checkId** - The unique identifier for the check.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
     */
    public suspend fun describeTrustedAdvisorCheckResult(input: DescribeTrustedAdvisorCheckResultRequest): DescribeTrustedAdvisorCheckResultResponse

    /**
     * Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * The response contains an array of TrustedAdvisorCheckSummary objects.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
     */
    public suspend fun describeTrustedAdvisorCheckSummaries(input: DescribeTrustedAdvisorCheckSummariesRequest): DescribeTrustedAdvisorCheckSummariesResponse

    /**
     * Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code.
     *
     * The response contains a TrustedAdvisorCheckDescription object for each check. You must set the Amazon Web Services Region to us-east-1.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     * + The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the check ID in your code to uniquely identify a check.
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
     */
    public suspend fun describeTrustedAdvisorChecks(input: DescribeTrustedAdvisorChecksRequest): DescribeTrustedAdvisorChecksResponse

    /**
     * Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
     *
     * Some checks are refreshed automatically. If you call the `RefreshTrustedAdvisorCheck` operation to refresh them, you might see the `InvalidParameterValue` error.
     *
     * The response contains a TrustedAdvisorCheckRefreshStatus object.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
     */
    public suspend fun refreshTrustedAdvisorCheck(input: RefreshTrustedAdvisorCheckRequest): RefreshTrustedAdvisorCheckResponse

    /**
     * Resolves a support case. This operation takes a `caseId` and returns the initial and final state of the case.
     *
     * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
     * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
     */
    public suspend fun resolveCase(input: ResolveCaseRequest = ResolveCaseRequest { }): ResolveCaseResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SupportClient.withConfig(block: SupportClient.Config.Builder.() -> Unit): SupportClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSupportClient(newConfig)
}

/**
 * Adds one or more attachments to an attachment set.
 *
 * An attachment set is a temporary container for attachments that you add to a case or case communication. The set is available for 1 hour after it's created. The `expiryTime` returned in the response is when the set expires.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.addAttachmentsToSet(crossinline block: AddAttachmentsToSetRequest.Builder.() -> Unit): AddAttachmentsToSetResponse = addAttachmentsToSet(AddAttachmentsToSetRequest.Builder().apply(block).build())

/**
 * Adds additional customer communication to an Amazon Web Services Support case. Use the `caseId` parameter to identify the case to which to add communication. You can list a set of email addresses to copy on the communication by using the `ccEmailAddresses` parameter. The `communicationBody` value contains the text of the communication.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.addCommunicationToCase(crossinline block: AddCommunicationToCaseRequest.Builder.() -> Unit): AddCommunicationToCaseResponse = addCommunicationToCase(AddCommunicationToCaseRequest.Builder().apply(block).build())

/**
 * Creates a case in the Amazon Web Services Support Center. This operation is similar to how you create a case in the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
 *
 * The Amazon Web Services Support API doesn't support requesting service limit increases. You can submit a service limit increase in the following ways:
 * + Submit a request from the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
 * + Use the Service Quotas [RequestServiceQuotaIncrease](https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_RequestServiceQuotaIncrease.html) operation.
 *
 * A successful `CreateCase` request returns an Amazon Web Services Support case number. You can use the DescribeCases operation and specify the case number to get existing Amazon Web Services Support cases. After you create a case, use the AddCommunicationToCase operation to add additional communication or attachments to an existing case.
 *
 * The `caseId` is separate from the `displayId` that appears in the [Amazon Web Services Support Center](https://console.aws.amazon.com/support). Use the DescribeCases operation to get the `displayId`.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.createCase(crossinline block: CreateCaseRequest.Builder.() -> Unit): CreateCaseResponse = createCase(CreateCaseRequest.Builder().apply(block).build())

/**
 * Returns the attachment that has the specified ID. Attachments can include screenshots, error logs, or other files that describe your issue. Attachment IDs are generated by the case management system when you add an attachment to a case or case communication. Attachment IDs are returned in the AttachmentDetails objects that are returned by the DescribeCommunications operation.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeAttachment(crossinline block: DescribeAttachmentRequest.Builder.() -> Unit): DescribeAttachmentResponse = describeAttachment(DescribeAttachmentRequest.Builder().apply(block).build())

/**
 * Returns a list of cases that you specify by passing one or more case IDs. You can use the `afterTime` and `beforeTime` parameters to filter the cases by date. You can set values for the `includeResolvedCases` and `includeCommunications` parameters to specify how much information to return.
 *
 * The response returns the following in JSON format:
 * + One or more [CaseDetails](https://docs.aws.amazon.com/awssupport/latest/APIReference/API_CaseDetails.html) data types.
 * + One or more `nextToken` values, which specify where to paginate the returned records represented by the `CaseDetails` objects.
 *
 * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request might return an error.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeCases(crossinline block: DescribeCasesRequest.Builder.() -> Unit): DescribeCasesResponse = describeCases(DescribeCasesRequest.Builder().apply(block).build())

/**
 * Returns communications and attachments for one or more support cases. Use the `afterTime` and `beforeTime` parameters to filter by date. You can use the `caseId` parameter to restrict the results to a specific case.
 *
 * Case data is available for 12 months after creation. If a case was created more than 12 months ago, a request for data might cause an error.
 *
 * You can use the `maxResults` and `nextToken` parameters to control the pagination of the results. Set `maxResults` to the number of cases that you want to display on each page, and use `nextToken` to specify the resumption of pagination.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeCommunications(crossinline block: DescribeCommunicationsRequest.Builder.() -> Unit): DescribeCommunicationsResponse = describeCommunications(DescribeCommunicationsRequest.Builder().apply(block).build())

/**
 * Returns a list of CreateCaseOption types along with the corresponding supported hours and language availability. You can specify the `language``categoryCode`, `issueType` and `serviceCode` used to retrieve the CreateCaseOptions.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeCreateCaseOptions(crossinline block: DescribeCreateCaseOptionsRequest.Builder.() -> Unit): DescribeCreateCaseOptionsResponse = describeCreateCaseOptions(DescribeCreateCaseOptionsRequest.Builder().apply(block).build())

/**
 * Returns the current list of Amazon Web Services services and a list of service categories for each service. You then use service names and categories in your CreateCase requests. Each Amazon Web Services service has its own set of categories.
 *
 * The service codes and category codes correspond to the values that appear in the **Service** and **Category** lists on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page. The values in those fields don't necessarily match the service codes and categories returned by the `DescribeServices` operation. Always use the service codes and categories that the `DescribeServices` operation returns, so that you have the most recent set of service and category codes.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeServices(crossinline block: DescribeServicesRequest.Builder.() -> Unit): DescribeServicesResponse = describeServices(DescribeServicesRequest.Builder().apply(block).build())

/**
 * Returns the list of severity levels that you can assign to a support case. The severity level for a case is also a field in the CaseDetails data type that you include for a CreateCase request.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeSeverityLevels(crossinline block: DescribeSeverityLevelsRequest.Builder.() -> Unit): DescribeSeverityLevelsResponse = describeSeverityLevels(DescribeSeverityLevelsRequest.Builder().apply(block).build())

/**
 * Returns a list of supported languages for a specified `categoryCode`, `issueType` and `serviceCode`. The returned supported languages will include a ISO 639-1 code for the `language`, and the language display name.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.describeSupportedLanguages(crossinline block: DescribeSupportedLanguagesRequest.Builder.() -> Unit): DescribeSupportedLanguagesResponse = describeSupportedLanguages(DescribeSupportedLanguagesRequest.Builder().apply(block).build())

/**
 * Returns the refresh status of the Trusted Advisor checks that have the specified check IDs. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
 *
 * Some checks are refreshed automatically, and you can't return their refresh statuses by using the `DescribeTrustedAdvisorCheckRefreshStatuses` operation. If you call this operation for these checks, you might see an `InvalidParameterValue` error.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
 */
public suspend inline fun SupportClient.describeTrustedAdvisorCheckRefreshStatuses(crossinline block: DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder.() -> Unit): DescribeTrustedAdvisorCheckRefreshStatusesResponse = describeTrustedAdvisorCheckRefreshStatuses(DescribeTrustedAdvisorCheckRefreshStatusesRequest.Builder().apply(block).build())

/**
 * Returns the results of the Trusted Advisor check that has the specified check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
 *
 * The response contains a TrustedAdvisorCheckResult object, which contains these three objects:
 * + TrustedAdvisorCategorySpecificSummary
 * + TrustedAdvisorResourceDetail
 * + TrustedAdvisorResourcesSummary
 *
 * In addition, the response contains these fields:
 * + **status** - The alert status of the check can be `ok` (green), `warning` (yellow), `error` (red), or `not_available`.
 * + **timestamp** - The time of the last refresh of the check.
 * + **checkId** - The unique identifier for the check.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
 */
public suspend inline fun SupportClient.describeTrustedAdvisorCheckResult(crossinline block: DescribeTrustedAdvisorCheckResultRequest.Builder.() -> Unit): DescribeTrustedAdvisorCheckResultResponse = describeTrustedAdvisorCheckResult(DescribeTrustedAdvisorCheckResultRequest.Builder().apply(block).build())

/**
 * Returns the results for the Trusted Advisor check summaries for the check IDs that you specified. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
 *
 * The response contains an array of TrustedAdvisorCheckSummary objects.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
 */
public suspend inline fun SupportClient.describeTrustedAdvisorCheckSummaries(crossinline block: DescribeTrustedAdvisorCheckSummariesRequest.Builder.() -> Unit): DescribeTrustedAdvisorCheckSummariesResponse = describeTrustedAdvisorCheckSummaries(DescribeTrustedAdvisorCheckSummariesRequest.Builder().apply(block).build())

/**
 * Returns information about all available Trusted Advisor checks, including the name, ID, category, description, and metadata. You must specify a language code.
 *
 * The response contains a TrustedAdvisorCheckDescription object for each check. You must set the Amazon Web Services Region to us-east-1.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 * + The names and descriptions for Trusted Advisor checks are subject to change. We recommend that you specify the check ID in your code to uniquely identify a check.
 * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
 */
public suspend inline fun SupportClient.describeTrustedAdvisorChecks(crossinline block: DescribeTrustedAdvisorChecksRequest.Builder.() -> Unit): DescribeTrustedAdvisorChecksResponse = describeTrustedAdvisorChecks(DescribeTrustedAdvisorChecksRequest.Builder().apply(block).build())

/**
 * Refreshes the Trusted Advisor check that you specify using the check ID. You can get the check IDs by calling the DescribeTrustedAdvisorChecks operation.
 *
 * Some checks are refreshed automatically. If you call the `RefreshTrustedAdvisorCheck` operation to refresh them, you might see the `InvalidParameterValue` error.
 *
 * The response contains a TrustedAdvisorCheckRefreshStatus object.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 * To call the Trusted Advisor operations in the Amazon Web Services Support API, you must use the US East (N. Virginia) endpoint. Currently, the US West (Oregon) and Europe (Ireland) endpoints don't support the Trusted Advisor operations. For more information, see [About the Amazon Web Services Support API](https://docs.aws.amazon.com/awssupport/latest/user/about-support-api.html#endpoint) in the *Amazon Web Services Support User Guide*.
 */
public suspend inline fun SupportClient.refreshTrustedAdvisorCheck(crossinline block: RefreshTrustedAdvisorCheckRequest.Builder.() -> Unit): RefreshTrustedAdvisorCheckResponse = refreshTrustedAdvisorCheck(RefreshTrustedAdvisorCheckRequest.Builder().apply(block).build())

/**
 * Resolves a support case. This operation takes a `caseId` and returns the initial and final state of the case.
 *
 * + You must have a Business, Enterprise On-Ramp, or Enterprise Support plan to use the Amazon Web Services Support API.
 * + If you call the Amazon Web Services Support API from an account that doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan, the `SubscriptionRequiredException` error message appears. For information about changing your support plan, see [Amazon Web Services Support](http://aws.amazon.com/premiumsupport/).
 */
public suspend inline fun SupportClient.resolveCase(crossinline block: ResolveCaseRequest.Builder.() -> Unit): ResolveCaseResponse = resolveCase(ResolveCaseRequest.Builder().apply(block).build())
