// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.transform

import aws.sdk.kotlin.services.support.model.AddCommunicationToCaseResponse
import aws.sdk.kotlin.services.support.model.SupportException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AddCommunicationToCaseOperationDeserializer: HttpDeserialize<AddCommunicationToCaseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AddCommunicationToCaseResponse {
        if (!response.status.isSuccess()) {
            throwAddCommunicationToCaseError(context, response)
        }
        val builder = AddCommunicationToCaseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAddCommunicationToCaseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAddCommunicationToCaseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SupportException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AttachmentSetExpired" -> AttachmentSetExpiredDeserializer().deserialize(context, wrappedResponse)
        "AttachmentSetIdNotFound" -> AttachmentSetIdNotFoundDeserializer().deserialize(context, wrappedResponse)
        "CaseIdNotFound" -> CaseIdNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SupportException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddCommunicationToCaseOperationBody(builder: AddCommunicationToCaseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("result"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULT_DESCRIPTOR.index -> builder.result = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
