// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * A communication associated with a support case. The communication consists of the case ID, the message body, attachment information, the submitter of the communication, and the date and time of the communication.
 */
public class Communication private constructor(builder: Builder) {
    /**
     * Information about the attachments to the case communication.
     */
    public val attachmentSet: List<AttachmentDetails>? = builder.attachmentSet
    /**
     * The text of the communication between the customer and Amazon Web Services Support.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-*12345678910-2013-c4c1d2bf33c5cf47*
     */
    public val caseId: kotlin.String? = builder.caseId
    /**
     * The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) <janedoe@example.com>. Entries from the Amazon Web Services Support team display "Amazon Web Services," and don't show an email address.
     */
    public val submittedBy: kotlin.String? = builder.submittedBy
    /**
     * The time the communication was created.
     */
    public val timeCreated: kotlin.String? = builder.timeCreated

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.Communication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Communication(")
        append("attachmentSet=$attachmentSet,")
        append("body=$body,")
        append("caseId=$caseId,")
        append("submittedBy=$submittedBy,")
        append("timeCreated=$timeCreated")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentSet?.hashCode() ?: 0
        result = 31 * result + (body?.hashCode() ?: 0)
        result = 31 * result + (caseId?.hashCode() ?: 0)
        result = 31 * result + (submittedBy?.hashCode() ?: 0)
        result = 31 * result + (timeCreated?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Communication

        if (attachmentSet != other.attachmentSet) return false
        if (body != other.body) return false
        if (caseId != other.caseId) return false
        if (submittedBy != other.submittedBy) return false
        if (timeCreated != other.timeCreated) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.Communication = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the attachments to the case communication.
         */
        public var attachmentSet: List<AttachmentDetails>? = null
        /**
         * The text of the communication between the customer and Amazon Web Services Support.
         */
        public var body: kotlin.String? = null
        /**
         * The support case ID requested or returned in the call. The case ID is an alphanumeric string formatted as shown in this example: case-*12345678910-2013-c4c1d2bf33c5cf47*
         */
        public var caseId: kotlin.String? = null
        /**
         * The identity of the account that submitted, or responded to, the support case. Customer entries include the role or IAM user as well as the email address. For example, "AdminRole (Role) <janedoe@example.com>. Entries from the Amazon Web Services Support team display "Amazon Web Services," and don't show an email address.
         */
        public var submittedBy: kotlin.String? = null
        /**
         * The time the communication was created.
         */
        public var timeCreated: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.Communication) : this() {
            this.attachmentSet = x.attachmentSet
            this.body = x.body
            this.caseId = x.caseId
            this.submittedBy = x.submittedBy
            this.timeCreated = x.timeCreated
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.Communication = Communication(this)
    }
}
