// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.support.model.Communication
import aws.sdk.kotlin.services.support.model.DescribeCommunicationsResponse
import aws.sdk.kotlin.services.support.model.SupportException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeCommunicationsOperationDeserializer: HttpDeserialize<DescribeCommunicationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeCommunicationsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeCommunicationsError(context, response)
        }
        val builder = DescribeCommunicationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeCommunicationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeCommunicationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SupportException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CaseIdNotFound" -> CaseIdNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SupportException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeCommunicationsOperationBody(builder: DescribeCommunicationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMUNICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("communications"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMUNICATIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMUNICATIONS_DESCRIPTOR.index -> builder.communications =
                    deserializer.deserializeList(COMMUNICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Communication>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCommunicationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
