// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * Contains information about a resource identified by a Trusted Advisor check.
 */
public class TrustedAdvisorResourceDetail private constructor(builder: Builder) {
    /**
     * Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.
     */
    public val isSuppressed: kotlin.Boolean = builder.isSuppressed
    /**
     * Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the TrustedAdvisorCheckDescription object returned by the call to DescribeTrustedAdvisorChecks. **Metadata** contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.
     */
    public val metadata: List<String>? = builder.metadata
    /**
     * The Amazon Web Services Region in which the identified resource is located.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The unique identifier for the identified resource.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The status code for the resource identified in the Trusted Advisor check.
     */
    public val status: kotlin.String? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.TrustedAdvisorResourceDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustedAdvisorResourceDetail(")
        append("isSuppressed=$isSuppressed,")
        append("metadata=$metadata,")
        append("region=$region,")
        append("resourceId=$resourceId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = isSuppressed.hashCode()
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustedAdvisorResourceDetail

        if (isSuppressed != other.isSuppressed) return false
        if (metadata != other.metadata) return false
        if (region != other.region) return false
        if (resourceId != other.resourceId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.TrustedAdvisorResourceDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the Amazon Web Services resource was ignored by Trusted Advisor because it was marked as suppressed by the user.
         */
        public var isSuppressed: kotlin.Boolean = false
        /**
         * Additional information about the identified resource. The exact metadata and its order can be obtained by inspecting the TrustedAdvisorCheckDescription object returned by the call to DescribeTrustedAdvisorChecks. **Metadata** contains all the data that is shown in the Excel download, even in those cases where the UI shows just summary data.
         */
        public var metadata: List<String>? = null
        /**
         * The Amazon Web Services Region in which the identified resource is located.
         */
        public var region: kotlin.String? = null
        /**
         * The unique identifier for the identified resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The status code for the resource identified in the Trusted Advisor check.
         */
        public var status: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.TrustedAdvisorResourceDetail) : this() {
            this.isSuppressed = x.isSuppressed
            this.metadata = x.metadata
            this.region = x.region
            this.resourceId = x.resourceId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.TrustedAdvisorResourceDetail = TrustedAdvisorResourceDetail(this)
    }
}
