// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



public class CreateCaseRequest private constructor(builder: Builder) {
    /**
     * The ID of a set of one or more attachments for the case. Create the set by using the AddAttachmentsToSet operation.
     */
    public val attachmentSetId: kotlin.String? = builder.attachmentSetId
    /**
     * The category of problem for the support case. You also use the DescribeServices operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.
     */
    public val categoryCode: kotlin.String? = builder.categoryCode
    /**
     * A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the [Amazon Web Services SDKs](http://aws.amazon.com/tools/).
     */
    public val ccEmailAddresses: List<String>? = builder.ccEmailAddresses
    /**
     * The communication body text that describes the issue. This text appears in the **Description** field on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
     */
    public val communicationBody: kotlin.String? = builder.communicationBody
    /**
     * The type of issue for the case. You can specify `customer-service` or `technical`. If you don't specify a value, the default is `technical`.
     */
    public val issueType: kotlin.String? = builder.issueType
    /**
     * The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the `language` parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.
     */
    public val language: kotlin.String? = builder.language
    /**
     * The code for the Amazon Web Services service. You can use the DescribeServices operation to get the possible `serviceCode` values.
     */
    public val serviceCode: kotlin.String? = builder.serviceCode
    /**
     * A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the DescribeSeverityLevels operation to get the possible values for `severityCode`.
     *
     * For more information, see SeverityLevel and [Choosing a Severity](https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity) in the *Amazon Web Services Support User Guide*.
     *
     * The availability of severity levels depends on the support plan for the Amazon Web Services account.
     */
    public val severityCode: kotlin.String? = builder.severityCode
    /**
     * The title of the support case. The title appears in the **Subject** field on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
     */
    public val subject: kotlin.String? = builder.subject

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.CreateCaseRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCaseRequest(")
        append("attachmentSetId=$attachmentSetId,")
        append("categoryCode=$categoryCode,")
        append("ccEmailAddresses=$ccEmailAddresses,")
        append("communicationBody=$communicationBody,")
        append("issueType=$issueType,")
        append("language=$language,")
        append("serviceCode=$serviceCode,")
        append("severityCode=$severityCode,")
        append("subject=$subject)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentSetId?.hashCode() ?: 0
        result = 31 * result + (categoryCode?.hashCode() ?: 0)
        result = 31 * result + (ccEmailAddresses?.hashCode() ?: 0)
        result = 31 * result + (communicationBody?.hashCode() ?: 0)
        result = 31 * result + (issueType?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        result = 31 * result + (severityCode?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCaseRequest

        if (attachmentSetId != other.attachmentSetId) return false
        if (categoryCode != other.categoryCode) return false
        if (ccEmailAddresses != other.ccEmailAddresses) return false
        if (communicationBody != other.communicationBody) return false
        if (issueType != other.issueType) return false
        if (language != other.language) return false
        if (serviceCode != other.serviceCode) return false
        if (severityCode != other.severityCode) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.CreateCaseRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of a set of one or more attachments for the case. Create the set by using the AddAttachmentsToSet operation.
         */
        public var attachmentSetId: kotlin.String? = null
        /**
         * The category of problem for the support case. You also use the DescribeServices operation to get the category code for a service. Each Amazon Web Services service defines its own set of category codes.
         */
        public var categoryCode: kotlin.String? = null
        /**
         * A list of email addresses that Amazon Web Services Support copies on case correspondence. Amazon Web Services Support identifies the account that creates the case when you specify your Amazon Web Services credentials in an HTTP POST method or use the [Amazon Web Services SDKs](http://aws.amazon.com/tools/).
         */
        public var ccEmailAddresses: List<String>? = null
        /**
         * The communication body text that describes the issue. This text appears in the **Description** field on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
         */
        public var communicationBody: kotlin.String? = null
        /**
         * The type of issue for the case. You can specify `customer-service` or `technical`. If you don't specify a value, the default is `technical`.
         */
        public var issueType: kotlin.String? = null
        /**
         * The language in which Amazon Web Services Support handles the case. You must specify the ISO 639-1 code for the `language` parameter if you want support in that language. Currently, English ("en") and Japanese ("ja") are supported.
         */
        public var language: kotlin.String? = null
        /**
         * The code for the Amazon Web Services service. You can use the DescribeServices operation to get the possible `serviceCode` values.
         */
        public var serviceCode: kotlin.String? = null
        /**
         * A value that indicates the urgency of the case. This value determines the response time according to your service level agreement with Amazon Web Services Support. You can use the DescribeSeverityLevels operation to get the possible values for `severityCode`.
         *
         * For more information, see SeverityLevel and [Choosing a Severity](https://docs.aws.amazon.com/awssupport/latest/user/getting-started.html#choosing-severity) in the *Amazon Web Services Support User Guide*.
         *
         * The availability of severity levels depends on the support plan for the Amazon Web Services account.
         */
        public var severityCode: kotlin.String? = null
        /**
         * The title of the support case. The title appears in the **Subject** field on the Amazon Web Services Support Center [Create Case](https://console.aws.amazon.com/support/home#/case/create) page.
         */
        public var subject: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.CreateCaseRequest) : this() {
            this.attachmentSetId = x.attachmentSetId
            this.categoryCode = x.categoryCode
            this.ccEmailAddresses = x.ccEmailAddresses
            this.communicationBody = x.communicationBody
            this.issueType = x.issueType
            this.language = x.language
            this.serviceCode = x.serviceCode
            this.severityCode = x.severityCode
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.CreateCaseRequest = CreateCaseRequest(this)
    }
}
