// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sts.presigners

import aws.sdk.kotlin.services.sts.StsClient
import aws.sdk.kotlin.services.sts.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.sts.model.GetCallerIdentityRequest
import aws.sdk.kotlin.services.sts.serde.GetCallerIdentityOperationSerializer
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.HashSpecification
import aws.smithy.kotlin.runtime.auth.awssigning.presignRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.content.decodeToString
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.request.HttpRequest
import aws.smithy.kotlin.runtime.http.toByteStream
import aws.smithy.kotlin.runtime.net.url.QueryParameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlin.time.Duration

/**
 * Presign a [GetCallerIdentityRequest] using the configuration of this [StsClient].
 * @param input The [GetCallerIdentityRequest] to presign
 * @param duration The amount of time from signing for which the request is valid
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun StsClient.presignGetCallerIdentity(input: GetCallerIdentityRequest, duration: Duration): HttpRequest =
    presignGetCallerIdentity(input) { expiresAfter = duration }

/**
 * Presign a [GetCallerIdentityRequest] using the configuration of this [StsClient].
 * @param input The [GetCallerIdentityRequest] to presign
 * @param signer The specific implementation of AWS signer to use. Defaults to DefaultAwsSigner.
 * @param configBlock A builder block for setting custom signing parameters. At a minimum the
 * [expiresAfter] field must be set.
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun StsClient.presignGetCallerIdentity(
    input: GetCallerIdentityRequest,
    signer: AwsSigner = DefaultAwsSigner,
    configBlock: AwsSigningConfig.Builder.() -> Unit,
): HttpRequest {
    val ctx = ExecutionContext().apply {
        set(SdkClientOption.OperationName, "GetCallerIdentity")
        set(HttpOperationContext.OperationInput, input)
    }
    val unsignedRequest = GetCallerIdentityOperationSerializer().serialize(ctx, input)
    unsignedRequest.method = HttpMethod.GET
    unsignedRequest.body.toByteStream()?.decodeToString()?.let {
        val bodyParams = QueryParameters.parseEncoded(it)
        unsignedRequest.url.parameters.addAll(bodyParams)
    }

    val endpointResolver = EndpointResolverAdapter(config)

    return presignRequest(unsignedRequest, ctx, config.credentialsProvider, endpointResolver, signer) {
        if (service == null) service = "sts"
        if (region == null) region = config.region
        hashSpecification = HashSpecification.CalculateFromPayload
        configBlock()
    }
}
