// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sts.model



class GetSessionTokenRequest private constructor(builder: Builder) {
    /**
     * The duration, in seconds, that the credentials should remain valid. Acceptable durations for IAM user sessions range from 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the default. Sessions for Amazon Web Services account owners are restricted to a maximum of 3,600 seconds (one hour). If the duration is longer than one hour, the session for Amazon Web Services account owners defaults to one hour.
     */
    val durationSeconds: kotlin.Int? = builder.durationSeconds
    /**
     * The identification number of the MFA device that is associated with the IAM user who is making the `GetSessionToken` call. Specify this value if the IAM user has a policy that requires MFA authentication. The value is either the serial number for a hardware device (such as `GAHT12345678`) or an Amazon Resource Name (ARN) for a virtual device (such as `arn:aws:iam::123456789012:mfa/user`). You can find the device for an IAM user by going to the Amazon Web Services Management Console and viewing the user's security credentials.
     *
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-
     */
    val serialNumber: kotlin.String? = builder.serialNumber
    /**
     * The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to submit an MFA code, specify this value. If MFA authentication is required, the user must provide a code when requesting a set of temporary security credentials. A user who fails to provide the code receives an "access denied" response when requesting resources that require MFA authentication.
     *
     * The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
     */
    val tokenCode: kotlin.String? = builder.tokenCode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sts.model.GetSessionTokenRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetSessionTokenRequest(")
        append("durationSeconds=$durationSeconds,")
        append("serialNumber=$serialNumber,")
        append("tokenCode=$tokenCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationSeconds ?: 0
        result = 31 * result + (serialNumber?.hashCode() ?: 0)
        result = 31 * result + (tokenCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetSessionTokenRequest

        if (durationSeconds != other.durationSeconds) return false
        if (serialNumber != other.serialNumber) return false
        if (tokenCode != other.tokenCode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sts.model.GetSessionTokenRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The duration, in seconds, that the credentials should remain valid. Acceptable durations for IAM user sessions range from 900 seconds (15 minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the default. Sessions for Amazon Web Services account owners are restricted to a maximum of 3,600 seconds (one hour). If the duration is longer than one hour, the session for Amazon Web Services account owners defaults to one hour.
         */
        var durationSeconds: kotlin.Int? = null
        /**
         * The identification number of the MFA device that is associated with the IAM user who is making the `GetSessionToken` call. Specify this value if the IAM user has a policy that requires MFA authentication. The value is either the serial number for a hardware device (such as `GAHT12345678`) or an Amazon Resource Name (ARN) for a virtual device (such as `arn:aws:iam::123456789012:mfa/user`). You can find the device for an IAM user by going to the Amazon Web Services Management Console and viewing the user's security credentials.
         *
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-
         */
        var serialNumber: kotlin.String? = null
        /**
         * The value provided by the MFA device, if MFA is required. If any policy requires the IAM user to submit an MFA code, specify this value. If MFA authentication is required, the user must provide a code when requesting a set of temporary security credentials. A user who fails to provide the code receives an "access denied" response when requesting resources that require MFA authentication.
         *
         * The format for this parameter, as described by its regex pattern, is a sequence of six numeric digits.
         */
        var tokenCode: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sts.model.GetSessionTokenRequest) : this() {
            this.durationSeconds = x.durationSeconds
            this.serialNumber = x.serialNumber
            this.tokenCode = x.tokenCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sts.model.GetSessionTokenRequest = GetSessionTokenRequest(this)
    }
}
