// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sts.model



/**
 * Contains the response to a successful AssumeRoleWithSAML request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests.
 */
class AssumeRoleWithSamlResponse private constructor(builder: Builder) {
    /**
     * The identifiers for the temporary security credentials that the operation returns.
     */
    val assumedRoleUser: aws.sdk.kotlin.services.sts.model.AssumedRoleUser? = builder.assumedRoleUser
    /**
     * The value of the `Recipient` attribute of the `SubjectConfirmationData` element of the SAML assertion.
     */
    val audience: kotlin.String? = builder.audience
    /**
     * The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.
     *
     * The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.
     */
    val credentials: aws.sdk.kotlin.services.sts.model.Credentials? = builder.credentials
    /**
     * The value of the `Issuer` element of the SAML assertion.
     */
    val issuer: kotlin.String? = builder.issuer
    /**
     * A hash value based on the concatenation of the following:
     * + The `Issuer` response value.
     * + The Amazon Web Services account ID.
     * + The friendly name (the last part of the ARN) of the SAML provider in IAM.
     *
     * The combination of `NameQualifier` and `Subject` can be used to uniquely identify a federated user.
     *
     * The following pseudocode shows how the hash value is calculated:
     *
     * `BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )`
     */
    val nameQualifier: kotlin.String? = builder.nameQualifier
    /**
     * A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.
     */
    val packedPolicySize: kotlin.Int? = builder.packedPolicySize
    /**
     * The value in the `SourceIdentity` attribute in the SAML assertion.
     *
     * You can require users to set a source identity value when they assume a role. You do this by using the `sts:SourceIdentity` condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across [chained role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining) sessions. You can configure your SAML identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling `AssumeRoleWithSAML`. You do this by adding an attribute to the SAML assertion. For more information about using source identity, see [Monitor and control actions taken with assumed roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html) in the *IAM User Guide*.
     *
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     */
    val sourceIdentity: kotlin.String? = builder.sourceIdentity
    /**
     * The value of the `NameID` element in the `Subject` element of the SAML assertion.
     */
    val subject: kotlin.String? = builder.subject
    /**
     * The format of the name ID, as defined by the `Format` attribute in the `NameID` element of the SAML assertion. Typical examples of the format are `transient` or `persistent`.
     *
     *  If the format includes the prefix `urn:oasis:names:tc:SAML:2.0:nameid-format`, that prefix is removed. For example, `urn:oasis:names:tc:SAML:2.0:nameid-format:transient` is returned as `transient`. If the format includes any other prefix, the format is returned with no modifications.
     */
    val subjectType: kotlin.String? = builder.subjectType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sts.model.AssumeRoleWithSamlResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssumeRoleWithSamlResponse(")
        append("assumedRoleUser=$assumedRoleUser,")
        append("audience=$audience,")
        append("credentials=$credentials,")
        append("issuer=$issuer,")
        append("nameQualifier=$nameQualifier,")
        append("packedPolicySize=$packedPolicySize,")
        append("sourceIdentity=$sourceIdentity,")
        append("subject=$subject,")
        append("subjectType=$subjectType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumedRoleUser?.hashCode() ?: 0
        result = 31 * result + (audience?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (issuer?.hashCode() ?: 0)
        result = 31 * result + (nameQualifier?.hashCode() ?: 0)
        result = 31 * result + (packedPolicySize ?: 0)
        result = 31 * result + (sourceIdentity?.hashCode() ?: 0)
        result = 31 * result + (subject?.hashCode() ?: 0)
        result = 31 * result + (subjectType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssumeRoleWithSamlResponse

        if (assumedRoleUser != other.assumedRoleUser) return false
        if (audience != other.audience) return false
        if (credentials != other.credentials) return false
        if (issuer != other.issuer) return false
        if (nameQualifier != other.nameQualifier) return false
        if (packedPolicySize != other.packedPolicySize) return false
        if (sourceIdentity != other.sourceIdentity) return false
        if (subject != other.subject) return false
        if (subjectType != other.subjectType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sts.model.AssumeRoleWithSamlResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The identifiers for the temporary security credentials that the operation returns.
         */
        var assumedRoleUser: aws.sdk.kotlin.services.sts.model.AssumedRoleUser? = null
        /**
         * The value of the `Recipient` attribute of the `SubjectConfirmationData` element of the SAML assertion.
         */
        var audience: kotlin.String? = null
        /**
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.
         *
         * The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.
         */
        var credentials: aws.sdk.kotlin.services.sts.model.Credentials? = null
        /**
         * The value of the `Issuer` element of the SAML assertion.
         */
        var issuer: kotlin.String? = null
        /**
         * A hash value based on the concatenation of the following:
         * + The `Issuer` response value.
         * + The Amazon Web Services account ID.
         * + The friendly name (the last part of the ARN) of the SAML provider in IAM.
         *
         * The combination of `NameQualifier` and `Subject` can be used to uniquely identify a federated user.
         *
         * The following pseudocode shows how the hash value is calculated:
         *
         * `BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP" ) )`
         */
        var nameQualifier: kotlin.String? = null
        /**
         * A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.
         */
        var packedPolicySize: kotlin.Int? = null
        /**
         * The value in the `SourceIdentity` attribute in the SAML assertion.
         *
         * You can require users to set a source identity value when they assume a role. You do this by using the `sts:SourceIdentity` condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across [chained role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts#iam-term-role-chaining) sessions. You can configure your SAML identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling `AssumeRoleWithSAML`. You do this by adding an attribute to the SAML assertion. For more information about using source identity, see [Monitor and control actions taken with assumed roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html) in the *IAM User Guide*.
         *
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
         */
        var sourceIdentity: kotlin.String? = null
        /**
         * The value of the `NameID` element in the `Subject` element of the SAML assertion.
         */
        var subject: kotlin.String? = null
        /**
         * The format of the name ID, as defined by the `Format` attribute in the `NameID` element of the SAML assertion. Typical examples of the format are `transient` or `persistent`.
         *
         *  If the format includes the prefix `urn:oasis:names:tc:SAML:2.0:nameid-format`, that prefix is removed. For example, `urn:oasis:names:tc:SAML:2.0:nameid-format:transient` is returned as `transient`. If the format includes any other prefix, the format is returned with no modifications.
         */
        var subjectType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sts.model.AssumeRoleWithSamlResponse) : this() {
            this.assumedRoleUser = x.assumedRoleUser
            this.audience = x.audience
            this.credentials = x.credentials
            this.issuer = x.issuer
            this.nameQualifier = x.nameQualifier
            this.packedPolicySize = x.packedPolicySize
            this.sourceIdentity = x.sourceIdentity
            this.subject = x.subject
            this.subjectType = x.subjectType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sts.model.AssumeRoleWithSamlResponse = AssumeRoleWithSamlResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.sts.model.AssumedRoleUser] inside the given [block]
         */
        fun assumedRoleUser(block: aws.sdk.kotlin.services.sts.model.AssumedRoleUser.Builder.() -> kotlin.Unit) {
            this.assumedRoleUser = aws.sdk.kotlin.services.sts.model.AssumedRoleUser.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.sts.model.Credentials] inside the given [block]
         */
        fun credentials(block: aws.sdk.kotlin.services.sts.model.Credentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.sts.model.Credentials.invoke(block)
        }
    }
}
