// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.storagegateway.model.DescribeSnapshotScheduleResponse
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.sdk.kotlin.services.storagegateway.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSnapshotScheduleOperationDeserializer: HttpDeserialize<DescribeSnapshotScheduleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSnapshotScheduleResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSnapshotScheduleError(context, response)
        }
        val builder = DescribeSnapshotScheduleResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSnapshotScheduleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeSnapshotScheduleOperationBody(builder: DescribeSnapshotScheduleResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val RECURRENCEINHOURS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RecurrenceInHours"))
    val STARTAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StartAt"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TIMEZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Timezone"))
    val VOLUMEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VolumeARN"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESCRIPTION_DESCRIPTOR)
        field(RECURRENCEINHOURS_DESCRIPTOR)
        field(STARTAT_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TIMEZONE_DESCRIPTOR)
        field(VOLUMEARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                RECURRENCEINHOURS_DESCRIPTOR.index -> builder.recurrenceInHours = deserializeInt()
                STARTAT_DESCRIPTOR.index -> builder.startAt = deserializeInt()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TIMEZONE_DESCRIPTOR.index -> builder.timezone = deserializeString()
                VOLUMEARN_DESCRIPTOR.index -> builder.volumeArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeSnapshotScheduleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer()
        else -> throw StorageGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
