// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.storagegateway.model.DescribeSmbFileSharesResponse
import aws.sdk.kotlin.services.storagegateway.model.SmbFileShareInfo
import aws.sdk.kotlin.services.storagegateway.model.StorageGatewayException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSMBFileSharesOperationDeserializer: HttpDeserialize<DescribeSmbFileSharesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSmbFileSharesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSmbFileSharesError(context, response)
        }
        val builder = DescribeSmbFileSharesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSMBFileSharesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeSMBFileSharesOperationBody(builder: DescribeSmbFileSharesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SMBFILESHAREINFOLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SMBFileShareInfoList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SMBFILESHAREINFOLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SMBFILESHAREINFOLIST_DESCRIPTOR.index -> builder.smbFileShareInfoList =
                    deserializer.deserializeList(SMBFILESHAREINFOLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<SmbFileShareInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSmbFileShareInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeSmbFileSharesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidGatewayRequestException" -> InvalidGatewayRequestExceptionDeserializer()
        else -> throw StorageGatewayException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
