// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Represents a device object associated with a tape gateway.
 */
class VtlDevice private constructor(builder: BuilderImpl) {
    /**
     * A list of iSCSI information about a VTL device.
     */
    val deviceiScsiAttributes: DeviceiScsiAttributes? = builder.deviceiScsiAttributes
    /**
     * Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media
     * changer).
     */
    val vtlDeviceArn: String? = builder.vtlDeviceArn
    /**
     * Specifies the model number of device that the VTL device emulates.
     */
    val vtlDeviceProductIdentifier: String? = builder.vtlDeviceProductIdentifier
    /**
     * Specifies the type of device that the VTL device emulates.
     */
    val vtlDeviceType: String? = builder.vtlDeviceType
    /**
     * Specifies the vendor of the device that the VTL device object emulates.
     */
    val vtlDeviceVendor: String? = builder.vtlDeviceVendor

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VtlDevice = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VtlDevice(")
        append("deviceiScsiAttributes=$deviceiScsiAttributes,")
        append("vtlDeviceArn=$vtlDeviceArn,")
        append("vtlDeviceProductIdentifier=$vtlDeviceProductIdentifier,")
        append("vtlDeviceType=$vtlDeviceType,")
        append("vtlDeviceVendor=$vtlDeviceVendor)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deviceiScsiAttributes?.hashCode() ?: 0
        result = 31 * result + (vtlDeviceArn?.hashCode() ?: 0)
        result = 31 * result + (vtlDeviceProductIdentifier?.hashCode() ?: 0)
        result = 31 * result + (vtlDeviceType?.hashCode() ?: 0)
        result = 31 * result + (vtlDeviceVendor?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VtlDevice

        if (deviceiScsiAttributes != other.deviceiScsiAttributes) return false
        if (vtlDeviceArn != other.vtlDeviceArn) return false
        if (vtlDeviceProductIdentifier != other.vtlDeviceProductIdentifier) return false
        if (vtlDeviceType != other.vtlDeviceType) return false
        if (vtlDeviceVendor != other.vtlDeviceVendor) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VtlDevice = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VtlDevice
        /**
         * A list of iSCSI information about a VTL device.
         */
        fun deviceiScsiAttributes(deviceiScsiAttributes: DeviceiScsiAttributes): FluentBuilder
        /**
         * Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media
         * changer).
         */
        fun vtlDeviceArn(vtlDeviceArn: String): FluentBuilder
        /**
         * Specifies the model number of device that the VTL device emulates.
         */
        fun vtlDeviceProductIdentifier(vtlDeviceProductIdentifier: String): FluentBuilder
        /**
         * Specifies the type of device that the VTL device emulates.
         */
        fun vtlDeviceType(vtlDeviceType: String): FluentBuilder
        /**
         * Specifies the vendor of the device that the VTL device object emulates.
         */
        fun vtlDeviceVendor(vtlDeviceVendor: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A list of iSCSI information about a VTL device.
         */
        var deviceiScsiAttributes: DeviceiScsiAttributes?
        /**
         * Specifies the unique Amazon Resource Name (ARN) of the device (tape drive or media
         * changer).
         */
        var vtlDeviceArn: String?
        /**
         * Specifies the model number of device that the VTL device emulates.
         */
        var vtlDeviceProductIdentifier: String?
        /**
         * Specifies the type of device that the VTL device emulates.
         */
        var vtlDeviceType: String?
        /**
         * Specifies the vendor of the device that the VTL device object emulates.
         */
        var vtlDeviceVendor: String?

        fun build(): VtlDevice
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.DeviceiScsiAttributes] inside the given [block]
         */
        fun deviceiScsiAttributes(block: DeviceiScsiAttributes.DslBuilder.() -> kotlin.Unit) {
            this.deviceiScsiAttributes = DeviceiScsiAttributes.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deviceiScsiAttributes: DeviceiScsiAttributes? = null
        override var vtlDeviceArn: String? = null
        override var vtlDeviceProductIdentifier: String? = null
        override var vtlDeviceType: String? = null
        override var vtlDeviceVendor: String? = null

        constructor(x: VtlDevice) : this() {
            this.deviceiScsiAttributes = x.deviceiScsiAttributes
            this.vtlDeviceArn = x.vtlDeviceArn
            this.vtlDeviceProductIdentifier = x.vtlDeviceProductIdentifier
            this.vtlDeviceType = x.vtlDeviceType
            this.vtlDeviceVendor = x.vtlDeviceVendor
        }

        override fun build(): VtlDevice = VtlDevice(this)
        override fun deviceiScsiAttributes(deviceiScsiAttributes: DeviceiScsiAttributes): FluentBuilder = apply { this.deviceiScsiAttributes = deviceiScsiAttributes }
        override fun vtlDeviceArn(vtlDeviceArn: String): FluentBuilder = apply { this.vtlDeviceArn = vtlDeviceArn }
        override fun vtlDeviceProductIdentifier(vtlDeviceProductIdentifier: String): FluentBuilder = apply { this.vtlDeviceProductIdentifier = vtlDeviceProductIdentifier }
        override fun vtlDeviceType(vtlDeviceType: String): FluentBuilder = apply { this.vtlDeviceType = vtlDeviceType }
        override fun vtlDeviceVendor(vtlDeviceVendor: String): FluentBuilder = apply { this.vtlDeviceVendor = vtlDeviceVendor }
    }
}
