// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Lists iSCSI information about a volume.
 */
class VolumeiScsiAttributes private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether mutual CHAP is enabled for the iSCSI target.
     */
    val chapEnabled: Boolean = builder.chapEnabled
    /**
     * The logical disk number.
     */
    val lunNumber: Int? = builder.lunNumber
    /**
     * The network interface identifier.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The port used to communicate with iSCSI targets.
     */
    val networkInterfacePort: Int = builder.networkInterfacePort
    /**
     * The Amazon Resource Name (ARN) of the volume target.
     */
    val targetArn: String? = builder.targetArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VolumeiScsiAttributes = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeiScsiAttributes(")
        append("chapEnabled=$chapEnabled,")
        append("lunNumber=$lunNumber,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("networkInterfacePort=$networkInterfacePort,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = chapEnabled.hashCode()
        result = 31 * result + (lunNumber ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfacePort)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeiScsiAttributes

        if (chapEnabled != other.chapEnabled) return false
        if (lunNumber != other.lunNumber) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (networkInterfacePort != other.networkInterfacePort) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VolumeiScsiAttributes = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VolumeiScsiAttributes
        /**
         * Indicates whether mutual CHAP is enabled for the iSCSI target.
         */
        fun chapEnabled(chapEnabled: Boolean): FluentBuilder
        /**
         * The logical disk number.
         */
        fun lunNumber(lunNumber: Int): FluentBuilder
        /**
         * The network interface identifier.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The port used to communicate with iSCSI targets.
         */
        fun networkInterfacePort(networkInterfacePort: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the volume target.
         */
        fun targetArn(targetArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether mutual CHAP is enabled for the iSCSI target.
         */
        var chapEnabled: Boolean
        /**
         * The logical disk number.
         */
        var lunNumber: Int?
        /**
         * The network interface identifier.
         */
        var networkInterfaceId: String?
        /**
         * The port used to communicate with iSCSI targets.
         */
        var networkInterfacePort: Int
        /**
         * The Amazon Resource Name (ARN) of the volume target.
         */
        var targetArn: String?

        fun build(): VolumeiScsiAttributes
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var chapEnabled: Boolean = false
        override var lunNumber: Int? = null
        override var networkInterfaceId: String? = null
        override var networkInterfacePort: Int = 0
        override var targetArn: String? = null

        constructor(x: VolumeiScsiAttributes) : this() {
            this.chapEnabled = x.chapEnabled
            this.lunNumber = x.lunNumber
            this.networkInterfaceId = x.networkInterfaceId
            this.networkInterfacePort = x.networkInterfacePort
            this.targetArn = x.targetArn
        }

        override fun build(): VolumeiScsiAttributes = VolumeiScsiAttributes(this)
        override fun chapEnabled(chapEnabled: Boolean): FluentBuilder = apply { this.chapEnabled = chapEnabled }
        override fun lunNumber(lunNumber: Int): FluentBuilder = apply { this.lunNumber = lunNumber }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun networkInterfacePort(networkInterfacePort: Int): FluentBuilder = apply { this.networkInterfacePort = networkInterfacePort }
        override fun targetArn(targetArn: String): FluentBuilder = apply { this.targetArn = targetArn }
    }
}
