// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a storage volume recovery point object.
 */
class VolumeRecoveryPointInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the volume target.
     */
    val volumeArn: String? = builder.volumeArn
    /**
     * The time the recovery point was taken.
     */
    val volumeRecoveryPointTime: String? = builder.volumeRecoveryPointTime
    /**
     * The size of the volume in bytes.
     */
    val volumeSizeInBytes: Long = builder.volumeSizeInBytes
    /**
     * The size of the data stored on the volume in bytes.
     * This value is not available for volumes created prior to May 13, 2015, until you
     * store data on the volume.
     */
    val volumeUsageInBytes: Long = builder.volumeUsageInBytes

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VolumeRecoveryPointInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeRecoveryPointInfo(")
        append("volumeArn=$volumeArn,")
        append("volumeRecoveryPointTime=$volumeRecoveryPointTime,")
        append("volumeSizeInBytes=$volumeSizeInBytes,")
        append("volumeUsageInBytes=$volumeUsageInBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = volumeArn?.hashCode() ?: 0
        result = 31 * result + (volumeRecoveryPointTime?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        result = 31 * result + (volumeUsageInBytes.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeRecoveryPointInfo

        if (volumeArn != other.volumeArn) return false
        if (volumeRecoveryPointTime != other.volumeRecoveryPointTime) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false
        if (volumeUsageInBytes != other.volumeUsageInBytes) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VolumeRecoveryPointInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VolumeRecoveryPointInfo
        /**
         * The Amazon Resource Name (ARN) of the volume target.
         */
        fun volumeArn(volumeArn: String): FluentBuilder
        /**
         * The time the recovery point was taken.
         */
        fun volumeRecoveryPointTime(volumeRecoveryPointTime: String): FluentBuilder
        /**
         * The size of the volume in bytes.
         */
        fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder
        /**
         * The size of the data stored on the volume in bytes.
         * This value is not available for volumes created prior to May 13, 2015, until you
         * store data on the volume.
         */
        fun volumeUsageInBytes(volumeUsageInBytes: Long): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the volume target.
         */
        var volumeArn: String?
        /**
         * The time the recovery point was taken.
         */
        var volumeRecoveryPointTime: String?
        /**
         * The size of the volume in bytes.
         */
        var volumeSizeInBytes: Long
        /**
         * The size of the data stored on the volume in bytes.
         * This value is not available for volumes created prior to May 13, 2015, until you
         * store data on the volume.
         */
        var volumeUsageInBytes: Long

        fun build(): VolumeRecoveryPointInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var volumeArn: String? = null
        override var volumeRecoveryPointTime: String? = null
        override var volumeSizeInBytes: Long = 0L
        override var volumeUsageInBytes: Long = 0L

        constructor(x: VolumeRecoveryPointInfo) : this() {
            this.volumeArn = x.volumeArn
            this.volumeRecoveryPointTime = x.volumeRecoveryPointTime
            this.volumeSizeInBytes = x.volumeSizeInBytes
            this.volumeUsageInBytes = x.volumeUsageInBytes
        }

        override fun build(): VolumeRecoveryPointInfo = VolumeRecoveryPointInfo(this)
        override fun volumeArn(volumeArn: String): FluentBuilder = apply { this.volumeArn = volumeArn }
        override fun volumeRecoveryPointTime(volumeRecoveryPointTime: String): FluentBuilder = apply { this.volumeRecoveryPointTime = volumeRecoveryPointTime }
        override fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder = apply { this.volumeSizeInBytes = volumeSizeInBytes }
        override fun volumeUsageInBytes(volumeUsageInBytes: Long): FluentBuilder = apply { this.volumeUsageInBytes = volumeUsageInBytes }
    }
}
