// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * Describes a storage volume object.
 */
class VolumeInfo private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * The unique identifier assigned to your gateway during activation. This ID becomes part
     * of the gateway Amazon Resource Name (ARN), which you use as input for other
     * operations.
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    val gatewayId: String? = builder.gatewayId
    /**
     * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a
     * valid ARN:
     * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    val volumeArn: String? = builder.volumeArn
    /**
     * One of the VolumeStatus values that indicates the state of the storage volume.
     */
    val volumeAttachmentStatus: String? = builder.volumeAttachmentStatus
    /**
     * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon
     * Resource Name (ARN), which you use as input for other operations.
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    val volumeId: String? = builder.volumeId
    /**
     * The size of the volume in bytes.
     * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
     */
    val volumeSizeInBytes: Long = builder.volumeSizeInBytes
    /**
     * One of the VolumeType enumeration values describing the type of the volume.
     */
    val volumeType: String? = builder.volumeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VolumeInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeInfo(")
        append("gatewayArn=$gatewayArn,")
        append("gatewayId=$gatewayId,")
        append("volumeArn=$volumeArn,")
        append("volumeAttachmentStatus=$volumeAttachmentStatus,")
        append("volumeId=$volumeId,")
        append("volumeSizeInBytes=$volumeSizeInBytes,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gatewayArn?.hashCode() ?: 0
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        result = 31 * result + (volumeAttachmentStatus?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeSizeInBytes.hashCode())
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeInfo

        if (gatewayArn != other.gatewayArn) return false
        if (gatewayId != other.gatewayId) return false
        if (volumeArn != other.volumeArn) return false
        if (volumeAttachmentStatus != other.volumeAttachmentStatus) return false
        if (volumeId != other.volumeId) return false
        if (volumeSizeInBytes != other.volumeSizeInBytes) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VolumeInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VolumeInfo
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part
         * of the gateway Amazon Resource Name (ARN), which you use as input for other
         * operations.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        fun gatewayId(gatewayId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a
         * valid ARN:
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        fun volumeArn(volumeArn: String): FluentBuilder
        /**
         * One of the VolumeStatus values that indicates the state of the storage volume.
         */
        fun volumeAttachmentStatus(volumeAttachmentStatus: String): FluentBuilder
        /**
         * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        fun volumeId(volumeId: String): FluentBuilder
        /**
         * The size of the volume in bytes.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder
        /**
         * One of the VolumeType enumeration values describing the type of the volume.
         */
        fun volumeType(volumeType: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * The unique identifier assigned to your gateway during activation. This ID becomes part
         * of the gateway Amazon Resource Name (ARN), which you use as input for other
         * operations.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        var gatewayId: String?
        /**
         * The Amazon Resource Name (ARN) for the storage volume. For example, the following is a
         * valid ARN:
         * arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        var volumeArn: String?
        /**
         * One of the VolumeStatus values that indicates the state of the storage volume.
         */
        var volumeAttachmentStatus: String?
        /**
         * The unique identifier assigned to the volume. This ID becomes part of the volume Amazon
         * Resource Name (ARN), which you use as input for other operations.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        var volumeId: String?
        /**
         * The size of the volume in bytes.
         * Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens (-).
         */
        var volumeSizeInBytes: Long
        /**
         * One of the VolumeType enumeration values describing the type of the volume.
         */
        var volumeType: String?

        fun build(): VolumeInfo
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var gatewayArn: String? = null
        override var gatewayId: String? = null
        override var volumeArn: String? = null
        override var volumeAttachmentStatus: String? = null
        override var volumeId: String? = null
        override var volumeSizeInBytes: Long = 0L
        override var volumeType: String? = null

        constructor(x: VolumeInfo) : this() {
            this.gatewayArn = x.gatewayArn
            this.gatewayId = x.gatewayId
            this.volumeArn = x.volumeArn
            this.volumeAttachmentStatus = x.volumeAttachmentStatus
            this.volumeId = x.volumeId
            this.volumeSizeInBytes = x.volumeSizeInBytes
            this.volumeType = x.volumeType
        }

        override fun build(): VolumeInfo = VolumeInfo(this)
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun gatewayId(gatewayId: String): FluentBuilder = apply { this.gatewayId = gatewayId }
        override fun volumeArn(volumeArn: String): FluentBuilder = apply { this.volumeArn = volumeArn }
        override fun volumeAttachmentStatus(volumeAttachmentStatus: String): FluentBuilder = apply { this.volumeAttachmentStatus = volumeAttachmentStatus }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
        override fun volumeSizeInBytes(volumeSizeInBytes: Long): FluentBuilder = apply { this.volumeSizeInBytes = volumeSizeInBytes }
        override fun volumeType(volumeType: String): FluentBuilder = apply { this.volumeType = volumeType }
    }
}
