// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * A JSON object containing one or more of the following fields:
 * UpdateSnapshotScheduleInput$Description
 * UpdateSnapshotScheduleInput$RecurrenceInHours
 * UpdateSnapshotScheduleInput$StartAt
 * UpdateSnapshotScheduleInput$VolumeARN
 */
class UpdateSnapshotScheduleRequest private constructor(builder: BuilderImpl) {
    /**
     * Optional description of the snapshot that overwrites the existing description.
     */
    val description: String? = builder.description
    /**
     * Frequency of snapshots. Specify the number of hours between snapshots.
     */
    val recurrenceInHours: Int? = builder.recurrenceInHours
    /**
     * The hour of the day at which the snapshot schedule begins represented as
     * hh, where hh is the hour (0 to 23). The hour
     * of the day is in the time zone of the gateway.
     */
    val startAt: Int? = builder.startAt
    /**
     * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
     * pair.
     * Valid characters for key and value are letters, spaces, and numbers representable in
     * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
     * of a tag's key is 128 characters, and the maximum length for a tag's value is
     * 256.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
     * operation to return a list of gateway volumes.
     */
    val volumeArn: String? = builder.volumeArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateSnapshotScheduleRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSnapshotScheduleRequest(")
        append("description=$description,")
        append("recurrenceInHours=$recurrenceInHours,")
        append("startAt=$startAt,")
        append("tags=$tags,")
        append("volumeArn=$volumeArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (recurrenceInHours ?: 0)
        result = 31 * result + (startAt ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateSnapshotScheduleRequest

        if (description != other.description) return false
        if (recurrenceInHours != other.recurrenceInHours) return false
        if (startAt != other.startAt) return false
        if (tags != other.tags) return false
        if (volumeArn != other.volumeArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateSnapshotScheduleRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateSnapshotScheduleRequest
        /**
         * Optional description of the snapshot that overwrites the existing description.
         */
        fun description(description: String): FluentBuilder
        /**
         * Frequency of snapshots. Specify the number of hours between snapshots.
         */
        fun recurrenceInHours(recurrenceInHours: Int): FluentBuilder
        /**
         * The hour of the day at which the snapshot schedule begins represented as
         * hh, where hh is the hour (0 to 23). The hour
         * of the day is in the time zone of the gateway.
         */
        fun startAt(startAt: Int): FluentBuilder
        /**
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
         * operation to return a list of gateway volumes.
         */
        fun volumeArn(volumeArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Optional description of the snapshot that overwrites the existing description.
         */
        var description: String?
        /**
         * Frequency of snapshots. Specify the number of hours between snapshots.
         */
        var recurrenceInHours: Int?
        /**
         * The hour of the day at which the snapshot schedule begins represented as
         * hh, where hh is the hour (0 to 23). The hour
         * of the day is in the time zone of the gateway.
         */
        var startAt: Int?
        /**
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value
         * pair.
         * Valid characters for key and value are letters, spaces, and numbers representable in
         * UTF-8 format, and the following special characters: + - = . _ : / @. The maximum length
         * of a tag's key is 128 characters, and the maximum length for a tag's value is
         * 256.
         */
        var tags: List<Tag>?
        /**
         * The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
         * operation to return a list of gateway volumes.
         */
        var volumeArn: String?

        fun build(): UpdateSnapshotScheduleRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var recurrenceInHours: Int? = null
        override var startAt: Int? = null
        override var tags: List<Tag>? = null
        override var volumeArn: String? = null

        constructor(x: UpdateSnapshotScheduleRequest) : this() {
            this.description = x.description
            this.recurrenceInHours = x.recurrenceInHours
            this.startAt = x.startAt
            this.tags = x.tags
            this.volumeArn = x.volumeArn
        }

        override fun build(): UpdateSnapshotScheduleRequest = UpdateSnapshotScheduleRequest(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun recurrenceInHours(recurrenceInHours: Int): FluentBuilder = apply { this.recurrenceInHours = recurrenceInHours }
        override fun startAt(startAt: Int): FluentBuilder = apply { this.startAt = startAt }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun volumeArn(volumeArn: String): FluentBuilder = apply { this.volumeArn = volumeArn }
    }
}
