// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * UpdateSMBFileShareInput
 */
class UpdateSmbFileShareRequest private constructor(builder: BuilderImpl) {
    /**
     * The files and folders on this share will only be visible to users with read
     * access.
     */
    val accessBasedEnumeration: Boolean? = builder.accessBasedEnumeration
    /**
     * A list of users or groups in the Active Directory that have administrator rights to the
     * file share. A group must be prefixed with the @ character. Acceptable formats include:
     * DOMAIN\User1, user1, @group1, and
     * @DOMAIN\group1. Can only be set if Authentication is set to
     * ActiveDirectory.
     */
    val adminUserList: List<String>? = builder.adminUserList
    /**
     * The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    val auditDestinationArn: String? = builder.auditDestinationArn
    /**
     * Specifies refresh cache information for the file share.
     */
    val cacheAttributes: CacheAttributes? = builder.cacheAttributes
    /**
     * The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
     * client determines the case sensitivity. For CaseSensitive, the gateway
     * determines the case sensitivity. The default value is ClientSpecified.
     */
    val caseSensitivity: CaseSensitivity? = builder.caseSensitivity
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
     * The default value is S3_INTELLIGENT_TIERING. Optional.
     * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
     * S3_STANDARD_IA | S3_ONEZONE_IA
     */
    val defaultStorageClass: String? = builder.defaultStorageClass
    /**
     * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
     */
    val fileShareArn: String? = builder.fileShareArn
    /**
     * The name of the file share. Optional.
     * FileShareName must be set if an S3 prefix name is set in
     * LocationARN.
     */
    val fileShareName: String? = builder.fileShareName
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file
     * extensions. Set this value to true to enable MIME type guessing, otherwise set
     * to false. The default value is true.
     * Valid Values: true | false
     */
    val guessMimeTypeEnabled: Boolean? = builder.guessMimeTypeEnabled
    /**
     * A list of users or groups in the Active Directory that are not allowed to access the
     * file share. A group must be prefixed with the @ character. Acceptable formats include:
     * DOMAIN\User1, user1, @group1, and
     * @DOMAIN\group1. Can only be set if Authentication is set to
     * ActiveDirectory.
     */
    val invalidUserList: List<String>? = builder.invalidUserList
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The notification policy of the file share. SettlingTimeInSeconds controls
     * the number of seconds to wait after the last point in time a client wrote to a file before
     * generating an ObjectUploaded notification. Because clients can make many small
     * writes to files, it's best to set this parameter for as long as possible to avoid
     * generating multiple notifications for the same file in a small time period.
     * SettlingTimeInSeconds has no effect on the timing of the object
     * uploading to Amazon S3, only the timing of the notification.
     * The following example sets NotificationPolicy on with
     * SettlingTimeInSeconds set to 60.
     * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
     * The following example sets NotificationPolicy off.
     * {}
     */
    val notificationPolicy: String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket
     * that a S3 File Gateway puts objects into. The default value is private.
     */
    val objectAcl: ObjectAcl? = builder.objectAcl
    /**
     * Specifies whether opportunistic locking is enabled for the SMB file share.
     * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve
     * access to files with the same name in different case.
     * Valid Values: true | false
     */
    val oplocksEnabled: Boolean? = builder.oplocksEnabled
    /**
     * A value that sets the write status of a file share. Set this value to true
     * to set write status to read-only, otherwise set to false.
     * Valid Values: true | false
     */
    val readOnly: Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data
     * download from the S3 bucket. If this value is set to true, the requester pays
     * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
     * the cost of storing data.
     * RequesterPays is a configuration for the S3 bucket that backs the file
     * share, so make sure that the configuration on the file share is the same as the S3
     * bucket configuration.
     * Valid Values: true | false
     */
    val requesterPays: Boolean? = builder.requesterPays
    /**
     * Set this value to true to enable access control list (ACL) on the SMB file
     * share. Set it to false to map file and directory permissions to the POSIX
     * permissions.
     * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
     * control access to an SMB file share in the Storage Gateway User
     * Guide.
     * Valid Values: true | false
     */
    val smbaclEnabled: Boolean? = builder.smbaclEnabled
    /**
     * A list of users or groups in the Active Directory that are allowed to access the file
     * share. A group must be prefixed with the @ character. Acceptable formats include:
     * DOMAIN\User1, user1, @group1, and
     * @DOMAIN\group1. Can only be set if Authentication is set to
     * ActiveDirectory.
     */
    val validUserList: List<String>? = builder.validUserList

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateSmbFileShareRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateSmbFileShareRequest(")
        append("accessBasedEnumeration=$accessBasedEnumeration,")
        append("adminUserList=$adminUserList,")
        append("auditDestinationArn=$auditDestinationArn,")
        append("cacheAttributes=$cacheAttributes,")
        append("caseSensitivity=$caseSensitivity,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareArn=$fileShareArn,")
        append("fileShareName=$fileShareName,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("invalidUserList=$invalidUserList,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("oplocksEnabled=$oplocksEnabled,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("smbaclEnabled=$smbaclEnabled,")
        append("validUserList=$validUserList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessBasedEnumeration?.hashCode() ?: 0
        result = 31 * result + (adminUserList?.hashCode() ?: 0)
        result = 31 * result + (auditDestinationArn?.hashCode() ?: 0)
        result = 31 * result + (cacheAttributes?.hashCode() ?: 0)
        result = 31 * result + (caseSensitivity?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (invalidUserList?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (oplocksEnabled?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (smbaclEnabled?.hashCode() ?: 0)
        result = 31 * result + (validUserList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateSmbFileShareRequest

        if (accessBasedEnumeration != other.accessBasedEnumeration) return false
        if (adminUserList != other.adminUserList) return false
        if (auditDestinationArn != other.auditDestinationArn) return false
        if (cacheAttributes != other.cacheAttributes) return false
        if (caseSensitivity != other.caseSensitivity) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareArn != other.fileShareArn) return false
        if (fileShareName != other.fileShareName) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (invalidUserList != other.invalidUserList) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (oplocksEnabled != other.oplocksEnabled) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (smbaclEnabled != other.smbaclEnabled) return false
        if (validUserList != other.validUserList) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateSmbFileShareRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateSmbFileShareRequest
        /**
         * The files and folders on this share will only be visible to users with read
         * access.
         */
        fun accessBasedEnumeration(accessBasedEnumeration: Boolean): FluentBuilder
        /**
         * A list of users or groups in the Active Directory that have administrator rights to the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        fun adminUserList(adminUserList: List<String>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        fun auditDestinationArn(auditDestinationArn: String): FluentBuilder
        /**
         * Specifies refresh cache information for the file share.
         */
        fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder
        /**
         * The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
         * client determines the case sensitivity. For CaseSensitive, the gateway
         * determines the case sensitivity. The default value is ClientSpecified.
         */
        fun caseSensitivity(caseSensitivity: CaseSensitivity): FluentBuilder
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
         * The default value is S3_INTELLIGENT_TIERING. Optional.
         * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
         * S3_STANDARD_IA | S3_ONEZONE_IA
         */
        fun defaultStorageClass(defaultStorageClass: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         */
        fun fileShareArn(fileShareArn: String): FluentBuilder
        /**
         * The name of the file share. Optional.
         * FileShareName must be set if an S3 prefix name is set in
         * LocationARN.
         */
        fun fileShareName(fileShareName: String): FluentBuilder
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file
         * extensions. Set this value to true to enable MIME type guessing, otherwise set
         * to false. The default value is true.
         * Valid Values: true | false
         */
        fun guessMimeTypeEnabled(guessMimeTypeEnabled: Boolean): FluentBuilder
        /**
         * A list of users or groups in the Active Directory that are not allowed to access the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        fun invalidUserList(invalidUserList: List<String>): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The notification policy of the file share. SettlingTimeInSeconds controls
         * the number of seconds to wait after the last point in time a client wrote to a file before
         * generating an ObjectUploaded notification. Because clients can make many small
         * writes to files, it's best to set this parameter for as long as possible to avoid
         * generating multiple notifications for the same file in a small time period.
         * SettlingTimeInSeconds has no effect on the timing of the object
         * uploading to Amazon S3, only the timing of the notification.
         * The following example sets NotificationPolicy on with
         * SettlingTimeInSeconds set to 60.
         * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
         * The following example sets NotificationPolicy off.
         * {}
         */
        fun notificationPolicy(notificationPolicy: String): FluentBuilder
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket
         * that a S3 File Gateway puts objects into. The default value is private.
         */
        fun objectAcl(objectAcl: ObjectAcl): FluentBuilder
        /**
         * Specifies whether opportunistic locking is enabled for the SMB file share.
         * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve
         * access to files with the same name in different case.
         * Valid Values: true | false
         */
        fun oplocksEnabled(oplocksEnabled: Boolean): FluentBuilder
        /**
         * A value that sets the write status of a file share. Set this value to true
         * to set write status to read-only, otherwise set to false.
         * Valid Values: true | false
         */
        fun readOnly(readOnly: Boolean): FluentBuilder
        /**
         * A value that sets who pays the cost of the request and the cost associated with data
         * download from the S3 bucket. If this value is set to true, the requester pays
         * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
         * the cost of storing data.
         * RequesterPays is a configuration for the S3 bucket that backs the file
         * share, so make sure that the configuration on the file share is the same as the S3
         * bucket configuration.
         * Valid Values: true | false
         */
        fun requesterPays(requesterPays: Boolean): FluentBuilder
        /**
         * Set this value to true to enable access control list (ACL) on the SMB file
         * share. Set it to false to map file and directory permissions to the POSIX
         * permissions.
         * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
         * control access to an SMB file share in the Storage Gateway User
         * Guide.
         * Valid Values: true | false
         */
        fun smbaclEnabled(smbaclEnabled: Boolean): FluentBuilder
        /**
         * A list of users or groups in the Active Directory that are allowed to access the file
         * share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        fun validUserList(validUserList: List<String>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The files and folders on this share will only be visible to users with read
         * access.
         */
        var accessBasedEnumeration: Boolean?
        /**
         * A list of users or groups in the Active Directory that have administrator rights to the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        var adminUserList: List<String>?
        /**
         * The Amazon Resource Name (ARN) of the storage used for audit logs.
         */
        var auditDestinationArn: String?
        /**
         * Specifies refresh cache information for the file share.
         */
        var cacheAttributes: CacheAttributes?
        /**
         * The case of an object name in an Amazon S3 bucket. For ClientSpecified, the
         * client determines the case sensitivity. For CaseSensitive, the gateway
         * determines the case sensitivity. The default value is ClientSpecified.
         */
        var caseSensitivity: CaseSensitivity?
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
         * The default value is S3_INTELLIGENT_TIERING. Optional.
         * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
         * S3_STANDARD_IA | S3_ONEZONE_IA
         */
        var defaultStorageClass: String?
        /**
         * The Amazon Resource Name (ARN) of the SMB file share that you want to update.
         */
        var fileShareArn: String?
        /**
         * The name of the file share. Optional.
         * FileShareName must be set if an S3 prefix name is set in
         * LocationARN.
         */
        var fileShareName: String?
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file
         * extensions. Set this value to true to enable MIME type guessing, otherwise set
         * to false. The default value is true.
         * Valid Values: true | false
         */
        var guessMimeTypeEnabled: Boolean?
        /**
         * A list of users or groups in the Active Directory that are not allowed to access the
         * file share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        var invalidUserList: List<String>?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The notification policy of the file share. SettlingTimeInSeconds controls
         * the number of seconds to wait after the last point in time a client wrote to a file before
         * generating an ObjectUploaded notification. Because clients can make many small
         * writes to files, it's best to set this parameter for as long as possible to avoid
         * generating multiple notifications for the same file in a small time period.
         * SettlingTimeInSeconds has no effect on the timing of the object
         * uploading to Amazon S3, only the timing of the notification.
         * The following example sets NotificationPolicy on with
         * SettlingTimeInSeconds set to 60.
         * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
         * The following example sets NotificationPolicy off.
         * {}
         */
        var notificationPolicy: String?
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket
         * that a S3 File Gateway puts objects into. The default value is private.
         */
        var objectAcl: ObjectAcl?
        /**
         * Specifies whether opportunistic locking is enabled for the SMB file share.
         * Enabling opportunistic locking on case-sensitive shares is not recommended for workloads that involve
         * access to files with the same name in different case.
         * Valid Values: true | false
         */
        var oplocksEnabled: Boolean?
        /**
         * A value that sets the write status of a file share. Set this value to true
         * to set write status to read-only, otherwise set to false.
         * Valid Values: true | false
         */
        var readOnly: Boolean?
        /**
         * A value that sets who pays the cost of the request and the cost associated with data
         * download from the S3 bucket. If this value is set to true, the requester pays
         * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
         * the cost of storing data.
         * RequesterPays is a configuration for the S3 bucket that backs the file
         * share, so make sure that the configuration on the file share is the same as the S3
         * bucket configuration.
         * Valid Values: true | false
         */
        var requesterPays: Boolean?
        /**
         * Set this value to true to enable access control list (ACL) on the SMB file
         * share. Set it to false to map file and directory permissions to the POSIX
         * permissions.
         * For more information, see <a href="https://docs.aws.amazon.com/storagegateway/latest/userguide/smb-acl.html">Using Microsoft Windows ACLs to
         * control access to an SMB file share in the Storage Gateway User
         * Guide.
         * Valid Values: true | false
         */
        var smbaclEnabled: Boolean?
        /**
         * A list of users or groups in the Active Directory that are allowed to access the file
         * share. A group must be prefixed with the @ character. Acceptable formats include:
         * DOMAIN\User1, user1, @group1, and
         * @DOMAIN\group1. Can only be set if Authentication is set to
         * ActiveDirectory.
         */
        var validUserList: List<String>?

        fun build(): UpdateSmbFileShareRequest
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        fun cacheAttributes(block: CacheAttributes.DslBuilder.() -> kotlin.Unit) {
            this.cacheAttributes = CacheAttributes.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accessBasedEnumeration: Boolean? = null
        override var adminUserList: List<String>? = null
        override var auditDestinationArn: String? = null
        override var cacheAttributes: CacheAttributes? = null
        override var caseSensitivity: CaseSensitivity? = null
        override var defaultStorageClass: String? = null
        override var fileShareArn: String? = null
        override var fileShareName: String? = null
        override var guessMimeTypeEnabled: Boolean? = null
        override var invalidUserList: List<String>? = null
        override var kmsEncrypted: Boolean? = null
        override var kmsKey: String? = null
        override var notificationPolicy: String? = null
        override var objectAcl: ObjectAcl? = null
        override var oplocksEnabled: Boolean? = null
        override var readOnly: Boolean? = null
        override var requesterPays: Boolean? = null
        override var smbaclEnabled: Boolean? = null
        override var validUserList: List<String>? = null

        constructor(x: UpdateSmbFileShareRequest) : this() {
            this.accessBasedEnumeration = x.accessBasedEnumeration
            this.adminUserList = x.adminUserList
            this.auditDestinationArn = x.auditDestinationArn
            this.cacheAttributes = x.cacheAttributes
            this.caseSensitivity = x.caseSensitivity
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareArn = x.fileShareArn
            this.fileShareName = x.fileShareName
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.invalidUserList = x.invalidUserList
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.oplocksEnabled = x.oplocksEnabled
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.smbaclEnabled = x.smbaclEnabled
            this.validUserList = x.validUserList
        }

        override fun build(): UpdateSmbFileShareRequest = UpdateSmbFileShareRequest(this)
        override fun accessBasedEnumeration(accessBasedEnumeration: Boolean): FluentBuilder = apply { this.accessBasedEnumeration = accessBasedEnumeration }
        override fun adminUserList(adminUserList: List<String>): FluentBuilder = apply { this.adminUserList = adminUserList }
        override fun auditDestinationArn(auditDestinationArn: String): FluentBuilder = apply { this.auditDestinationArn = auditDestinationArn }
        override fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder = apply { this.cacheAttributes = cacheAttributes }
        override fun caseSensitivity(caseSensitivity: CaseSensitivity): FluentBuilder = apply { this.caseSensitivity = caseSensitivity }
        override fun defaultStorageClass(defaultStorageClass: String): FluentBuilder = apply { this.defaultStorageClass = defaultStorageClass }
        override fun fileShareArn(fileShareArn: String): FluentBuilder = apply { this.fileShareArn = fileShareArn }
        override fun fileShareName(fileShareName: String): FluentBuilder = apply { this.fileShareName = fileShareName }
        override fun guessMimeTypeEnabled(guessMimeTypeEnabled: Boolean): FluentBuilder = apply { this.guessMimeTypeEnabled = guessMimeTypeEnabled }
        override fun invalidUserList(invalidUserList: List<String>): FluentBuilder = apply { this.invalidUserList = invalidUserList }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun notificationPolicy(notificationPolicy: String): FluentBuilder = apply { this.notificationPolicy = notificationPolicy }
        override fun objectAcl(objectAcl: ObjectAcl): FluentBuilder = apply { this.objectAcl = objectAcl }
        override fun oplocksEnabled(oplocksEnabled: Boolean): FluentBuilder = apply { this.oplocksEnabled = oplocksEnabled }
        override fun readOnly(readOnly: Boolean): FluentBuilder = apply { this.readOnly = readOnly }
        override fun requesterPays(requesterPays: Boolean): FluentBuilder = apply { this.requesterPays = requesterPays }
        override fun smbaclEnabled(smbaclEnabled: Boolean): FluentBuilder = apply { this.smbaclEnabled = smbaclEnabled }
        override fun validUserList(validUserList: List<String>): FluentBuilder = apply { this.validUserList = validUserList }
    }
}
