// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



/**
 * UpdateNFSFileShareInput
 */
class UpdateNfsFileShareRequest private constructor(builder: BuilderImpl) {
    /**
     * specifies refresh cache information for the file share.
     */
    val cacheAttributes: CacheAttributes? = builder.cacheAttributes
    /**
     * The list of clients that are allowed to access the S3 File Gateway. The list must contain
     * either valid IP addresses or valid CIDR blocks.
     */
    val clientList: List<String>? = builder.clientList
    /**
     * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
     * The default value is S3_INTELLIGENT_TIERING. Optional.
     * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
     * S3_STANDARD_IA | S3_ONEZONE_IA
     */
    val defaultStorageClass: String? = builder.defaultStorageClass
    /**
     * The Amazon Resource Name (ARN) of the file share to be updated.
     */
    val fileShareArn: String? = builder.fileShareArn
    /**
     * The name of the file share. Optional.
     * FileShareName must be set if an S3 prefix name is set in
     * LocationARN.
     */
    val fileShareName: String? = builder.fileShareName
    /**
     * A value that enables guessing of the MIME type for uploaded objects based on file
     * extensions. Set this value to true to enable MIME type guessing, otherwise set
     * to false. The default value is true.
     * Valid Values: true | false
     */
    val guessMimeTypeEnabled: Boolean? = builder.guessMimeTypeEnabled
    /**
     * Set to true to use Amazon S3 server-side encryption with your own KMS
     * key, or false to use a key managed by Amazon S3. Optional.
     * Valid Values: true | false
     */
    val kmsEncrypted: Boolean? = builder.kmsEncrypted
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
     * only be set when KMSEncrypted is true. Optional.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The default values for the file share. Optional.
     */
    val nfsFileShareDefaults: NfsFileShareDefaults? = builder.nfsFileShareDefaults
    /**
     * The notification policy of the file share. SettlingTimeInSeconds controls
     * the number of seconds to wait after the last point in time a client wrote to a file before
     * generating an ObjectUploaded notification. Because clients can make many small
     * writes to files, it's best to set this parameter for as long as possible to avoid
     * generating multiple notifications for the same file in a small time period.
     * SettlingTimeInSeconds has no effect on the timing of the object
     * uploading to Amazon S3, only the timing of the notification.
     * The following example sets NotificationPolicy on with
     * SettlingTimeInSeconds set to 60.
     * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
     * The following example sets NotificationPolicy off.
     * {}
     */
    val notificationPolicy: String? = builder.notificationPolicy
    /**
     * A value that sets the access control list (ACL) permission for objects in the S3 bucket
     * that a S3 File Gateway puts objects into. The default value is private.
     */
    val objectAcl: ObjectAcl? = builder.objectAcl
    /**
     * A value that sets the write status of a file share. Set this value to true
     * to set the write status to read-only, otherwise set to false.
     * Valid Values: true | false
     */
    val readOnly: Boolean? = builder.readOnly
    /**
     * A value that sets who pays the cost of the request and the cost associated with data
     * download from the S3 bucket. If this value is set to true, the requester pays
     * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
     * the cost of storing data.
     * RequesterPays is a configuration for the S3 bucket that backs the file
     * share, so make sure that the configuration on the file share is the same as the S3
     * bucket configuration.
     * Valid Values: true | false
     */
    val requesterPays: Boolean? = builder.requesterPays
    /**
     * The user mapped to anonymous user.
     * Valid values are the following:
     * RootSquash: Only root is mapped to anonymous user.
     * NoSquash: No one is mapped to anonymous user.
     * AllSquash: Everyone is mapped to anonymous user.
     */
    val squash: String? = builder.squash

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateNfsFileShareRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateNfsFileShareRequest(")
        append("cacheAttributes=$cacheAttributes,")
        append("clientList=$clientList,")
        append("defaultStorageClass=$defaultStorageClass,")
        append("fileShareArn=$fileShareArn,")
        append("fileShareName=$fileShareName,")
        append("guessMimeTypeEnabled=$guessMimeTypeEnabled,")
        append("kmsEncrypted=$kmsEncrypted,")
        append("kmsKey=$kmsKey,")
        append("nfsFileShareDefaults=$nfsFileShareDefaults,")
        append("notificationPolicy=$notificationPolicy,")
        append("objectAcl=$objectAcl,")
        append("readOnly=$readOnly,")
        append("requesterPays=$requesterPays,")
        append("squash=$squash)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheAttributes?.hashCode() ?: 0
        result = 31 * result + (clientList?.hashCode() ?: 0)
        result = 31 * result + (defaultStorageClass?.hashCode() ?: 0)
        result = 31 * result + (fileShareArn?.hashCode() ?: 0)
        result = 31 * result + (fileShareName?.hashCode() ?: 0)
        result = 31 * result + (guessMimeTypeEnabled?.hashCode() ?: 0)
        result = 31 * result + (kmsEncrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (nfsFileShareDefaults?.hashCode() ?: 0)
        result = 31 * result + (notificationPolicy?.hashCode() ?: 0)
        result = 31 * result + (objectAcl?.hashCode() ?: 0)
        result = 31 * result + (readOnly?.hashCode() ?: 0)
        result = 31 * result + (requesterPays?.hashCode() ?: 0)
        result = 31 * result + (squash?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateNfsFileShareRequest

        if (cacheAttributes != other.cacheAttributes) return false
        if (clientList != other.clientList) return false
        if (defaultStorageClass != other.defaultStorageClass) return false
        if (fileShareArn != other.fileShareArn) return false
        if (fileShareName != other.fileShareName) return false
        if (guessMimeTypeEnabled != other.guessMimeTypeEnabled) return false
        if (kmsEncrypted != other.kmsEncrypted) return false
        if (kmsKey != other.kmsKey) return false
        if (nfsFileShareDefaults != other.nfsFileShareDefaults) return false
        if (notificationPolicy != other.notificationPolicy) return false
        if (objectAcl != other.objectAcl) return false
        if (readOnly != other.readOnly) return false
        if (requesterPays != other.requesterPays) return false
        if (squash != other.squash) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateNfsFileShareRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateNfsFileShareRequest
        /**
         * specifies refresh cache information for the file share.
         */
        fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder
        /**
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain
         * either valid IP addresses or valid CIDR blocks.
         */
        fun clientList(clientList: List<String>): FluentBuilder
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
         * The default value is S3_INTELLIGENT_TIERING. Optional.
         * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
         * S3_STANDARD_IA | S3_ONEZONE_IA
         */
        fun defaultStorageClass(defaultStorageClass: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the file share to be updated.
         */
        fun fileShareArn(fileShareArn: String): FluentBuilder
        /**
         * The name of the file share. Optional.
         * FileShareName must be set if an S3 prefix name is set in
         * LocationARN.
         */
        fun fileShareName(fileShareName: String): FluentBuilder
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file
         * extensions. Set this value to true to enable MIME type guessing, otherwise set
         * to false. The default value is true.
         * Valid Values: true | false
         */
        fun guessMimeTypeEnabled(guessMimeTypeEnabled: Boolean): FluentBuilder
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The default values for the file share. Optional.
         */
        fun nfsFileShareDefaults(nfsFileShareDefaults: NfsFileShareDefaults): FluentBuilder
        /**
         * The notification policy of the file share. SettlingTimeInSeconds controls
         * the number of seconds to wait after the last point in time a client wrote to a file before
         * generating an ObjectUploaded notification. Because clients can make many small
         * writes to files, it's best to set this parameter for as long as possible to avoid
         * generating multiple notifications for the same file in a small time period.
         * SettlingTimeInSeconds has no effect on the timing of the object
         * uploading to Amazon S3, only the timing of the notification.
         * The following example sets NotificationPolicy on with
         * SettlingTimeInSeconds set to 60.
         * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
         * The following example sets NotificationPolicy off.
         * {}
         */
        fun notificationPolicy(notificationPolicy: String): FluentBuilder
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket
         * that a S3 File Gateway puts objects into. The default value is private.
         */
        fun objectAcl(objectAcl: ObjectAcl): FluentBuilder
        /**
         * A value that sets the write status of a file share. Set this value to true
         * to set the write status to read-only, otherwise set to false.
         * Valid Values: true | false
         */
        fun readOnly(readOnly: Boolean): FluentBuilder
        /**
         * A value that sets who pays the cost of the request and the cost associated with data
         * download from the S3 bucket. If this value is set to true, the requester pays
         * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
         * the cost of storing data.
         * RequesterPays is a configuration for the S3 bucket that backs the file
         * share, so make sure that the configuration on the file share is the same as the S3
         * bucket configuration.
         * Valid Values: true | false
         */
        fun requesterPays(requesterPays: Boolean): FluentBuilder
        /**
         * The user mapped to anonymous user.
         * Valid values are the following:
         * RootSquash: Only root is mapped to anonymous user.
         * NoSquash: No one is mapped to anonymous user.
         * AllSquash: Everyone is mapped to anonymous user.
         */
        fun squash(squash: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * specifies refresh cache information for the file share.
         */
        var cacheAttributes: CacheAttributes?
        /**
         * The list of clients that are allowed to access the S3 File Gateway. The list must contain
         * either valid IP addresses or valid CIDR blocks.
         */
        var clientList: List<String>?
        /**
         * The default storage class for objects put into an Amazon S3 bucket by the S3 File Gateway.
         * The default value is S3_INTELLIGENT_TIERING. Optional.
         * Valid Values: S3_STANDARD | S3_INTELLIGENT_TIERING |
         * S3_STANDARD_IA | S3_ONEZONE_IA
         */
        var defaultStorageClass: String?
        /**
         * The Amazon Resource Name (ARN) of the file share to be updated.
         */
        var fileShareArn: String?
        /**
         * The name of the file share. Optional.
         * FileShareName must be set if an S3 prefix name is set in
         * LocationARN.
         */
        var fileShareName: String?
        /**
         * A value that enables guessing of the MIME type for uploaded objects based on file
         * extensions. Set this value to true to enable MIME type guessing, otherwise set
         * to false. The default value is true.
         * Valid Values: true | false
         */
        var guessMimeTypeEnabled: Boolean?
        /**
         * Set to true to use Amazon S3 server-side encryption with your own KMS
         * key, or false to use a key managed by Amazon S3. Optional.
         * Valid Values: true | false
         */
        var kmsEncrypted: Boolean?
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) used for Amazon S3 server-side encryption. Storage Gateway does not support asymmetric CMKs. This value can
         * only be set when KMSEncrypted is true. Optional.
         */
        var kmsKey: String?
        /**
         * The default values for the file share. Optional.
         */
        var nfsFileShareDefaults: NfsFileShareDefaults?
        /**
         * The notification policy of the file share. SettlingTimeInSeconds controls
         * the number of seconds to wait after the last point in time a client wrote to a file before
         * generating an ObjectUploaded notification. Because clients can make many small
         * writes to files, it's best to set this parameter for as long as possible to avoid
         * generating multiple notifications for the same file in a small time period.
         * SettlingTimeInSeconds has no effect on the timing of the object
         * uploading to Amazon S3, only the timing of the notification.
         * The following example sets NotificationPolicy on with
         * SettlingTimeInSeconds set to 60.
         * {\"Upload\": {\"SettlingTimeInSeconds\": 60}}
         * The following example sets NotificationPolicy off.
         * {}
         */
        var notificationPolicy: String?
        /**
         * A value that sets the access control list (ACL) permission for objects in the S3 bucket
         * that a S3 File Gateway puts objects into. The default value is private.
         */
        var objectAcl: ObjectAcl?
        /**
         * A value that sets the write status of a file share. Set this value to true
         * to set the write status to read-only, otherwise set to false.
         * Valid Values: true | false
         */
        var readOnly: Boolean?
        /**
         * A value that sets who pays the cost of the request and the cost associated with data
         * download from the S3 bucket. If this value is set to true, the requester pays
         * the costs; otherwise, the S3 bucket owner pays. However, the S3 bucket owner always pays
         * the cost of storing data.
         * RequesterPays is a configuration for the S3 bucket that backs the file
         * share, so make sure that the configuration on the file share is the same as the S3
         * bucket configuration.
         * Valid Values: true | false
         */
        var requesterPays: Boolean?
        /**
         * The user mapped to anonymous user.
         * Valid values are the following:
         * RootSquash: Only root is mapped to anonymous user.
         * NoSquash: No one is mapped to anonymous user.
         * AllSquash: Everyone is mapped to anonymous user.
         */
        var squash: String?

        fun build(): UpdateNfsFileShareRequest
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.CacheAttributes] inside the given [block]
         */
        fun cacheAttributes(block: CacheAttributes.DslBuilder.() -> kotlin.Unit) {
            this.cacheAttributes = CacheAttributes.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.storagegateway.model.NfsFileShareDefaults] inside the given [block]
         */
        fun nfsFileShareDefaults(block: NfsFileShareDefaults.DslBuilder.() -> kotlin.Unit) {
            this.nfsFileShareDefaults = NfsFileShareDefaults.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cacheAttributes: CacheAttributes? = null
        override var clientList: List<String>? = null
        override var defaultStorageClass: String? = null
        override var fileShareArn: String? = null
        override var fileShareName: String? = null
        override var guessMimeTypeEnabled: Boolean? = null
        override var kmsEncrypted: Boolean? = null
        override var kmsKey: String? = null
        override var nfsFileShareDefaults: NfsFileShareDefaults? = null
        override var notificationPolicy: String? = null
        override var objectAcl: ObjectAcl? = null
        override var readOnly: Boolean? = null
        override var requesterPays: Boolean? = null
        override var squash: String? = null

        constructor(x: UpdateNfsFileShareRequest) : this() {
            this.cacheAttributes = x.cacheAttributes
            this.clientList = x.clientList
            this.defaultStorageClass = x.defaultStorageClass
            this.fileShareArn = x.fileShareArn
            this.fileShareName = x.fileShareName
            this.guessMimeTypeEnabled = x.guessMimeTypeEnabled
            this.kmsEncrypted = x.kmsEncrypted
            this.kmsKey = x.kmsKey
            this.nfsFileShareDefaults = x.nfsFileShareDefaults
            this.notificationPolicy = x.notificationPolicy
            this.objectAcl = x.objectAcl
            this.readOnly = x.readOnly
            this.requesterPays = x.requesterPays
            this.squash = x.squash
        }

        override fun build(): UpdateNfsFileShareRequest = UpdateNfsFileShareRequest(this)
        override fun cacheAttributes(cacheAttributes: CacheAttributes): FluentBuilder = apply { this.cacheAttributes = cacheAttributes }
        override fun clientList(clientList: List<String>): FluentBuilder = apply { this.clientList = clientList }
        override fun defaultStorageClass(defaultStorageClass: String): FluentBuilder = apply { this.defaultStorageClass = defaultStorageClass }
        override fun fileShareArn(fileShareArn: String): FluentBuilder = apply { this.fileShareArn = fileShareArn }
        override fun fileShareName(fileShareName: String): FluentBuilder = apply { this.fileShareName = fileShareName }
        override fun guessMimeTypeEnabled(guessMimeTypeEnabled: Boolean): FluentBuilder = apply { this.guessMimeTypeEnabled = guessMimeTypeEnabled }
        override fun kmsEncrypted(kmsEncrypted: Boolean): FluentBuilder = apply { this.kmsEncrypted = kmsEncrypted }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun nfsFileShareDefaults(nfsFileShareDefaults: NfsFileShareDefaults): FluentBuilder = apply { this.nfsFileShareDefaults = nfsFileShareDefaults }
        override fun notificationPolicy(notificationPolicy: String): FluentBuilder = apply { this.notificationPolicy = notificationPolicy }
        override fun objectAcl(objectAcl: ObjectAcl): FluentBuilder = apply { this.objectAcl = objectAcl }
        override fun readOnly(readOnly: Boolean): FluentBuilder = apply { this.readOnly = readOnly }
        override fun requesterPays(requesterPays: Boolean): FluentBuilder = apply { this.requesterPays = requesterPays }
        override fun squash(squash: String): FluentBuilder = apply { this.squash = squash }
    }
}
