// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.storagegateway.model



class UpdateGatewayInformationRequest private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
     * to monitor and log events in the gateway.
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
     * Logs?
     */
    val cloudWatchLogGroupArn: String? = builder.cloudWatchLogGroupArn
    /**
     * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
     * operation to return a list of gateways for your account and Region.
     */
    val gatewayArn: String? = builder.gatewayArn
    /**
     * Specifies the size of the gateway's metadata cache.
     */
    val gatewayCapacity: GatewayCapacity? = builder.gatewayCapacity
    /**
     * The name you configured for your gateway.
     */
    val gatewayName: String? = builder.gatewayName
    /**
     * A value that indicates the time zone of the gateway.
     */
    val gatewayTimezone: String? = builder.gatewayTimezone

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateGatewayInformationRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateGatewayInformationRequest(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("gatewayArn=$gatewayArn,")
        append("gatewayCapacity=$gatewayCapacity,")
        append("gatewayName=$gatewayName,")
        append("gatewayTimezone=$gatewayTimezone)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (gatewayArn?.hashCode() ?: 0)
        result = 31 * result + (gatewayCapacity?.hashCode() ?: 0)
        result = 31 * result + (gatewayName?.hashCode() ?: 0)
        result = 31 * result + (gatewayTimezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateGatewayInformationRequest

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (gatewayArn != other.gatewayArn) return false
        if (gatewayCapacity != other.gatewayCapacity) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayTimezone != other.gatewayTimezone) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateGatewayInformationRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateGatewayInformationRequest
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
         * to monitor and log events in the gateway.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
         * Logs?
         */
        fun cloudWatchLogGroupArn(cloudWatchLogGroupArn: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        fun gatewayArn(gatewayArn: String): FluentBuilder
        /**
         * Specifies the size of the gateway's metadata cache.
         */
        fun gatewayCapacity(gatewayCapacity: GatewayCapacity): FluentBuilder
        /**
         * The name you configured for your gateway.
         */
        fun gatewayName(gatewayName: String): FluentBuilder
        /**
         * A value that indicates the time zone of the gateway.
         */
        fun gatewayTimezone(gatewayTimezone: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon CloudWatch log group that you want to use
         * to monitor and log events in the gateway.
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/WhatIsCloudWatchLogs.html">What is Amazon CloudWatch
         * Logs?
         */
        var cloudWatchLogGroupArn: String?
        /**
         * The Amazon Resource Name (ARN) of the gateway. Use the ListGateways
         * operation to return a list of gateways for your account and Region.
         */
        var gatewayArn: String?
        /**
         * Specifies the size of the gateway's metadata cache.
         */
        var gatewayCapacity: GatewayCapacity?
        /**
         * The name you configured for your gateway.
         */
        var gatewayName: String?
        /**
         * A value that indicates the time zone of the gateway.
         */
        var gatewayTimezone: String?

        fun build(): UpdateGatewayInformationRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cloudWatchLogGroupArn: String? = null
        override var gatewayArn: String? = null
        override var gatewayCapacity: GatewayCapacity? = null
        override var gatewayName: String? = null
        override var gatewayTimezone: String? = null

        constructor(x: UpdateGatewayInformationRequest) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.gatewayArn = x.gatewayArn
            this.gatewayCapacity = x.gatewayCapacity
            this.gatewayName = x.gatewayName
            this.gatewayTimezone = x.gatewayTimezone
        }

        override fun build(): UpdateGatewayInformationRequest = UpdateGatewayInformationRequest(this)
        override fun cloudWatchLogGroupArn(cloudWatchLogGroupArn: String): FluentBuilder = apply { this.cloudWatchLogGroupArn = cloudWatchLogGroupArn }
        override fun gatewayArn(gatewayArn: String): FluentBuilder = apply { this.gatewayArn = gatewayArn }
        override fun gatewayCapacity(gatewayCapacity: GatewayCapacity): FluentBuilder = apply { this.gatewayCapacity = gatewayCapacity }
        override fun gatewayName(gatewayName: String): FluentBuilder = apply { this.gatewayName = gatewayName }
        override fun gatewayTimezone(gatewayTimezone: String): FluentBuilder = apply { this.gatewayTimezone = gatewayTimezone }
    }
}
